/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.notification;

import eu.hansolo.enzo.notification.NotificationEvent;
import java.util.stream.IntStream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;

public class Notification {
    public static final Image INFO_ICON = new Image(Notifier.class.getResourceAsStream("info.png"));
    public static final Image WARNING_ICON = new Image(Notifier.class.getResourceAsStream("warning.png"));
    public static final Image SUCCESS_ICON = new Image(Notifier.class.getResourceAsStream("success.png"));
    public static final Image ERROR_ICON = new Image(Notifier.class.getResourceAsStream("error.png"));
    public final String TITLE;
    public final String MESSAGE;
    public final Image IMAGE;

    public Notification(String TITLE, String MESSAGE) {
        this(TITLE, MESSAGE, null);
    }

    public Notification(String MESSAGE, Image IMAGE) {
        this("", MESSAGE, IMAGE);
    }

    public Notification(String TITLE, String MESSAGE, Image IMAGE) {
        this.TITLE = TITLE;
        this.MESSAGE = MESSAGE;
        this.IMAGE = IMAGE;
    }

    public static enum Notifier {
        INSTANCE;

        private static final double ICON_WIDTH = 24.0;
        private static final double ICON_HEIGHT = 24.0;
        private static double width;
        private static double height;
        private static double offsetX;
        private static double offsetY;
        private static double spacingY;
        private static Pos popupLocation;
        private static Stage stageRef;
        private Duration popupLifetime;
        private Duration popupAnimationTime;
        private Stage stage;
        private Scene scene;
        private ObservableList<Popup> popups;
        private ObjectProperty<EventHandler<NotificationEvent>> onNotificationPressed = new ObjectPropertyBase<EventHandler<NotificationEvent>>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "onNotificationPressed";
            }
        };
        private ObjectProperty<EventHandler<NotificationEvent>> onShowNotification = new ObjectPropertyBase<EventHandler<NotificationEvent>>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "onShowNotification";
            }
        };
        private ObjectProperty<EventHandler<NotificationEvent>> onHideNotification = new ObjectPropertyBase<EventHandler<NotificationEvent>>(){

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "onHideNotification";
            }
        };

        private Notifier() {
            this.init();
            this.initGraphics();
        }

        private void init() {
            this.popupLifetime = Duration.millis((double)5000.0);
            this.popupAnimationTime = Duration.millis((double)500.0);
            this.popups = FXCollections.observableArrayList();
        }

        private void initGraphics() {
            this.scene = new Scene((Parent)new Region());
            this.scene.setFill(null);
            this.scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("notifier.css").toExternalForm());
            this.stage = new Stage();
            this.stage.setMinWidth(0.0);
            this.stage.setMinHeight(0.0);
            this.stage.setMaxWidth(0.0);
            this.stage.setMaxHeight(0.0);
            this.stage.setWidth(0.0);
            this.stage.setHeight(0.0);
            this.stage.initModality(Modality.NONE);
            this.stage.setResizable(false);
            this.stage.initStyle(StageStyle.UTILITY);
            this.stage.setScene(this.scene);
            this.stage.setAlwaysOnTop(true);
        }

        public static void setPopupLocation(Stage STAGE_REF, Pos POPUP_LOCATION) {
            if (null != STAGE_REF) {
                Notifier.INSTANCE.stage.initOwner((Window)STAGE_REF);
                stageRef = STAGE_REF;
            }
            popupLocation = POPUP_LOCATION;
        }

        public static void setNotificationOwner(Stage OWNER) {
            Notifier.INSTANCE.stage.initOwner((Window)OWNER);
        }

        public static void setOffsetX(double OFFSET_X) {
            offsetX = OFFSET_X;
        }

        public static void setOffsetY(double OFFSET_Y) {
            offsetY = OFFSET_Y;
        }

        public static void setWidth(double WIDTH) {
            width = WIDTH;
        }

        public static void setHeight(double HEIGHT) {
            height = HEIGHT;
        }

        public static void setSpacingY(double SPACING_Y) {
            spacingY = SPACING_Y;
        }

        public void stop() {
            this.popups.clear();
            this.stage.close();
        }

        public Duration getPopupLifetime() {
            return this.popupLifetime;
        }

        public void setPopupLifetime(Duration POPUP_LIFETIME) {
            this.popupLifetime = Duration.millis((double)this.clamp(2000.0, 20000.0, POPUP_LIFETIME.toMillis()));
        }

        public Duration getPopupAnimationTime() {
            return this.popupAnimationTime;
        }

        public void setPopupAnimationTime(Duration POPUP_ANIMATION_TIME) {
            this.popupAnimationTime = Duration.millis((double)this.clamp(0.0, 1000.0, POPUP_ANIMATION_TIME.toMillis()));
        }

        public void setStyleSheet(String STYLE_SHEET) {
            this.scene.getStylesheets().add((Object)STYLE_SHEET);
        }

        public void notify(Notification NOTIFICATION) {
            this.preOrder();
            this.showPopup(NOTIFICATION);
        }

        public void notify(String TITLE, String MESSAGE, Image IMAGE) {
            this.notify(new Notification(TITLE, MESSAGE, IMAGE));
        }

        public void notifyInfo(String TITLE, String MESSAGE) {
            this.notify(new Notification(TITLE, MESSAGE, INFO_ICON));
        }

        public void notifyWarning(String TITLE, String MESSAGE) {
            this.notify(new Notification(TITLE, MESSAGE, WARNING_ICON));
        }

        public void notifySuccess(String TITLE, String MESSAGE) {
            this.notify(new Notification(TITLE, MESSAGE, SUCCESS_ICON));
        }

        public void notifyError(String TITLE, String MESSAGE) {
            this.notify(new Notification(TITLE, MESSAGE, ERROR_ICON));
        }

        public boolean isAlwaysOnTop() {
            return this.stage.isAlwaysOnTop();
        }

        public void setAlwaysOnTop(boolean ALWAYS_ON_TOP) {
            this.stage.setAlwaysOnTop(ALWAYS_ON_TOP);
        }

        private double clamp(double MIN, double MAX, double VALUE) {
            if (VALUE < MIN) {
                return MIN;
            }
            if (VALUE > MAX) {
                return MAX;
            }
            return VALUE;
        }

        private void preOrder() {
            if (this.popups.isEmpty()) {
                return;
            }
            IntStream.range(0, this.popups.size()).parallel().forEachOrdered(i -> {
                switch (popupLocation) {
                    case TOP_LEFT: 
                    case TOP_CENTER: 
                    case TOP_RIGHT: {
                        ((Popup)this.popups.get(i)).setY(((Popup)this.popups.get(i)).getY() + height + spacingY);
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_CENTER: 
                    case BOTTOM_RIGHT: {
                        ((Popup)this.popups.get(i)).setY(((Popup)this.popups.get(i)).getY() - height - spacingY);
                        break;
                    }
                    default: {
                        ((Popup)this.popups.get(i)).setY(((Popup)this.popups.get(i)).getY() - height - spacingY);
                    }
                }
            });
        }

        private void showPopup(Notification NOTIFICATION) {
            Label title = new Label(NOTIFICATION.TITLE);
            title.getStyleClass().add((Object)"title");
            ImageView icon = new ImageView(NOTIFICATION.IMAGE);
            icon.setFitWidth(24.0);
            icon.setFitHeight(24.0);
            Label message = new Label(NOTIFICATION.MESSAGE, (Node)icon);
            message.getStyleClass().add((Object)"message");
            VBox popupLayout = new VBox();
            popupLayout.setSpacing(10.0);
            popupLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            popupLayout.getChildren().addAll((Object[])new Node[]{title, message});
            StackPane popupContent = new StackPane();
            popupContent.setPrefSize(width, height);
            popupContent.getStyleClass().add((Object)"notification");
            popupContent.getChildren().addAll((Object[])new Node[]{popupLayout});
            Popup POPUP = new Popup();
            POPUP.setX(this.getX());
            POPUP.setY(this.getY());
            POPUP.getContent().add((Object)popupContent);
            POPUP.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new WeakEventHandler(event -> this.fireNotificationEvent(new NotificationEvent(NOTIFICATION, (Object)this, (EventTarget)POPUP, NotificationEvent.NOTIFICATION_PRESSED))));
            this.popups.add((Object)POPUP);
            KeyValue fadeOutBegin = new KeyValue((WritableValue)POPUP.opacityProperty(), (Object)1.0);
            KeyValue fadeOutEnd = new KeyValue((WritableValue)POPUP.opacityProperty(), (Object)0.0);
            KeyFrame kfBegin = new KeyFrame(Duration.ZERO, new KeyValue[]{fadeOutBegin});
            KeyFrame kfEnd = new KeyFrame(this.popupAnimationTime, new KeyValue[]{fadeOutEnd});
            Timeline timeline = new Timeline(new KeyFrame[]{kfBegin, kfEnd});
            timeline.setDelay(this.popupLifetime);
            timeline.setOnFinished(actionEvent -> Platform.runLater(() -> {
                POPUP.hide();
                this.popups.remove((Object)POPUP);
                this.fireNotificationEvent(new NotificationEvent(NOTIFICATION, (Object)this, (EventTarget)POPUP, NotificationEvent.HIDE_NOTIFICATION));
            }));
            if (this.stage.isShowing()) {
                this.stage.toFront();
            } else {
                this.stage.show();
            }
            POPUP.show((Window)this.stage);
            this.fireNotificationEvent(new NotificationEvent(NOTIFICATION, (Object)this, (EventTarget)POPUP, NotificationEvent.SHOW_NOTIFICATION));
            timeline.play();
        }

        private double getX() {
            if (null == stageRef) {
                return this.calcX(0.0, Screen.getPrimary().getBounds().getWidth());
            }
            return this.calcX(stageRef.getX(), stageRef.getWidth());
        }

        private double getY() {
            if (null == stageRef) {
                return this.calcY(0.0, Screen.getPrimary().getBounds().getHeight());
            }
            return this.calcY(stageRef.getY(), stageRef.getHeight());
        }

        private double calcX(double LEFT, double TOTAL_WIDTH) {
            switch (popupLocation) {
                case TOP_LEFT: 
                case CENTER_LEFT: 
                case BOTTOM_LEFT: {
                    return LEFT + offsetX;
                }
                case TOP_CENTER: 
                case CENTER: 
                case BOTTOM_CENTER: {
                    return LEFT + (TOTAL_WIDTH - width) * 0.5 - offsetX;
                }
                case TOP_RIGHT: 
                case CENTER_RIGHT: 
                case BOTTOM_RIGHT: {
                    return LEFT + TOTAL_WIDTH - width - offsetX;
                }
            }
            return 0.0;
        }

        private double calcY(double TOP, double TOTAL_HEIGHT) {
            switch (popupLocation) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    return TOP + offsetY;
                }
                case CENTER_LEFT: 
                case CENTER: 
                case CENTER_RIGHT: {
                    return TOP + (TOTAL_HEIGHT - height) / 2.0 - offsetY;
                }
                case BOTTOM_LEFT: 
                case BOTTOM_CENTER: 
                case BOTTOM_RIGHT: {
                    return TOP + TOTAL_HEIGHT - height - offsetY;
                }
            }
            return 0.0;
        }

        public final ObjectProperty<EventHandler<NotificationEvent>> onNotificationPressedProperty() {
            return this.onNotificationPressed;
        }

        public final void setOnNotificationPressed(EventHandler<NotificationEvent> value) {
            this.onNotificationPressedProperty().set(value);
        }

        public final EventHandler<NotificationEvent> getOnNotificationPressed() {
            return (EventHandler)this.onNotificationPressedProperty().get();
        }

        public final ObjectProperty<EventHandler<NotificationEvent>> onShowNotificationProperty() {
            return this.onShowNotification;
        }

        public final void setOnShowNotification(EventHandler<NotificationEvent> value) {
            this.onShowNotificationProperty().set(value);
        }

        public final EventHandler<NotificationEvent> getOnShowNotification() {
            return (EventHandler)this.onShowNotificationProperty().get();
        }

        public final ObjectProperty<EventHandler<NotificationEvent>> onHideNotificationProperty() {
            return this.onHideNotification;
        }

        public final void setOnHideNotification(EventHandler<NotificationEvent> value) {
            this.onHideNotificationProperty().set(value);
        }

        public final EventHandler<NotificationEvent> getOnHideNotification() {
            return (EventHandler)this.onHideNotificationProperty().get();
        }

        public void fireNotificationEvent(NotificationEvent EVENT) {
            EventType TYPE = EVENT.getEventType();
            Object HANDLER = NotificationEvent.NOTIFICATION_PRESSED == TYPE ? this.getOnNotificationPressed() : (NotificationEvent.SHOW_NOTIFICATION == TYPE ? this.getOnShowNotification() : (NotificationEvent.HIDE_NOTIFICATION == TYPE ? this.getOnHideNotification() : null));
            if (null == HANDLER) {
                return;
            }
            HANDLER.handle((Event)EVENT);
        }

        static {
            width = 300.0;
            height = 80.0;
            offsetX = 0.0;
            offsetY = 25.0;
            spacingY = 5.0;
            popupLocation = Pos.TOP_RIGHT;
            stageRef = null;
        }
    }
}

