/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.onoffswitch;

import eu.hansolo.enzo.common.Symbol;
import eu.hansolo.enzo.common.SymbolType;
import eu.hansolo.enzo.onoffswitch.SelectionEvent;
import eu.hansolo.enzo.onoffswitch.skin.IconSwitchSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class IconSwitch
extends Control
implements Toggle {
    public static final Color DEFAULT_SWITCH_COLOR = Color.WHITE;
    public static final Color DEFAULT_THUMB_COLOR = Color.WHITE;
    public static final Color DEFAULT_SYMBOL_COLOR = Color.DARKGRAY;
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final Symbol symbol;
    private ObjectProperty<Paint> switchColor;
    private ObjectProperty<Paint> thumbColor;
    private StringProperty text;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private BooleanProperty selected;
    private ObjectProperty<EventHandler<SelectionEvent>> onSelect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onSelect";
        }
    };
    private ObjectProperty<EventHandler<SelectionEvent>> onDeselect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onDeselect";
        }
    };

    public IconSwitch() {
        this.getStyleClass().setAll((Object[])new String[]{"icon-switch"});
        this.symbol = new Symbol(SymbolType.NONE, 19.0, DEFAULT_SYMBOL_COLOR, true);
    }

    public final boolean isSelected() {
        return null == this.selected ? false : this.selected.get();
    }

    public final void setSelected(boolean ON) {
        this.selectedProperty().set(ON);
    }

    public final BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(){

                protected void invalidated() {
                    if (null != IconSwitch.this.getToggleGroup()) {
                        if (this.get()) {
                            IconSwitch.this.getToggleGroup().selectToggle((Toggle)IconSwitch.this);
                        } else if (IconSwitch.this.getToggleGroup().getSelectedToggle() == IconSwitch.this) {
                            IconSwitch.this.getToggleGroup().selectToggle(null);
                        }
                    }
                    if (IconSwitch.this.selected.get()) {
                        IconSwitch.this.fireSelectionEvent(new SelectionEvent((Object)this, null, SelectionEvent.SELECT));
                    } else {
                        IconSwitch.this.fireSelectionEvent(new SelectionEvent((Object)this, null, SelectionEvent.DESELECT));
                    }
                    IconSwitch.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public final ToggleGroup getToggleGroup() {
        return null == this.toggleGroup ? null : (ToggleGroup)this.toggleGroup.get();
    }

    public final void setToggleGroup(ToggleGroup value) {
        this.toggleGroupProperty().set((Object)value);
    }

    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (null == this.toggleGroup) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup oldToggleGroup;

                protected void invalidated() {
                    ToggleGroup toggleGroup = (ToggleGroup)this.get();
                    if (null != toggleGroup && !toggleGroup.getToggles().contains((Object)IconSwitch.this)) {
                        if (this.oldToggleGroup != null) {
                            this.oldToggleGroup.getToggles().remove((Object)IconSwitch.this);
                        }
                        toggleGroup.getToggles().add((Object)IconSwitch.this);
                    } else if (null == toggleGroup) {
                        this.oldToggleGroup.getToggles().remove((Object)IconSwitch.this);
                    }
                    this.oldToggleGroup = toggleGroup;
                }

                public Object getBean() {
                    return IconSwitch.this;
                }

                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    public final SymbolType getSymbolType() {
        return this.symbol.getSymbolType();
    }

    public final void setSymbolType(SymbolType SYMBOL_TYPE) {
        this.symbol.setSymbolType(SYMBOL_TYPE);
    }

    public final ObjectProperty<SymbolType> symbolTypeProperty() {
        return this.symbol.symbolTypeProperty();
    }

    public final Color getSymbolColor() {
        return this.symbol.getColor();
    }

    public final void setSymbolColor(Color SYMBOL_COLOR) {
        this.symbol.setColor(SYMBOL_COLOR);
    }

    public final ObjectProperty<Color> symbolColorProperty() {
        return this.symbol.colorProperty();
    }

    public final String getText() {
        return null == this.text ? "" : (String)this.text.get();
    }

    public final void setText(String TEXT) {
        this.textProperty().set((Object)TEXT);
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", "");
        }
        return this.text;
    }

    public final Symbol getSymbol() {
        return this.symbol;
    }

    public final Paint getSwitchColor() {
        return null == this.switchColor ? DEFAULT_SWITCH_COLOR : (Paint)this.switchColor.get();
    }

    public final void setSwitchColor(Paint value) {
        this.switchColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> switchColorProperty() {
        if (null == this.switchColor) {
            this.switchColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SWITCH_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SWITCH_COLOR;
                }

                public Object getBean() {
                    return IconSwitch.this;
                }

                public String getName() {
                    return "switchColor";
                }
            };
        }
        return this.switchColor;
    }

    public final Paint getThumbColor() {
        return null == this.thumbColor ? DEFAULT_THUMB_COLOR : (Paint)this.thumbColor.get();
    }

    public final void setThumbColor(Paint value) {
        this.thumbColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> thumbColorProperty() {
        if (null == this.thumbColor) {
            this.thumbColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_THUMB_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.THUMB_COLOR;
                }

                public Object getBean() {
                    return IconSwitch.this;
                }

                public String getName() {
                    return "thumbColor";
                }
            };
        }
        return this.thumbColor;
    }

    protected Skin createDefaultSkin() {
        return new IconSwitchSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("iconswitch.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return IconSwitch.getClassCssMetaData();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onSelectProperty() {
        return this.onSelect;
    }

    public final void setOnSelect(EventHandler<SelectionEvent> value) {
        this.onSelectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnSelect() {
        return (EventHandler)this.onSelectProperty().get();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onDeselectProperty() {
        return this.onDeselect;
    }

    public final void setOnDeselect(EventHandler<SelectionEvent> value) {
        this.onDeselectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnDeselect() {
        return (EventHandler)this.onDeselectProperty().get();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        this.fireEvent(EVENT);
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SelectionEvent.SELECT == TYPE ? this.getOnSelect() : (SelectionEvent.DESELECT == TYPE ? this.getOnDeselect() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    private static class StyleableProperties {
        private static final CssMetaData<IconSwitch, Paint> SWITCH_COLOR = new CssMetaData<IconSwitch, Paint>("-switch-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_SWITCH_COLOR){

            public boolean isSettable(IconSwitch iconSwitch) {
                return null == iconSwitch.switchColor || !iconSwitch.switchColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(IconSwitch iconSwitch) {
                return (StyleableProperty)iconSwitch.switchColorProperty();
            }

            public Color getInitialValue(IconSwitch iconSwitch) {
                return (Color)iconSwitch.getSwitchColor();
            }
        };
        private static final CssMetaData<IconSwitch, Paint> THUMB_COLOR = new CssMetaData<IconSwitch, Paint>("-thumb-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_THUMB_COLOR){

            public boolean isSettable(IconSwitch iconSwitch) {
                return null == iconSwitch.thumbColor || !iconSwitch.thumbColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(IconSwitch iconSwitch) {
                return (StyleableProperty)iconSwitch.thumbColorProperty();
            }

            public Color getInitialValue(IconSwitch iconSwitch) {
                return (Color)iconSwitch.getThumbColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SWITCH_COLOR, THUMB_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

