/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.onoffswitch.skin;

import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.onoffswitch.OnOffSwitch;
import java.io.InputStream;
import javafx.animation.TranslateTransition;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class OnOffSwitchSkin
extends SkinBase<OnOffSwitch>
implements Skin<OnOffSwitch> {
    private static final double PREFERRED_WIDTH = 64.0;
    private static final double PREFERRED_HEIGHT = 32.0;
    private static final double MINIMUM_WIDTH = 16.0;
    private static final double MINIMUM_HEIGHT = 8.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double width;
    private double height;
    private Pane pane;
    private double aspectRatio = 0.5;
    private Region background;
    private Region thumb;
    private Text selectedText;
    private Text deselectedText;
    private Font font;
    private TranslateTransition moveToDeselected;
    private TranslateTransition moveToSelected;

    public OnOffSwitchSkin(OnOffSwitch CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((OnOffSwitch)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((OnOffSwitch)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((OnOffSwitch)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((OnOffSwitch)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((OnOffSwitch)this.getSkinnable()).getPrefWidth() > 0.0 && ((OnOffSwitch)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((OnOffSwitch)this.getSkinnable()).setPrefSize(((OnOffSwitch)this.getSkinnable()).getPrefWidth(), ((OnOffSwitch)this.getSkinnable()).getPrefHeight());
            } else {
                ((OnOffSwitch)this.getSkinnable()).setPrefSize(64.0, 32.0);
            }
        }
        if (Double.compare(((OnOffSwitch)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((OnOffSwitch)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((OnOffSwitch)this.getSkinnable()).setMinSize(16.0, 8.0);
        }
        if (Double.compare(((OnOffSwitch)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((OnOffSwitch)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((OnOffSwitch)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((OnOffSwitch)this.getSkinnable()).getPrefWidth() != 64.0 || ((OnOffSwitch)this.getSkinnable()).getPrefHeight() != 32.0) {
            this.aspectRatio = ((OnOffSwitch)this.getSkinnable()).getPrefHeight() / ((OnOffSwitch)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/enzo/fonts/opensans-semibold.ttf"), (double)16.0);
        this.font = Font.font((String)"Open Sans", (double)16.0);
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.background.setStyle("-switch-color: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getSwitchColor()) + ";");
        this.selectedText = new Text("1");
        this.selectedText.setFont(this.font);
        this.selectedText.getStyleClass().setAll((Object[])new String[]{"selected-text"});
        this.selectedText.setStyle("-text-color-on: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getTextColorOn()) + ";");
        this.deselectedText = new Text("0");
        this.deselectedText.setFont(this.font);
        this.deselectedText.getStyleClass().setAll((Object[])new String[]{"deselected-text"});
        this.deselectedText.setStyle("-text-color-off: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getTextColorOff()) + ";");
        this.thumb = new Region();
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setMouseTransparent(true);
        this.thumb.setStyle("-thumb-color: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getThumbColor()) + ";");
        this.pane = new Pane(new Node[]{this.background, this.selectedText, this.deselectedText, this.thumb});
        this.pane.getStyleClass().setAll((Object[])new String[]{"on-off-switch"});
        this.moveToDeselected = new TranslateTransition(Duration.millis((double)180.0), (Node)this.thumb);
        this.moveToSelected = new TranslateTransition(Duration.millis((double)180.0), (Node)this.thumb);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((OnOffSwitch)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((OnOffSwitch)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((OnOffSwitch)this.getSkinnable()).switchColorProperty().addListener(observable -> this.handleControlPropertyChanged("SWITCH_COLOR"));
        ((OnOffSwitch)this.getSkinnable()).textColorOnProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT_ON_COLOR"));
        ((OnOffSwitch)this.getSkinnable()).textColorOffProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT_OFF_COLOR"));
        ((OnOffSwitch)this.getSkinnable()).thumbColorProperty().addListener(observable -> this.handleControlPropertyChanged("THUMB_COLOR"));
        ((OnOffSwitch)this.getSkinnable()).selectedProperty().addListener(observable -> this.handleControlPropertyChanged("SELECTED"));
        this.pane.setOnMouseClicked(mouseEvent -> {
            if (null == ((OnOffSwitch)this.getSkinnable()).getToggleGroup() || ((OnOffSwitch)this.getSkinnable()).getToggleGroup().getToggles().isEmpty()) {
                ((OnOffSwitch)this.getSkinnable()).setSelected(!((OnOffSwitch)this.getSkinnable()).isSelected());
            } else {
                ((OnOffSwitch)this.getSkinnable()).setSelected(true);
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("SWITCH_COLOR".equals(PROPERTY)) {
            this.background.setStyle("-switch-color: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getSwitchColor()) + ";");
        } else if ("TEXT_ON_COLOR".equals(PROPERTY)) {
            this.selectedText.setStyle("-text-color-selected: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getTextColorOn()) + ";");
        } else if ("TEXT_OFF_COLOR".equals(PROPERTY)) {
            this.deselectedText.setStyle("-text-color-deselected: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getTextColorOff()) + ";");
        } else if ("THUMB_COLOR".equals(PROPERTY)) {
            this.thumb.setStyle("-thumb-color: " + Util.colorToCss((Color)((OnOffSwitch)this.getSkinnable()).getThumbColor()) + ";");
        } else if ("SELECTED".equals(PROPERTY)) {
            if (((OnOffSwitch)this.getSkinnable()).isSelected()) {
                this.moveToSelected.play();
            } else {
                this.moveToDeselected.play();
            }
        }
    }

    private void resize() {
        this.width = ((OnOffSwitch)this.getSkinnable()).getWidth();
        this.height = ((OnOffSwitch)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
            this.pane.setMaxSize(this.width, this.height);
            this.font = Font.font((String)"Open Sans", (FontWeight)FontWeight.EXTRA_BOLD, (FontPosture)FontPosture.REGULAR, (double)(0.5 * this.height));
            this.background.setPrefSize(this.width, this.height);
            this.selectedText.setFont(this.font);
            this.selectedText.setTextOrigin(VPos.CENTER);
            this.selectedText.relocate(this.height * 0.3125, (this.height - this.selectedText.getLayoutBounds().getHeight()) * 0.5);
            this.deselectedText.setFont(this.font);
            this.deselectedText.setTextOrigin(VPos.CENTER);
            this.deselectedText.relocate(this.width - this.height * 0.3125 - this.deselectedText.getLayoutBounds().getWidth(), (this.height - this.deselectedText.getLayoutBounds().getHeight()) * 0.5);
            this.thumb.setPrefSize(this.height * 0.75, this.height * 0.75);
            this.thumb.setTranslateX(((OnOffSwitch)this.getSkinnable()).isSelected() ? this.height * 1.125 : this.height * 0.125);
            this.thumb.setTranslateY(this.height * 0.125);
            this.moveToDeselected.setFromX(this.height * 1.125);
            this.moveToDeselected.setToX(this.height * 0.125);
            this.moveToSelected.setFromX(this.height * 0.125);
            this.moveToSelected.setToX(this.height * 1.125);
        }
    }
}

