/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.sixteensegment;

import eu.hansolo.enzo.sixteensegment.SixteenSegment;
import eu.hansolo.enzo.sixteensegment.SixteenSegmentBuilder;
import java.util.Locale;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static final Random RND = new Random();
    private long lastTimerCall;
    private AnimationTimer timer;
    private SixteenSegment seg0;
    private SixteenSegment seg1;
    private SixteenSegment seg2;
    private SixteenSegment seg3;
    private SixteenSegment seg4;
    private SixteenSegment seg5;

    public void init() {
        this.seg0 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character(0).segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.seg1 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character(0).dotOn(true).segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.seg2 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character(0).segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.seg3 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character(0).segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.seg4 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character(Character.toString('\u00ba')).segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.seg5 = ((SixteenSegmentBuilder)SixteenSegmentBuilder.create().prefSize(200.0, 267.0)).character("C").segmentStyle(SixteenSegment.SegmentStyle.RED).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Demo.this.lastTimerCall + 5000000000L) {
                    double v = RND.nextDouble() * 20.0 + 10.0;
                    if (Double.compare(v, 10.0) > 0 && Double.compare(v, 16.0) <= 0) {
                        Demo.this.setLcdColor(SixteenSegment.SegmentStyle.BLUE);
                    } else if (Double.compare(v, 16.0) > 0 && Double.compare(v, 20.0) <= 0) {
                        Demo.this.setLcdColor(SixteenSegment.SegmentStyle.CYAN);
                    } else if (Double.compare(v, 20.0) > 0 && Double.compare(v, 24.0) <= 0) {
                        Demo.this.setLcdColor(SixteenSegment.SegmentStyle.GREEN);
                    } else if (Double.compare(v, 24.0) > 0 && Double.compare(v, 28.0) <= 0) {
                        Demo.this.setLcdColor(SixteenSegment.SegmentStyle.YELLOW);
                    } else {
                        Demo.this.setLcdColor(SixteenSegment.SegmentStyle.RED);
                    }
                    String value = String.format(Locale.US, "%.2f", v);
                    int offset = value.length() == 5 ? 0 : 1;
                    Demo.this.seg0.setCharacter(offset == 0 ? value.substring(0, 1) : "0");
                    Demo.this.seg1.setCharacter(value.substring(1 - offset, 2 - offset));
                    Demo.this.seg2.setCharacter(value.substring(3 - offset, 4 - offset));
                    Demo.this.seg3.setCharacter(value.substring(4 - offset, 5 - offset));
                    Demo.this.lastTimerCall = now;
                }
            }
        };
    }

    private void setLcdColor(SixteenSegment.SegmentStyle STYLE) {
        this.seg0.setSegmentStyle(STYLE);
        this.seg1.setSegmentStyle(STYLE);
        this.seg2.setSegmentStyle(STYLE);
        this.seg3.setSegmentStyle(STYLE);
        this.seg4.setSegmentStyle(STYLE);
        this.seg5.setSegmentStyle(STYLE);
    }

    public void start(Stage stage) {
        HBox lcd = new HBox();
        lcd.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        lcd.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        lcd.setSpacing(10.0);
        lcd.setAlignment(Pos.CENTER);
        lcd.setFillHeight(false);
        HBox.setMargin((Node)this.seg3, (Insets)new Insets(0.0, 20.0, 0.0, 0.0));
        lcd.getChildren().addAll((Object[])new Node[]{this.seg0, this.seg1, this.seg2, this.seg3, this.seg4, this.seg5});
        StackPane pane = new StackPane();
        pane.getChildren().setAll((Object[])new Node[]{lcd});
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("Sixteen Segment DemoGauge");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

