/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.sixteensegment.skin;

import eu.hansolo.enzo.sixteensegment.SixteenSegment;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class SixteenSegmentSkin
extends SkinBase<SixteenSegment>
implements Skin<SixteenSegment> {
    private static final double PREFERRED_WIDTH = 268.0;
    private static final double PREFERRED_HEIGHT = 357.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Region segmentA1;
    private Region segmentA2;
    private Region segmentB;
    private Region segmentC;
    private Region segmentD2;
    private Region segmentD1;
    private Region segmentE;
    private Region segmentF;
    private Region segmentG;
    private Region segmentH;
    private Region segmentI;
    private Region segmentL;
    private Region segmentM;
    private Region segmentN;
    private Region segmentP;
    private Region segmentK;
    private Region segmentDot;
    private Map<SixteenSegment.Segment, Region> segmentMap;

    public SixteenSegmentSkin(SixteenSegment CONTROL) {
        super((Control)CONTROL);
        aspectRatio = 1.3320895522388059;
        this.pane = new Pane();
        this.segmentMap = new HashMap<SixteenSegment.Segment, Region>(17);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SixteenSegment)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SixteenSegment)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SixteenSegment)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SixteenSegment)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SixteenSegment)this.getSkinnable()).getPrefWidth() > 0.0 && ((SixteenSegment)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SixteenSegment)this.getSkinnable()).setPrefSize(((SixteenSegment)this.getSkinnable()).getPrefWidth(), ((SixteenSegment)this.getSkinnable()).getPrefHeight());
            } else {
                ((SixteenSegment)this.getSkinnable()).setPrefSize(268.0, 357.0);
            }
        }
        if (Double.compare(((SixteenSegment)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SixteenSegment)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SixteenSegment)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((SixteenSegment)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SixteenSegment)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SixteenSegment)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((SixteenSegment)this.getSkinnable()).getPrefWidth() != 268.0 || ((SixteenSegment)this.getSkinnable()).getPrefHeight() != 357.0) {
            aspectRatio = ((SixteenSegment)this.getSkinnable()).getPrefHeight() / ((SixteenSegment)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.segmentA1 = new Region();
        this.segmentA1.getStyleClass().setAll((Object[])new String[]{"a1"});
        this.segmentMap.put(SixteenSegment.Segment.A1, this.segmentA1);
        this.segmentA2 = new Region();
        this.segmentA2.getStyleClass().setAll((Object[])new String[]{"a2"});
        this.segmentMap.put(SixteenSegment.Segment.A2, this.segmentA2);
        this.segmentB = new Region();
        this.segmentB.getStyleClass().setAll((Object[])new String[]{"b"});
        this.segmentMap.put(SixteenSegment.Segment.B, this.segmentB);
        this.segmentC = new Region();
        this.segmentC.getStyleClass().setAll((Object[])new String[]{"c"});
        this.segmentMap.put(SixteenSegment.Segment.C, this.segmentC);
        this.segmentD2 = new Region();
        this.segmentD2.getStyleClass().setAll((Object[])new String[]{"d2"});
        this.segmentMap.put(SixteenSegment.Segment.D2, this.segmentD2);
        this.segmentD1 = new Region();
        this.segmentD1.getStyleClass().setAll((Object[])new String[]{"d1"});
        this.segmentMap.put(SixteenSegment.Segment.D1, this.segmentD1);
        this.segmentE = new Region();
        this.segmentE.getStyleClass().setAll((Object[])new String[]{"e"});
        this.segmentMap.put(SixteenSegment.Segment.E, this.segmentE);
        this.segmentF = new Region();
        this.segmentF.getStyleClass().setAll((Object[])new String[]{"f"});
        this.segmentMap.put(SixteenSegment.Segment.F, this.segmentF);
        this.segmentG = new Region();
        this.segmentG.getStyleClass().setAll((Object[])new String[]{"g"});
        this.segmentMap.put(SixteenSegment.Segment.G, this.segmentG);
        this.segmentH = new Region();
        this.segmentH.getStyleClass().setAll((Object[])new String[]{"h"});
        this.segmentMap.put(SixteenSegment.Segment.H, this.segmentH);
        this.segmentI = new Region();
        this.segmentI.getStyleClass().setAll((Object[])new String[]{"i"});
        this.segmentMap.put(SixteenSegment.Segment.I, this.segmentI);
        this.segmentL = new Region();
        this.segmentL.getStyleClass().setAll((Object[])new String[]{"l"});
        this.segmentMap.put(SixteenSegment.Segment.L, this.segmentL);
        this.segmentM = new Region();
        this.segmentM.getStyleClass().setAll((Object[])new String[]{"m"});
        this.segmentMap.put(SixteenSegment.Segment.M, this.segmentM);
        this.segmentN = new Region();
        this.segmentN.getStyleClass().setAll((Object[])new String[]{"n"});
        this.segmentMap.put(SixteenSegment.Segment.N, this.segmentN);
        this.segmentP = new Region();
        this.segmentP.getStyleClass().setAll((Object[])new String[]{"p"});
        this.segmentMap.put(SixteenSegment.Segment.P, this.segmentP);
        this.segmentK = new Region();
        this.segmentK.getStyleClass().setAll((Object[])new String[]{"k"});
        this.segmentMap.put(SixteenSegment.Segment.K, this.segmentK);
        this.segmentDot = new Region();
        this.segmentDot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.segmentMap.put(SixteenSegment.Segment.DOT, this.segmentDot);
        this.pane.getChildren().setAll((Object[])new Node[]{this.segmentA1, this.segmentA2, this.segmentB, this.segmentC, this.segmentD2, this.segmentD1, this.segmentE, this.segmentF, this.segmentG, this.segmentH, this.segmentI, this.segmentL, this.segmentM, this.segmentN, this.segmentP, this.segmentK, this.segmentDot});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.update();
    }

    private void registerListeners() {
        ((SixteenSegment)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SixteenSegment)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SixteenSegment)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SixteenSegment)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SixteenSegment)this.getSkinnable()).characterProperty().addListener(observable -> this.handleControlPropertyChanged("CHARACTER"));
        ((SixteenSegment)this.getSkinnable()).dotOnProperty().addListener(observable -> this.handleControlPropertyChanged("DOT_ON"));
        ((SixteenSegment)this.getSkinnable()).segmentStyleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((SixteenSegment)this.getSkinnable()).getStyleClass().addListener(change -> {
            this.resize();
            this.update();
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("UPDATE".equals(PROPERTY)) {
            this.update();
        } else if ("RESIZE".equals(PROPERTY)) {
            this.resize();
            this.update();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((SixteenSegment)this.getSkinnable()).getPrefHeight() / ((SixteenSegment)this.getSkinnable()).getPrefWidth();
        } else if ("CHARACTER".equals(PROPERTY)) {
            this.update();
        } else if ("DOT_ON".equals(PROPERTY)) {
            this.update();
        }
    }

    private void update() {
        int ASCII = ((SixteenSegment)this.getSkinnable()).getCharacter().isEmpty() ? 20 : (int)((SixteenSegment)this.getSkinnable()).getCharacter().toUpperCase().charAt(0);
        String ON_STYLE = ((SixteenSegment)this.getSkinnable()).getSegmentStyle().ON_CLASS;
        String OFF_STYLE = ((SixteenSegment)this.getSkinnable()).getSegmentStyle().OFF_CLASS;
        for (SixteenSegment.Segment segment : this.segmentMap.keySet()) {
            if (((SixteenSegment)this.getSkinnable()).getSegmentMapping().containsKey(ASCII)) {
                if (((SixteenSegment)this.getSkinnable()).getSegmentMapping().get(ASCII).contains((Object)segment)) {
                    this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), ON_STYLE});
                    continue;
                }
                this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), OFF_STYLE});
                continue;
            }
            this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), OFF_STYLE});
        }
        if (((SixteenSegment)this.getSkinnable()).isDotOn()) {
            this.segmentMap.get((Object)SixteenSegment.Segment.DOT).getStyleClass().setAll((Object[])new String[]{"dot", ON_STYLE});
        } else {
            this.segmentMap.get((Object)SixteenSegment.Segment.DOT).getStyleClass().setAll((Object[])new String[]{"dot", OFF_STYLE});
        }
    }

    private void resize() {
        this.size = ((SixteenSegment)this.getSkinnable()).getWidth() < ((SixteenSegment)this.getSkinnable()).getHeight() ? ((SixteenSegment)this.getSkinnable()).getWidth() : ((SixteenSegment)this.getSkinnable()).getHeight();
        this.width = ((SixteenSegment)this.getSkinnable()).getWidth();
        this.height = ((SixteenSegment)this.getSkinnable()).getHeight();
        if (((SixteenSegment)this.getSkinnable()).isKeepAspect()) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.segmentA1.setPrefSize(0.373134328358209 * this.width, 0.07282913165266107 * this.height);
            this.segmentA1.setTranslateX(0.11567164179104478 * this.width);
            this.segmentA2.setPrefSize(0.376865671641791 * this.width, 0.07282913165266107 * this.height);
            this.segmentA2.setTranslateX(0.4962686567164179 * this.width);
            this.segmentB.setPrefSize(0.14185691947367654 * this.width, 0.4743288184414391 * this.height);
            this.segmentB.setTranslateX(0.7648594984367713 * this.width);
            this.segmentB.setTranslateY(0.02474666777111235 * this.height);
            this.segmentC.setPrefSize(0.14191687285010493 * this.width, 0.480032570889684 * this.height);
            this.segmentC.setTranslateX(0.7200879338961929 * this.width);
            this.segmentC.setTranslateY(0.5008913782798275 * this.height);
            this.segmentD2.setPrefSize(0.3656716417910448 * this.width, 0.07282913165266107 * this.height);
            this.segmentD2.setTranslateX(0.4216417910447761 * this.width);
            this.segmentD2.setTranslateY(0.927170868347339 * this.height);
            this.segmentD1.setPrefSize(0.3694029850746269 * this.width, 0.07282913165266107 * this.height);
            this.segmentD1.setTranslateX(0.03731343283582089 * this.width);
            this.segmentD1.setTranslateY(0.927170868347339 * this.height);
            this.segmentE.setPrefSize(0.1381160536808754 * this.width, 0.4744872192040879 * this.height);
            this.segmentE.setTranslateY(0.5008564583059787 * this.height);
            this.segmentF.setPrefSize(0.14191658817120453 * this.width, 0.4800337676574536 * this.height);
            this.segmentF.setTranslateX(0.04471146170772723 * this.width);
            this.segmentF.setTranslateY(0.019075994731999245 * this.height);
            this.segmentG.setPrefSize(0.26232508759000406 * this.width, 0.41364670868347336 * this.height);
            this.segmentG.setTranslateX(0.17906029544659516 * this.width);
            this.segmentG.setTranslateY(0.07340313139415923 * this.height);
            this.segmentH.setPrefSize(0.13067467532940766 * this.width, 0.4583017472125569 * this.height);
            this.segmentH.setTranslateX(0.41043147756092585 * this.width);
            this.segmentH.setTranslateY(0.038707604929178706 * this.height);
            this.segmentI.setPrefSize(0.33435482765311625 * this.width, 0.4141186198600534 * this.height);
            this.segmentI.setTranslateX(0.46448468450290054 * this.width);
            this.segmentI.setTranslateY(0.0736752731793401 * this.height);
            this.segmentK.setPrefSize(0.3523415238109987 * this.width, 0.07563025210084033 * this.height);
            this.segmentK.setTranslateX(0.45818246300540755 * this.width);
            this.segmentK.setTranslateY(0.46218487394957986 * this.height);
            this.segmentL.setPrefSize(0.25479484671977026 * this.width, 0.4144776074492297 * this.height);
            this.segmentL.setTranslateX(0.465354407011573 * this.width);
            this.segmentL.setTranslateY(0.5128619196702119 * this.height);
            this.segmentM.setPrefSize(0.13061295694379665 * this.width, 0.46119950665813203 * this.height);
            this.segmentM.setTranslateX(0.3656716417910448 * this.width);
            this.segmentM.setTranslateY(0.5000929204689688 * this.height);
            this.segmentN.setPrefSize(0.33414425067047576 * this.width, 0.4139740246684611 * this.height);
            this.segmentN.setTranslateX(0.10799379491094332 * this.width);
            this.segmentN.setTranslateY(0.5122721696100315 * this.height);
            this.segmentP.setPrefSize(0.34861020899530665 * this.width, 0.07563025210084033 * this.height);
            this.segmentP.setTranslateX(0.09992373879276105 * this.width);
            this.segmentP.setTranslateY(0.46218487394957986 * this.height);
            this.segmentDot.setPrefSize(0.13432835820895522 * this.width, 0.10084033613445378 * this.height);
            this.segmentDot.setTranslateX(0.8656716417910447 * this.width);
            this.segmentDot.setTranslateY(0.8991596638655462 * this.height);
        }
    }
}

