/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.vumeter.skin;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.vumeter.VuMeter;
import java.util.stream.IntStream;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class VuMeterSkin
extends SkinBase<VuMeter>
implements Skin<VuMeter> {
    private static final double PREFERRED_WIDTH = 24.0;
    private static final double PREFERRED_HEIGHT = 24.0;
    private static final double MINIMUM_WIDTH = 16.0;
    private static final double MINIMUM_HEIGHT = 16.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    public static final long PEAK_TIMEOUT = 1500000000L;
    private static boolean active;
    private double size;
    private ObservableList<Region> leds;
    private HBox hBox;
    private VBox vBox;
    private DoubleProperty stepSize;
    private int peakLedIndex;
    private long lastTimerCall;
    private AnimationTimer timer;

    public VuMeterSkin(VuMeter CONTROL) {
        super((Control)CONTROL);
        active = false;
        this.lastTimerCall = 0L;
        this.stepSize = new SimpleDoubleProperty((((VuMeter)this.getSkinnable()).getMaxValue() - ((VuMeter)this.getSkinnable()).getMinValue()) / (double)((VuMeter)this.getSkinnable()).getNoOfLeds());
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > VuMeterSkin.this.lastTimerCall + 1500000000L) {
                    ((Region)VuMeterSkin.this.leds.get(VuMeterSkin.this.peakLedIndex)).getStyleClass().remove((Object)"led-peak");
                    VuMeterSkin.this.peakLedIndex = Orientation.HORIZONTAL == ((VuMeter)VuMeterSkin.this.getSkinnable()).getOrientation() ? 0 : VuMeterSkin.this.leds.size() - 1;
                    VuMeterSkin.this.timer.stop();
                }
            }
        };
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((VuMeter)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((VuMeter)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((VuMeter)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((VuMeter)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (Orientation.HORIZONTAL == ((VuMeter)this.getSkinnable()).getOrientation()) {
                ((VuMeter)this.getSkinnable()).setPrefSize((double)((VuMeter)this.getSkinnable()).getNoOfLeds() * 24.0 + (double)(((VuMeter)this.getSkinnable()).getNoOfLeds() - 1) * ((VuMeter)this.getSkinnable()).getLedSpacing(), 24.0);
            } else {
                ((VuMeter)this.getSkinnable()).setPrefSize(24.0, (double)((VuMeter)this.getSkinnable()).getNoOfLeds() * 24.0 + (double)(((VuMeter)this.getSkinnable()).getNoOfLeds() - 1) * ((VuMeter)this.getSkinnable()).getLedSpacing());
            }
        }
        if (Double.compare(((VuMeter)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((VuMeter)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((VuMeter)this.getSkinnable()).setMinSize(16.0, 16.0);
        }
        if (Double.compare(((VuMeter)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((VuMeter)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((VuMeter)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.hBox = new HBox();
        this.hBox.getStyleClass().setAll((Object[])new String[]{"vu-meter"});
        this.hBox.setSpacing(((VuMeter)this.getSkinnable()).getLedSpacing());
        this.vBox = new VBox();
        this.vBox.getStyleClass().setAll((Object[])new String[]{"vu-meter"});
        this.vBox.setSpacing(((VuMeter)this.getSkinnable()).getLedSpacing());
        this.leds = FXCollections.observableArrayList();
        for (int i = 0; i < ((VuMeter)this.getSkinnable()).getNoOfLeds(); ++i) {
            Region led = new Region();
            led.setOnMouseClicked((EventHandler)new WeakEventHandler(event -> {
                active = !active;
            }));
            led.setOnMouseEntered((EventHandler)new WeakEventHandler(event -> this.handleMouseEvent((MouseEvent)event)));
            if (((VuMeter)this.getSkinnable()).getSections().isEmpty()) {
                led.getStyleClass().setAll((Object[])new String[]{"led"});
            } else {
                for (Section section : ((VuMeter)this.getSkinnable()).getSections()) {
                    if (!section.contains((double)i * this.stepSize.doubleValue())) continue;
                    led.getStyleClass().setAll((Object[])new String[]{"led", section.getStyleClass()});
                }
            }
            this.leds.add((Object)led);
        }
        if (Orientation.HORIZONTAL == ((VuMeter)this.getSkinnable()).getOrientation()) {
            this.vBox.setManaged(false);
            this.vBox.setVisible(false);
            this.hBox.getChildren().setAll(this.leds);
            this.peakLedIndex = 0;
        } else {
            this.hBox.setManaged(false);
            this.hBox.setVisible(false);
            FXCollections.reverse(this.leds);
            this.vBox.getChildren().setAll(this.leds);
            this.peakLedIndex = this.leds.size() - 1;
        }
        this.getChildren().setAll((Object[])new Node[]{this.hBox, this.vBox});
    }

    private void registerListeners() {
        ((VuMeter)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((VuMeter)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((VuMeter)this.getSkinnable()).valueProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE"));
        ((VuMeter)this.getSkinnable()).orientationProperty().addListener((ov, oldOrientation, newOrientation) -> {
            if (Orientation.HORIZONTAL == oldOrientation && Orientation.VERTICAL == newOrientation) {
                FXCollections.reverse(this.leds);
            } else if (Orientation.VERTICAL == oldOrientation && Orientation.HORIZONTAL == newOrientation) {
                FXCollections.reverse(this.leds);
            }
            this.handleControlPropertyChanged("ORIENTATION");
        });
        ((VuMeter)this.getSkinnable()).noOfLedsProperty().addListener(observable -> this.handleControlPropertyChanged("NO_OF_LEDS"));
        ((VuMeter)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("SECTIONS"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        block23: {
            block25: {
                block26: {
                    block24: {
                        block22: {
                            if (!"RESIZE".equals(PROPERTY)) break block22;
                            this.resize();
                            break block23;
                        }
                        if (!"STYLE".equals(PROPERTY)) break block24;
                        this.resize();
                        break block23;
                    }
                    if (!"VALUE".equals(PROPERTY)) break block25;
                    if (Orientation.HORIZONTAL != ((VuMeter)this.getSkinnable()).getOrientation()) break block26;
                    int currentLedPeakIndex = 0;
                    for (int i = 0; i < this.leds.size(); ++i) {
                        ((Region)this.leds.get(i)).getStyleClass().remove((Object)"led-on");
                        if (Double.compare((double)i * this.stepSize.doubleValue(), ((VuMeter)this.getSkinnable()).getValue()) > 0) continue;
                        ((Region)this.leds.get(i)).getStyleClass().add((Object)"led-on");
                        currentLedPeakIndex = i;
                    }
                    if (((VuMeter)this.getSkinnable()).isPeakValueVisible() && currentLedPeakIndex > this.peakLedIndex) {
                        this.timer.stop();
                        ((Region)this.leds.get(this.peakLedIndex)).getStyleClass().remove((Object)"led-peak");
                        ((Region)this.leds.get(currentLedPeakIndex)).getStyleClass().add((Object)"led-peak");
                        this.peakLedIndex = currentLedPeakIndex;
                        this.lastTimerCall = System.nanoTime();
                        this.timer.start();
                    }
                    break block23;
                }
                int currentLedPeakIndex = this.leds.size() - 1;
                for (int i = 0; i < this.leds.size(); ++i) {
                    if (i != this.peakLedIndex) {
                        ((Region)this.leds.get(i)).getStyleClass().remove((Object)"led-on");
                    }
                    if (Double.compare((double)(this.leds.size() - i - 1) * this.stepSize.doubleValue(), ((VuMeter)this.getSkinnable()).getValue()) <= 0) {
                        ((Region)this.leds.get(i)).getStyleClass().add((Object)"led-on");
                        continue;
                    }
                    currentLedPeakIndex = i;
                }
                if (!((VuMeter)this.getSkinnable()).isPeakValueVisible() || currentLedPeakIndex >= this.peakLedIndex) break block23;
                this.timer.stop();
                ((Region)this.leds.get(this.peakLedIndex)).getStyleClass().remove((Object)"led-peak");
                ((Region)this.leds.get(currentLedPeakIndex)).getStyleClass().add((Object)"led-peak");
                this.peakLedIndex = currentLedPeakIndex;
                this.lastTimerCall = System.nanoTime();
                this.timer.start();
                break block23;
            }
            if ("ORIENTATION".equals(PROPERTY)) {
                this.hBox.getChildren().clear();
                this.vBox.getChildren().clear();
                if (Orientation.HORIZONTAL == ((VuMeter)this.getSkinnable()).getOrientation()) {
                    this.vBox.setManaged(false);
                    this.vBox.setVisible(false);
                    this.hBox.getChildren().setAll(this.leds);
                } else {
                    this.hBox.setManaged(false);
                    this.hBox.setVisible(false);
                    this.vBox.getChildren().setAll(this.leds);
                }
            } else if ("NO_OF_LEDS".equals(PROPERTY)) {
                this.leds.clear();
                this.hBox.getChildren().clear();
                this.vBox.getChildren().clear();
                for (int i = 0; i < ((VuMeter)this.getSkinnable()).getNoOfLeds(); ++i) {
                    Region led = new Region();
                    led.setPrefSize(10.0, 20.0);
                    if (((VuMeter)this.getSkinnable()).getSections().isEmpty()) {
                        led.getStyleClass().setAll((Object[])new String[]{"led"});
                    } else {
                        for (Section section : ((VuMeter)this.getSkinnable()).getSections()) {
                            if (!section.contains((double)i * this.stepSize.doubleValue())) continue;
                            led.getStyleClass().setAll((Object[])new String[]{"led", section.getStyleClass()});
                        }
                    }
                    this.leds.add((Object)led);
                }
                if (Orientation.HORIZONTAL == ((VuMeter)this.getSkinnable()).getOrientation()) {
                    this.hBox.getChildren().setAll(this.leds);
                } else {
                    this.vBox.getChildren().setAll(this.leds);
                }
            } else if ("SECTIONS".equals(PROPERTY)) {
                for (int i = 0; i < ((VuMeter)this.getSkinnable()).getNoOfLeds(); ++i) {
                    Region led = new Region();
                    led.setPrefSize(10.0, 20.0);
                    if (((VuMeter)this.getSkinnable()).getSections().isEmpty()) {
                        led.getStyleClass().setAll((Object[])new String[]{"led"});
                    } else {
                        for (Section section : ((VuMeter)this.getSkinnable()).getSections()) {
                            if (!section.contains((double)i * this.stepSize.doubleValue())) continue;
                            led.getStyleClass().setAll((Object[])new String[]{"led", section.getStyleClass()});
                        }
                    }
                    this.leds.add((Object)led);
                }
            }
        }
    }

    private void handleMouseEvent(MouseEvent EVENT) {
        if (active && MouseEvent.MOUSE_ENTERED == EVENT.getEventType()) {
            Region SRC = (Region)EVENT.getSource();
            if (Orientation.HORIZONTAL == ((VuMeter)this.getSkinnable()).getOrientation()) {
                IntStream.range(0, this.leds.size()).forEach(i -> {
                    ((Region)this.leds.get(i)).getStyleClass().remove((Object)"led-on");
                    if (i <= this.leds.indexOf((Object)SRC)) {
                        ((Region)this.leds.get(i)).getStyleClass().add((Object)"led-on");
                    }
                });
            } else {
                IntStream.range(0, this.leds.size()).forEach(i -> {
                    ((Region)this.leds.get(i)).getStyleClass().remove((Object)"led-on");
                    if (i >= this.leds.indexOf((Object)SRC)) {
                        ((Region)this.leds.get(i)).getStyleClass().add((Object)"led-on");
                    }
                });
            }
        }
    }

    private void resize() {
        double d = this.size = ((VuMeter)this.getSkinnable()).getWidth() < ((VuMeter)this.getSkinnable()).getHeight() ? ((VuMeter)this.getSkinnable()).getWidth() : ((VuMeter)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            for (Region led : this.leds) {
                led.setPrefSize(this.size, this.size);
            }
        }
    }
}

