/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJrt;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJep247
extends ClasspathJrt {
    protected FileSystem fs = null;
    protected String compliance = null;
    protected long jdklevel;
    protected String releaseInHex = null;
    protected String[] subReleases = null;
    protected Path releasePath = null;
    protected Set<String> packageCache;
    protected File jdkHome;
    protected String modulePath = null;

    public ClasspathJep247(File file, String string, AccessRuleSet accessRuleSet) {
        super(file, false, accessRuleSet, null);
        this.compliance = string;
        this.jdklevel = CompilerOptions.releaseToJDKLevel(this.compliance);
        this.jdkHome = file;
        this.file = new File(new File(file, "lib"), "jrt-fs.jar");
    }

    @Override
    public List<FileSystem.Classpath> fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3) {
        return this.findClass(cArray, string, string2, string3, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        if (!this.isPackage(string, string2)) {
            return null;
        }
        try {
            Object[] objectArray;
            ClassFileReader classFileReader = null;
            byte[] byArray = null;
            string3 = string3.replace(".class", ".sig");
            if (this.subReleases != null && this.subReleases.length > 0) {
                String string4;
                Path path;
                objectArray = this.subReleases;
                int n = objectArray.length;
                for (int i = 0; !(i >= n || Files.exists(path = this.fs.getPath(string4 = objectArray[i], string3), new LinkOption[0]) && (byArray = JRTUtil.safeReadBytes(path)) != null); ++i) {
                }
            } else {
                byArray = JRTUtil.safeReadBytes(this.fs.getPath(this.releaseInHex, string3));
            }
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string3.toCharArray());
                objectArray = string2 != null ? string2.toCharArray() : null;
                return new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string3), (char[])objectArray);
            }
        }
        catch (IOException | ClassFormatException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.compliance == null) {
            return;
        }
        this.releaseInHex = Integer.toHexString(Integer.parseInt(this.compliance)).toUpperCase();
        Path path = this.jdkHome.toPath().resolve("lib").resolve("ct.sym");
        URI uRI = path.toUri();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        URI uRI2 = URI.create("jar:file:" + uRI.getRawPath());
        try {
            this.fs = FileSystems.getFileSystem(uRI2);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        if (this.fs == null) {
            HashMap hashMap = new HashMap();
            this.fs = FileSystems.newFileSystem(uRI2, hashMap);
        }
        this.releasePath = this.fs.getPath("/", new String[0]);
        if (!Files.exists(this.fs.getPath(this.releaseInHex, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("release " + this.compliance + " is not found in the system");
        }
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadModules() {
        if (this.jdklevel <= 0x340000L) {
            super.loadModules();
            return;
        }
        Path path = this.fs.getPath(this.releaseInHex + "-modules", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("release " + this.compliance + " is not found in the system");
        }
        this.modulePath = this.file.getPath() + "|" + path.toString();
        Map map = (Map)ModulesCache.get(this.modulePath);
        if (map == null) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                final HashMap hashMap = new HashMap();
                for (Path path2 : directoryStream) {
                    Files.walkFileTree(path2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            byte[] byArray = null;
                            if (Files.exists(path, new LinkOption[0])) {
                                byArray = JRTUtil.safeReadBytes(path);
                                if (byArray == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                ClasspathJep247.this.acceptModule(byArray, (Map<String, IModule>)hashMap);
                                ClasspathJep247.this.moduleNamesCache.add(JRTUtil.sanitizedFileName(path));
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                HashMap hashMap2 = ModulesCache;
                synchronized (hashMap2) {
                    if (ModulesCache.get(this.modulePath) == null) {
                        ModulesCache.put(this.modulePath, Collections.unmodifiableMap(hashMap));
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.moduleNamesCache.addAll(map.keySet());
        }
    }

    @Override
    void acceptModule(ClassFileReader classFileReader, Map<String, IModule> map) {
        IBinaryModule iBinaryModule;
        if (this.jdklevel <= 0x340000L) {
            super.acceptModule(classFileReader, map);
            return;
        }
        if (classFileReader != null && (iBinaryModule = classFileReader.getModuleDeclaration()) != null) {
            map.put(String.valueOf(iBinaryModule.name()), iBinaryModule);
        }
    }

    protected void addToPackageCache(String string, boolean bl) {
        if (this.packageCache.contains(string)) {
            return;
        }
        this.packageCache.add(string);
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String string, String string2) {
        List<String> list;
        if (this.packageCache == null) {
            this.packageCache = new HashSet<String>(41);
            this.packageCache.add(Util.EMPTY_STRING);
            list = new ArrayList<String>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.releasePath);){
                for (Path path : directoryStream) {
                    String string3 = JRTUtil.sanitizedFileName(path);
                    if (!string3.contains(this.releaseInHex)) continue;
                    list.add(string3);
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            if (path.getNameCount() <= 1) {
                                return FileVisitResult.CONTINUE;
                            }
                            Path path2 = path.subpath(1, path.getNameCount());
                            ClasspathJep247.this.addToPackageCache(path2.toString(), false);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.subReleases = list.toArray(new String[list.size()]);
        }
        if (string2 == null) {
            list = JRTUtil.getModulesDeclaringPackage(this.file, string, string2);
            return CharOperation.toCharArrays(list);
        }
        return this.singletonModuleNameIf(this.packageCache.contains(string));
    }

    @Override
    public void reset() {
        try {
            super.reset();
            this.fs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return "Classpath for JEP 247 for JDK " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String string = this.getPath();
            char[] cArray = string.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }
}

