/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJrt;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJsr199;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.tool.ExceptionDiagnostic;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class EclipseCompilerImpl
extends Main {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    Iterable<? extends JavaFileObject> compilationUnits;
    public JavaFileManager fileManager;
    protected Processor[] processors;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    public EclipseCompilerImpl(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        super(printWriter, printWriter2, bl, null, null);
    }

    public boolean call() {
        try {
            this.handleLocations();
            if (this.proceed) {
                this.globalProblemsCount = 0;
                this.globalErrorsCount = 0;
                this.globalWarningsCount = 0;
                this.globalTasksCount = 0;
                this.exportedClassFilesCounter = 0;
                this.performCompilation();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.diagnosticListener.report(new ExceptionDiagnostic(illegalArgumentException));
            this.logger.logException(illegalArgumentException);
            if (this.systemExitWhenFinished) {
                this.cleanup();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.diagnosticListener.report(new ExceptionDiagnostic(runtimeException));
            this.logger.logException(runtimeException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup();
        }
        if (this.failOnWarning && this.globalWarningsCount > 0) {
            return false;
        }
        return this.globalErrorsCount == 0;
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        HashtableOfObject hashtableOfObject = new HashtableOfObject();
        ArrayList<1> arrayList = new ArrayList<1>();
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (final JavaFileObject javaFileObject : this.compilationUnits) {
                String string = javaFileObject.getName();
                char[] cArray = string.toCharArray();
                boolean bl = CharOperation.endsWith(cArray, TypeConstants.MODULE_INFO_FILE_NAME);
                if (bl == (i == 0)) {
                    if (hashtableOfObject.get(cArray) != null) {
                        throw new IllegalArgumentException(this.bind("unit.more", string));
                    }
                    hashtableOfObject.put(cArray, cArray);
                    CompilationUnit compilationUnit = new CompilationUnit(null, string, null, this.destinationPaths[n], EclipseCompilerImpl.shouldIgnoreOptionalProblems(this.ignoreOptionalProblemsFromFolders, string.toCharArray()), this.modNames[n]){

                        @Override
                        public char[] getContents() {
                            try {
                                return javaFileObject.getCharContent(true).toString().toCharArray();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                throw new AbortCompilationUnit(null, iOException, null);
                            }
                        }
                    };
                    arrayList.add(compilationUnit);
                    this.javaFileObjectMap.put(compilationUnit, javaFileObject);
                }
                ++n;
            }
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[arrayList.size()];
        arrayList.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    @Override
    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    @Override
    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, String[] stringArray2, final int n2, final int n3, final int n4, final int n5, final int n6) {
                CategorizedProblem categorizedProblem;
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                Diagnostic<JavaFileObject> diagnostic = null;
                if (diagnosticListener != null) {
                    diagnostic = new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n6;
                        }

                        @Override
                        public long getEndPosition() {
                            return n4;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n2 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n2 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n2 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n5;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n3;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n3;
                        }
                    };
                }
                if ((categorizedProblem = super.createProblem(cArray, n, stringArray, stringArray2, n2, n3, n4, n5, n6)) instanceof DefaultProblem && diagnostic != null) {
                    return new Jsr199ProblemWrapper((DefaultProblem)categorizedProblem, diagnostic, diagnosticListener);
                }
                return categorizedProblem;
            }

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, int n2, String[] stringArray2, final int n3, final int n4, final int n5, final int n6, final int n7) {
                CategorizedProblem categorizedProblem;
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                Diagnostic<JavaFileObject> diagnostic = null;
                if (diagnosticListener != null) {
                    diagnostic = new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n7;
                        }

                        @Override
                        public long getEndPosition() {
                            return n5;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n3 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n3 & 0x400) != 0) {
                                return Diagnostic.Kind.NOTE;
                            }
                            if ((n3 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n3 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n6;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n4;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n4;
                        }
                    };
                }
                if ((categorizedProblem = super.createProblem(cArray, n, stringArray, n2, stringArray2, n3, n4, n5, n6, n7)) instanceof DefaultProblem && diagnostic != null) {
                    return new Jsr199ProblemWrapper((DefaultProblem)categorizedProblem, diagnostic, diagnosticListener);
                }
                return categorizedProblem;
            }
        };
    }

    @Override
    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map<String, String> map, CompilationProgress compilationProgress) {
        super.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.javaFileObjectMap = new HashMap();
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors(this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    @Override
    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            boolean bl = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
            File file = null;
            String string = compilationResult.getCompilationUnit().getDestinationPath();
            if (string == null) {
                string = this.destinationPath;
            }
            if (string != null) {
                file = new File(string);
                file.mkdirs();
            }
            int n = classFileArray.length;
            for (int i = 0; i < n; ++i) {
                ClassFile classFile = classFileArray[i];
                char[] cArray = classFile.fileName();
                int n2 = cArray.length;
                char[] cArray2 = new char[n2 + 6];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n2, 6);
                CharOperation.replace(cArray2, '/', File.separatorChar);
                String string2 = new String(cArray2);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                }
                try {
                    Object object;
                    Object object2;
                    char[] cArray3 = compilationResult.compilationUnit.getModuleName();
                    JavaFileManager.Location location = null;
                    location = cArray3 == null ? StandardLocation.CLASS_OUTPUT : this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, new String(cArray3));
                    JavaFileObject javaFileObject = this.fileManager.getJavaFileForOutput(location, new String(cArray), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(compilationResult.compilationUnit));
                    if (bl) {
                        if (string != null) {
                            int n3 = CharOperation.lastIndexOf(File.separatorChar, cArray2);
                            if (n3 != -1) {
                                object2 = new File(string, string2.substring(0, n3));
                                ((File)object2).mkdirs();
                            }
                        } else {
                            object = javaFileObject.toUri().getPath();
                            int n4 = ((String)object).lastIndexOf(47);
                            if (n4 != -1) {
                                File file2 = new File(((String)object).substring(0, n4));
                                file2.mkdirs();
                            }
                        }
                    }
                    object = javaFileObject.openOutputStream();
                    try {
                        object2 = new BufferedOutputStream((OutputStream)object);
                        try {
                            ((BufferedOutputStream)object2).write(classFile.header, 0, classFile.headerOffset);
                            ((BufferedOutputStream)object2).write(classFile.contents, 0, classFile.contentsOffset);
                            ((BufferedOutputStream)object2).flush();
                        }
                        finally {
                            ((FilterOutputStream)object2).close();
                        }
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.logger.logNoClassFileCreated(string, string2, iOException);
                }
                this.logger.logClassFile(bl, string, string2);
                ++this.exportedClassFilesCounter;
            }
            this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
        }
    }

    @Override
    protected void setPaths(ArrayList<String> arrayList, String string, ArrayList<String> arrayList2, ArrayList<String> arrayList3, String string2, String string3, ArrayList<String> arrayList4, ArrayList<String> arrayList5, String string4) {
        this.validateClasspathOptions(arrayList, arrayList5, arrayList4);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleLocations() {
        block53: {
            block52: {
                block50: {
                    block51: {
                        block49: {
                            var1_1 = new ArrayList<FileSystem.Classpath>();
                            var2_2 = null;
                            var3_3 = null;
                            var4_4 = null;
                            var5_5 = false;
                            var6_6 = false;
                            if (this.fileManager instanceof EclipseFileManager) {
                                var2_2 = (EclipseFileManager)this.fileManager;
                            }
                            if (this.fileManager instanceof StandardJavaFileManager) {
                                var3_3 = (StandardJavaFileManager)this.fileManager;
                            }
                            var4_4 = this.fileManager;
                            if (var2_2 != null && (var2_2.flags & 4) == 0 && (var2_2.flags & 2) != 0) {
                                var1_1.addAll(this.handleEndorseddirs(null));
                            }
                            var7_7 = null;
                            if (var3_3 == null) break block49;
                            var7_7 = var3_3.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                            if (var7_7 == null) break block50;
                            var8_8 = var7_7.iterator();
                            break block51;
                        }
                        if (var4_4 == null) break block50;
                        var8_8 = Util.getJavaHome();
                        var9_17 = Util.getJDKLevel((File)var8_8);
                        if (var9_17 >= 0x350000L) {
                            var11_31 = null;
                            if (this.releaseVersion != null && this.complianceLevel < var9_17) {
                                var12_47 = CompilerOptions.versionFromJdkLevel(this.complianceLevel);
                                if (var12_47.length() >= 3) {
                                    var12_47 = var12_47.substring(2);
                                }
                                var11_32 = FileSystem.getOlderSystemRelease(var8_8.getAbsolutePath(), (String)var12_47, null);
                            } else {
                                var11_33 = FileSystem.getJrtClasspath(var8_8.toString(), null, null, null);
                            }
                            var12_47 = new ClasspathJsr199((FileSystem.Classpath)var11_34, this.fileManager, (JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH);
                            var1_1.add((FileSystem.Classpath)var12_47);
                        } else {
                            var11_35 = new ClasspathJsr199(this.fileManager, StandardLocation.PLATFORM_CLASS_PATH);
                            var1_1.add(var11_35);
                        }
                        var5_5 = true;
                        break block50;
                    }
                    while (var8_8.hasNext()) {
                        var9_16 = (File)var8_8.next();
                        if (var9_16.isDirectory()) {
                            var10_28 = this.getPlatformLocations(var1_1, var9_16);
                            if (var3_3 instanceof EclipseFileManager && var10_28.size() == 1 && (var11_30 = (FileSystem.Classpath)var10_28.get(0)) instanceof ClasspathJrt) {
                                try {
                                    ((EclipseFileManager)var3_3).locationHandler.newSystemLocation((JavaFileManager.Location)StandardLocation.SYSTEM_MODULES, (ClasspathJrt)var11_30);
                                }
                                catch (IOException var12_46) {
                                    var12_46.printStackTrace();
                                }
                            }
                            var1_1.addAll((Collection<FileSystem.Classpath>)var10_28);
                            break;
                        }
                        var10_28 = FileSystem.getClasspath(var9_16.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                        if (var10_28 == null) continue;
                        var1_1.add((FileSystem.Classpath)var10_28);
                        var5_5 = true;
                    }
                }
                if (var2_2 != null && (var2_2.flags & 1) == 0 && (var2_2.flags & 2) != 0) {
                    var1_1.addAll(this.handleExtdirs(null));
                }
                if (var3_3 == null) break block52;
                var7_7 = var3_3.getLocation(StandardLocation.SOURCE_PATH);
                if (var7_7 != null) {
                    for (File var9_19 : var7_7) {
                        var10_28 = FileSystem.getClasspath(var9_19.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                        if (var10_28 == null) continue;
                        var1_1.add((FileSystem.Classpath)var10_28);
                    }
                }
                if ((var7_7 = var3_3.getLocation(StandardLocation.CLASS_PATH)) != null) {
                    for (File var9_21 : var7_7) {
                        var10_28 = FileSystem.getClasspath(var9_21.getAbsolutePath(), null, null, this.options, this.releaseVersion);
                        if (var10_28 == null) continue;
                        var1_1.add((FileSystem.Classpath)var10_28);
                        var6_6 = true;
                    }
                }
                if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                    try {
                        var8_8 = var3_3.getLocationAsPaths(StandardLocation.MODULE_SOURCE_PATH);
                        if (var8_8 != null) {
                            var9_22 = new StringBuilder();
                            var10_28 = var8_8.iterator();
                            while (var10_28.hasNext()) {
                                var11_39 = (Path)var10_28.next();
                                var9_22.append(var11_39.toFile().getCanonicalPath());
                                var9_22.append(File.pathSeparator);
                            }
                            var10_28 = this.handleModuleSourcepath(var9_22.toString());
                            var11_40 = var10_28.iterator();
                            while (var11_40.hasNext()) {
                                var12_47 = var11_40.next();
                                var13_48 = var12_47.getModuleNames(null);
                                for (String var15_50 : var13_48) {
                                    var16_51 = Paths.get(var12_47.getPath(), new String[0]);
                                    var3_3.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, var15_50, Collections.singletonList(var16_51));
                                    var16_51 = Paths.get(var12_47.getDestinationPath(), new String[0]);
                                }
                            }
                            var1_1.addAll((Collection<FileSystem.Classpath>)var10_28);
                        }
                    }
                    catch (IllegalStateException var8_9) {
                    }
                    catch (IllegalArgumentException var8_10) {
                        throw var8_10;
                    }
                    catch (Exception var8_11) {
                        this.logger.logException(var8_11);
                    }
                    try {
                        var7_7 = var3_3.getLocation(StandardLocation.MODULE_PATH);
                        if (var7_7 == null) ** GOTO lbl176
                        for (File var9_25 : var7_7) {
                            try {
                                var10_28 = this.handleModulepath(var9_25.getCanonicalPath());
                                var11_43 = var10_28.iterator();
                                while (var11_43.hasNext()) {
                                    var12_47 = var11_43.next();
                                    var13_48 = var12_47.getModuleNames(null);
                                    for (String var15_50 : var13_48) {
                                        var16_51 = Paths.get(var12_47.getPath(), new String[0]);
                                        var3_3.setLocationForModule(StandardLocation.MODULE_PATH, var15_50, Collections.singletonList(var16_51));
                                    }
                                }
                                var1_1.addAll((Collection<FileSystem.Classpath>)var10_28);
                            }
                            catch (IOException var10_29) {
                                throw new AbortCompilationUnit(null, var10_29, null);
                            }
                        }
                    }
                    catch (IllegalStateException var8_12) {
                    }
                    catch (IllegalArgumentException var8_13) {
                        throw var8_13;
                    }
                    catch (Exception var8_14) {
                        this.logger.logException(var8_14);
                    }
                }
                break block53;
            }
            if (var4_4 != null) {
                var8_8 = null;
                if (this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                    var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.SOURCE_PATH);
                    var1_1.add((FileSystem.Classpath)var8_8);
                }
                if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                    if (this.fileManager.hasLocation(StandardLocation.UPGRADE_MODULE_PATH)) {
                        var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.UPGRADE_MODULE_PATH);
                    }
                    if (this.fileManager.hasLocation(StandardLocation.SYSTEM_MODULES)) {
                        var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.SYSTEM_MODULES);
                        var1_1.add((FileSystem.Classpath)var8_8);
                    }
                    if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                        var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.PATCH_MODULE_PATH);
                        var1_1.add((FileSystem.Classpath)var8_8);
                    }
                    if (this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                        var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.MODULE_SOURCE_PATH);
                        var1_1.add((FileSystem.Classpath)var8_8);
                    }
                    if (this.fileManager.hasLocation(StandardLocation.MODULE_PATH)) {
                        var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.MODULE_PATH);
                        var1_1.add((FileSystem.Classpath)var8_8);
                    }
                }
                var8_8 = new ClasspathJsr199(this.fileManager, StandardLocation.CLASS_PATH);
                var1_1.add((FileSystem.Classpath)var8_8);
                var6_6 = true;
            }
        }
        if (this.checkedClasspaths == null) {
            if (!var5_5) {
                var1_1.addAll(this.handleBootclasspath(null, null));
            }
            if (!var6_6) {
                var1_1.addAll(this.handleClasspath(null, null));
            }
        }
        if ((var8_15 = (var1_1 = FileSystem.ClasspathNormalizer.normalize(var1_1)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[var8_15];
            var9_26 = false;
            for (FileSystem.Classpath var11_45 : var1_1) {
                this.checkedClasspaths[++var9_27] = var11_45;
            }
        }
    }

    protected List<FileSystem.Classpath> getPlatformLocations(ArrayList<FileSystem.Classpath> arrayList, File file) {
        List<FileSystem.Classpath> list = Util.collectPlatformLibraries(file);
        return list;
    }

    @Override
    protected void loggingExtraProblems() {
        super.loggingExtraProblems();
        for (final CategorizedProblem categorizedProblem : this.extraProblems) {
            if (this.diagnosticListener == null || this.isIgnored(categorizedProblem)) continue;
            Diagnostic<JavaFileObject> diagnostic = new Diagnostic<JavaFileObject>(){

                @Override
                public String getCode() {
                    return null;
                }

                @Override
                public long getColumnNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).column;
                    }
                    return -1L;
                }

                @Override
                public long getEndPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceEnd();
                    }
                    return -1L;
                }

                @Override
                public Diagnostic.Kind getKind() {
                    if (categorizedProblem.isError()) {
                        return Diagnostic.Kind.ERROR;
                    }
                    if (categorizedProblem.isWarning()) {
                        return Diagnostic.Kind.WARNING;
                    }
                    if (categorizedProblem instanceof DefaultProblem && ((DefaultProblem)categorizedProblem).isInfo()) {
                        return Diagnostic.Kind.NOTE;
                    }
                    return Diagnostic.Kind.OTHER;
                }

                @Override
                public long getLineNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceLineNumber();
                    }
                    return -1L;
                }

                @Override
                public String getMessage(Locale locale) {
                    return categorizedProblem.getMessage();
                }

                @Override
                public long getPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceStart();
                    }
                    return -1L;
                }

                @Override
                public JavaFileObject getSource() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        char[] cArray = ((DefaultProblem)categorizedProblem).getOriginatingFileName();
                        if (cArray == null) {
                            return null;
                        }
                        File file = new File(new String(cArray));
                        if (file.exists()) {
                            Charset charset = EclipseCompilerImpl.this.fileManager instanceof EclipseFileManager ? ((EclipseFileManager)EclipseCompilerImpl.this.fileManager).charset : Charset.defaultCharset();
                            return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, charset);
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public long getStartPosition() {
                    return this.getPosition();
                }
            };
            this.diagnosticListener.report((Diagnostic<? super JavaFileObject>)diagnostic);
        }
    }

    class Jsr199ProblemWrapper
    extends DefaultProblem {
        DefaultProblem original;
        DiagnosticListener<? super JavaFileObject> listener;
        Diagnostic<JavaFileObject> diagnostic;

        public Jsr199ProblemWrapper(DefaultProblem defaultProblem, Diagnostic<JavaFileObject> diagnostic, DiagnosticListener<? super JavaFileObject> diagnosticListener) {
            super(defaultProblem.getOriginatingFileName(), defaultProblem.getMessage(), defaultProblem.getID(), defaultProblem.getArguments(), defaultProblem.severity, defaultProblem.getSourceStart(), defaultProblem.getSourceEnd(), defaultProblem.getSourceLineNumber(), defaultProblem.column);
            this.original = defaultProblem;
            this.listener = diagnosticListener;
            this.diagnostic = diagnostic;
        }

        @Override
        public void reportError() {
            this.listener.report(this.diagnostic);
        }

        @Override
        public String[] getArguments() {
            return this.original.getArguments();
        }

        @Override
        public int getID() {
            return this.original.getID();
        }

        @Override
        public String getMessage() {
            return this.original.getMessage();
        }

        @Override
        public char[] getOriginatingFileName() {
            return this.original.getOriginatingFileName();
        }

        @Override
        public int getSourceEnd() {
            return this.original.getSourceEnd();
        }

        @Override
        public int getSourceLineNumber() {
            return this.original.getSourceLineNumber();
        }

        @Override
        public int getSourceStart() {
            return this.original.getSourceStart();
        }

        @Override
        public boolean isError() {
            return this.original.isError();
        }

        @Override
        public boolean isWarning() {
            return this.original.isWarning();
        }

        @Override
        public boolean isInfo() {
            return this.original.isInfo();
        }

        @Override
        public void setSourceEnd(int n) {
            this.original.setSourceEnd(n);
        }

        @Override
        public void setSourceLineNumber(int n) {
            this.original.setSourceLineNumber(n);
        }

        @Override
        public void setSourceStart(int n) {
            this.original.setSourceStart(n);
        }

        @Override
        public int getCategoryID() {
            return this.original.getCategoryID();
        }

        @Override
        public String getMarkerType() {
            return this.original.getMarkerType();
        }
    }
}

