/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.visitor;

import japa.parser.ast.BlockComment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.LineComment;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DumpVisitor
implements VoidVisitor<Object> {
    private static int classDepth = 0;
    private static int anonymousCount = 0;
    private String parentClass = "";
    private static int inAnonymousClass = 0;
    private String anonymousMethod = "";
    private final SourcePrinter printer = new SourcePrinter();

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("inheritable ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers) && !ModifierSet.isFinal(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("constant ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("protect ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private void printMethodVisibility(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("/* **nonrx**  strictfp ** */");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("protect ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("/* **nonrx**  volatile ** */");
        }
    }

    private void printMethodModifiers(int modifiers) {
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("shared ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
    }

    private void printClassVisibility(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
    }

    private void printClassModifiers(int modifiers, ClassOrInterfaceDeclaration n) {
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (n.isInterface()) {
            this.printer.print("interface ");
        }
    }

    private void printMembers(List<BodyDeclaration> members, Object arg) {
        for (BodyDeclaration member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                this.printer.print("/* **nonrx**  ");
                a.accept(this, arg);
                this.printer.print(" ** */");
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                this.printer.print("/* **nonrx**  ");
                a.accept(this, arg);
                this.printer.print(" ** */");
                this.printer.printLn();
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (args != null) {
            this.printer.print(" /* **nonrx**  <");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print("> ** */");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (args != null) {
            this.printer.print("/* **nonrx**  <");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print("> ** */");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (args != null) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        if (n.getPackage() != null) {
            n.getPackage().accept(this, arg);
        }
        if (n.getImports() != null) {
            for (ImportDeclaration i : n.getImports()) {
                i.accept(this, arg);
            }
            this.printer.printLn();
        }
        if (n.getTypes() != null) {
            Iterator<TypeDeclaration> i = n.getTypes().iterator();
            while (i.hasNext()) {
                i.next().accept(this, arg);
                this.printer.printLn();
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn();
        this.printer.printLn();
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printer.print(n.getName());
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.printer.print("import ");
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".");
        }
        this.printer.printLn("");
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print("class ");
        this.printer.print(this.parentClass + n.getName());
        this.printer.print(" ");
        if (++classDepth > 1) {
            this.printer.print("dependent ");
        }
        this.parentClass = this.parentClass + n.getName() + ".";
        this.printClassVisibility(n.getModifiers());
        this.printClassModifiers(n.getModifiers(), n);
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" ");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        --classDepth;
        this.parentClass = this.parentClass.substring(0, this.parentClass.lastIndexOf(n.getName() + "."));
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        this.printTypeArgs(n.getTypeArgs(), arg);
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printer.print(n.getName());
        if (n.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        n.getType().accept(this, arg);
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print("properties ");
        this.printModifiers(n.getModifiers());
        this.printer.printLn();
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            this.printer.print(var.getId().toString());
            this.printer.print(" = ");
            this.printer.print(n.getType().toString());
            this.printer.print(" ");
            if (var.getInit() != null) {
                this.printer.print(var.getInit().toString());
            }
            if (!i.hasNext()) continue;
            this.printer.printLn();
        }
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printer.print(n.getName());
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        if (n.getValues() != null) {
            this.printer.print("[");
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
            this.printer.print("]");
        }
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        n.getType().accept(this, arg);
        if (n.getDimensions() != null) {
            for (Expression dim : n.getDimensions()) {
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
            }
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
        } else {
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("/* **nonrx** &= ** */");
                break;
            }
            case or: {
                this.printer.print("/* **nonrx** |= ** */");
                break;
            }
            case xor: {
                this.printer.print("/* **nonrx** ^= ** */");
                break;
            }
            case plus: {
                this.printer.print("= ");
                this.printer.print(n.getTarget().toString());
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("= ");
                this.printer.print(n.getTarget().toString());
                this.printer.print("-");
                break;
            }
            case rem: {
                this.printer.print("=");
                this.printer.print(n.getTarget().toString());
                this.printer.print("//");
                break;
            }
            case slash: {
                this.printer.print("= ");
                this.printer.print(n.getTarget().toString());
                this.printer.print("/");
                break;
            }
            case star: {
                this.printer.print("= ");
                this.printer.print(n.getTarget().toString());
                this.printer.print("*");
                break;
            }
            case lShift: {
                this.printer.print("/* **nonrx** <<= ** */");
                break;
            }
            case rSignedShift: {
                this.printer.print("/* **nonrx** >>= ** */");
                break;
            }
            case rUnsignedShift: {
                this.printer.print("/* **nonrx** >>>= ** */");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("|");
                break;
            }
            case and: {
                this.printer.print("&");
                break;
            }
            case binOr: {
                this.printer.print(" /* **nonrx**  | ** */ ");
                break;
            }
            case binAnd: {
                this.printer.print(" /* **nonrx**  & ** */ ");
                break;
            }
            case xor: {
                this.printer.print("&&");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("\\==");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print(" /* **nonrx**  << ** */");
                break;
            }
            case rSignedShift: {
                this.printer.print(" /* **nonrx**  >> ** */");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(" /* **nonrx**  >>> ** */");
                break;
            }
            case plus: {
                if (n.getLeft().getClass().toString().matches("class japa.parser.ast.expr.StringLiteralExpr") || n.getRight().getClass().toString().matches("class japa.parser.ast.expr.StringLiteralExpr")) {
                    this.printer.print("||");
                    break;
                }
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("//");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        n.getType().accept(this, arg);
        this.printer.print(" ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        this.printer.print(" if ");
        n.getCondition().accept(this, arg);
        this.printer.print(" then do ");
        n.getThenExpr().accept(this, arg);
        this.printer.printLn(" end ");
        this.printer.printLn(" else do ");
        n.getElseExpr().accept(this, arg);
        this.printer.printLn(" end ");
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printer.print("(");
        n.getInner().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        n.getExpr().accept(this, arg);
        this.printer.print(" <= ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        String literal_to_chop = n.getValue().toString();
        if (literal_to_chop.substring(literal_to_chop.length() - 1).equals("d")) {
            this.printer.print(literal_to_chop.substring(0, literal_to_chop.length() - 1));
        } else if (literal_to_chop.substring(literal_to_chop.length() - 1).equals("f")) {
            this.printer.print(literal_to_chop.substring(0, literal_to_chop.length() - 1));
        } else {
            this.printer.print(n.getValue());
        }
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        String literal_to_chop = n.getValue().toString();
        if (literal_to_chop.substring(literal_to_chop.length() - 1).equals("L")) {
            this.printer.print(literal_to_chop.substring(0, literal_to_chop.length() - 1));
        } else {
            this.printer.print(n.getValue());
        }
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        if (n.getValue()) {
            this.printer.print("1");
        } else {
            this.printer.print("0");
        }
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        if (n.getAnonymousClassBody() != null) {
            this.printer.print(" /* ** anonymous class ** */ ");
            String className = "__anon_" + anonymousCount + "_";
            this.printer.print(this.parentClass + className);
            this.printTypeArgs(n.getTypeArgs(), arg);
            n.getType().accept(this, arg);
            this.printArguments(n.getArgs(), arg);
            ++classDepth;
            ++inAnonymousClass;
            this.printer.print("class ");
            this.printer.print(this.parentClass + className);
            n.getType().accept(this, arg);
            this.printer.print(" private ");
            this.printer.print(" extends /** or implements ? **/ ");
            n.getType().accept(this, arg);
            this.parentClass = this.parentClass + className + ".";
            this.printer.indent();
            this.printMembers(n.getAnonymousClassBody(), arg);
            this.printer.printLn();
            this.printer.unindent();
            ++anonymousCount;
            --inAnonymousClass;
            --classDepth;
            this.parentClass = this.parentClass.substring(0, this.parentClass.lastIndexOf(className + "."));
        } else {
            this.printTypeArgs(n.getTypeArgs(), arg);
            n.getType().accept(this, arg);
            this.printArguments(n.getArgs(), arg);
        }
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                this.printer.print(n.getExpr().toString());
                break;
            }
            case negative: {
                this.printer.print("-");
                this.printer.print(n.getExpr().toString());
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("\\");
                this.printer.print(n.getExpr().toString());
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print(n.getExpr().toString());
                this.printer.print(" = ");
                this.printer.print(n.getExpr().toString());
                this.printer.print(" + 1");
                break;
            }
            case posDecrement: {
                this.printer.print(n.getExpr().toString());
                this.printer.print(" = ");
                this.printer.print(n.getExpr().toString());
                this.printer.print(" - 1");
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print("method ");
        this.printer.print(n.getName());
        if (inAnonymousClass > 0) {
            this.anonymousMethod = n.getName();
        }
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        if (n.getParameters() != null) {
            this.printer.print("(");
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(")");
        }
        this.printer.print(" ");
        this.printer.indent();
        this.printMethodVisibility(n.getModifiers());
        this.printMethodModifiers(n.getModifiers());
        this.printer.unindent();
        if (n.getThrows() != null) {
            this.printer.print(" signals ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = (NameExpr)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn();
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print("method ");
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        if (n.getParameters() != null) {
            this.printer.print("(");
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" )");
        }
        this.printer.print(" ");
        this.printer.indent();
        this.printMethodVisibility(n.getModifiers());
        this.printMethodModifiers(n.getModifiers());
        this.printer.unindent();
        if (!n.getType().getClass().getName().equals("japa.parser.ast.type.VoidType")) {
            this.printer.print(" returns ");
            n.getType().accept(this, arg);
        }
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        if (n.getThrows() != null) {
            this.printer.print(" signals ");
            Iterator<NameExpr> i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn();
        if (n.getBody() != null) {
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isVarArgs()) {
            this.printer.print("/* **nonrx**  ... ** */");
        }
        this.printer.print(" ");
        VariableDeclaratorId id = n.getId();
        this.printer.print(id.getName());
        this.printer.print("=");
        n.getType().accept(this, arg);
        if (id.getArrayCount() > 0) {
            this.printer.print("[");
            for (int i = 1; i < id.getArrayCount(); ++i) {
                this.printer.print(",");
            }
            this.printer.print("]");
        }
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            this.printer.print(v.getId().getName());
            this.printer.print(" = ");
            this.printer.print(n.getType().toString());
            this.printer.printLn();
            if (v.getInit() != null) {
                this.printer.print(v.getId().getName());
                this.printer.print(" = ");
                v.getInit().accept(this, arg);
            }
            if (!i.hasNext()) continue;
            this.printer.printLn();
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        if (n.getStmts() != null) {
            this.printer.indent();
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        n.getExpression().accept(this, arg);
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        if (n.getEntries() != null) {
            this.printer.printLn();
            this.printer.print("select");
            this.printer.printLn();
            boolean emptyWhen = false;
            for (SwitchEntryStmt e : n.getEntries()) {
                if (e.getLabel() != null) {
                    if (!emptyWhen) {
                        this.printer.print("when ");
                        emptyWhen = false;
                    }
                    this.printer.print(n.getSelector().toString());
                    this.printer.print(" = ");
                    this.printer.print(e.getLabel().toString());
                    if (e.getStmts() != null) {
                        this.printer.printLn(" then");
                        this.printer.printLn("do");
                    } else {
                        this.printer.print(" | ");
                        emptyWhen = true;
                    }
                } else {
                    this.printer.printLn("otherwise");
                }
                if (e.getStmts() == null) continue;
                this.printer.indent();
                for (Statement s : e.getStmts()) {
                    s.accept(this, arg);
                    this.printer.printLn();
                }
                this.printer.unindent();
                this.printer.printLn(" end ");
            }
        }
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        if (n.getLabel() != null) {
            n.getLabel().accept(this, arg);
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printer.print("leave");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("/* **nonrx**  enum ");
        this.printer.print(n.getName());
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getEntries() != null) {
            this.printer.printLn();
            i = n.getEntries().iterator();
            while (i.hasNext()) {
                EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getMembers() != null) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (n.getEntries() != null) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("} ** */");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (n.getClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printer.print("if ");
        n.getCondition().accept(this, arg);
        this.printer.print(" then do ");
        this.printer.printLn();
        if (n.getCondition().getBeginLine() == n.getThenStmt().getBeginLine()) {
            this.printer.indent();
        }
        n.getThenStmt().accept(this, arg);
        if (n.getCondition().getBeginLine() == n.getThenStmt().getBeginLine()) {
            this.printer.printLn();
            this.printer.unindent();
        } else {
            this.printer.printLn(" ");
        }
        this.printer.printLn(" end ");
        if (n.getElseStmt() != null) {
            if (n.getThenStmt().getBeginLine() == n.getElseStmt().getBeginLine()) {
                this.printer.indent();
            }
            this.printer.printLn("else do ");
            n.getElseStmt().accept(this, arg);
            if (n.getThenStmt().getBeginLine() == n.getElseStmt().getBeginLine()) {
                this.printer.printLn();
                this.printer.unindent();
            } else {
                this.printer.printLn(" ");
            }
            this.printer.printLn(" end ");
        }
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printer.print("loop while ");
        n.getCondition().accept(this, arg);
        this.printer.printLn();
        n.getBody().accept(this, arg);
        this.printer.printLn();
        this.printer.print(" end ");
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printer.print("while ");
        n.getCondition().accept(this, arg);
        this.printer.printLn(" ");
        n.getBody().accept(this, arg);
        this.printer.print(" end ");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printer.print("loop ");
        n.getVariable().accept(this, arg);
        this.printer.print(" over ");
        n.getIterable().accept(this, arg);
        this.printer.printLn(" ");
        n.getBody().accept(this, arg);
        this.printer.print(" end ");
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
        this.printer.printLn();
        this.printer.print("loop ");
        if (n.getCompare() != null) {
            this.printer.print("while ");
            n.getCompare().accept(this, arg);
        }
        this.printer.printLn();
        n.getBody().accept(this, arg);
        if (n.getUpdate() != null) {
            this.printer.indent();
            this.printer.printLn();
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
        this.printer.unindent();
        this.printer.printLn();
        this.printer.printLn(" end ");
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printer.print("signal ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printer.print("/* **nonrx**  synchronized ( ** */");
        n.getExpr().accept(this, arg);
        this.printer.print("/* **nonrx**  ) ** */");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printer.printLn("do ");
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.printLn("finally ");
            n.getFinallyBlock().accept(this, arg);
        }
        this.printer.print(" end ");
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printer.print(" catch ");
        n.getExcept().accept(this, arg);
        this.printer.printLn();
        n.getCatchBlock().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("/* **nonrx**  @interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("} ** */");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        this.printer.print("--");
        this.printer.printLn(n.getContent());
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    private static class SourcePrinter {
        private int level = 0;
        private boolean indented = false;
        private int index;
        private final ArrayList StringBuilderArrayList = new ArrayList();
        private StringBuilder buf;

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            this.index = classDepth;
            if (this.index > 0) {
                --this.index;
            }
            if (this.StringBuilderArrayList.size() < this.index + 1) {
                StringBuilder newbuf = new StringBuilder();
                this.StringBuilderArrayList.add(newbuf);
                this.buf = newbuf;
            } else {
                this.buf = (StringBuilder)this.StringBuilderArrayList.get(this.index);
            }
            for (int i = 0; i < this.level; ++i) {
                this.buf.append("    ");
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.index = classDepth;
            if (this.index > 0) {
                --this.index;
            }
            if (this.StringBuilderArrayList.size() < this.index + 1) {
                StringBuilder newbuf = new StringBuilder();
                this.StringBuilderArrayList.add(newbuf);
                this.buf = newbuf;
            } else {
                this.buf = (StringBuilder)this.StringBuilderArrayList.get(this.index);
            }
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.index = classDepth;
            if (this.index > 0) {
                --this.index;
            }
            if (this.StringBuilderArrayList.size() < this.index + 1) {
                StringBuilder newbuf = new StringBuilder();
                this.StringBuilderArrayList.add(newbuf);
                this.buf = newbuf;
            } else {
                this.buf = (StringBuilder)this.StringBuilderArrayList.get(this.index);
            }
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.StringBuilderArrayList.size(); ++i) {
                StringBuilder buf = (StringBuilder)this.StringBuilderArrayList.get(i);
                buffer.append(buf.toString());
            }
            return buffer.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

