/**********************************************************************/
/* REXX2INT: Convert GERMAN REXX file to INTERNATIONAL REXX format    */
/* vs 2, still quick and dirty,   Th. Schneider, 1997                 */
/* vs 3, process %INCLUDE directive (COMPILED REXX)                   */
/**********************************************************************/
fp_soft=''
fp_work=''

/* 1.) replace ! by vertical line (|) */
parse arg infile
say 'REXX2INT, INFILE='infile
x_infile=parsefid(infile)
parse var x_infile fn ft fp .
if (ft <> 'EXEC' & ft <> 'REXX') then do
   say 'infile:' infile ' is no EXEC or REXX file'
   exit 99
end

ft_out='SRX'        /* international REXX, no exclamation points */
outfile=fileid(fn,ft_out,fp_work)/* outfile in work diectory*/
call open infile
call scratch outfile
eof=0
nf=0
do while eof=0
  if (lines(infile)=0) then call end_include
  if (eof) then leave
  line=linein(infile)
  /* say line */
  line=translate(line,'|','!') /* dirty, not correct in any case */
  xop=lineout(outfile,line)
  /* note, that the CMS REXX COMPILER copies the %INCLUDE */
  if pos('/*%INCLUDE ',line) >0 then call beg_include
end
call close infile
call close outfile
return
beg_include:
   parse var line . '/*%INCLUDE 'inc_file '*/' .
   nf=nf+1
   files.nf=infile
   infile=fileid(inc_file,'REXXINCL',fp_soft)
   if exists(infile) then signal found_inc_file
   infile=fileid(inc_file,'EXEC',fp_soft)
   if exists(infile) then signal found_inc_file
   call info '... missing INCLUDE_file 'infile
   exit 99
found_inc_file:
   call info '... including: ' infile
   call open infile
   return
end_include:
/* say 'end_include' infile */
   if (nf > 0) then do
     call close infile
     infile=files.nf
     say 'reading 'infile 'again'
     nf=nf-1
   end
/* say 'lines('infile')='lines(infile) */
   if lines(infile) = 0 then do
      if (nf > 0) then signal end_include
      else do
        call close infile
        eof=1
      end
   end
 /*say 'EOF='eof*/
   return
