/** MsgSend.cmd **/
/******************************************/
/*                                        */
/* Command line syntax:                   */
/*                                        */
/* MsgSend To CC Subj Message             */
/*                                        */
/******************************************/
ARG Send_To Send_CC Subject Message Attachment
Say 'RexxVIM Send Message Program'
Say

/* Unload functions upon error */
SIGNAL ON ERROR NAME done

/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say


/* Initialize the VIM subsystem */
Session = ''
rc = RxVIMInitialize()
if (rc > 0) then call vimerr


/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
Session = ''
rc = RxVIMOpenSession('','','','Session')
if (rc > 0) then call vimerr


/* Create a new message of type VIM_MAIL */
rc = RxVIMCreateMessage(Session,'VIM_MAIL','Message')
if (rc > 0) then call vimerr


/* Set the header text */
hdrtext = subject
rc = RxVIMSetMessageHeader(Message,'VIMSEL_SUBJECT', hdrtext)
if (rc > 0) then call vimerr


/* Set the priority to high */
rc = RxVIMSetMessageHeader(Message,'VIMSEL_PRIORITY', 'VIM_HIGH_PRIORITY')
if (rc > 0) then call vimerr


/* Set the recipient to the user that is logged on */
/* This will send the message back to ourselves    */
rc = RxVIMSetMessageRecipient(Message,'VIMSEL_TO','VIMSEL_ENTITY','','',,
                Send_To,'','')
if (rc > 0) then call vimerr


/* Add some text to the message */
rc = RxVIMSetMessageItem(Message,'VIMSEL_NOTE_PART','VIM_TEXT','VIMSEL_NATIVE',,
         'Message Demo',MsgText,'')
if (rc > 0) then call vimerr


/* Add the config.sys as a file attachment in the message */
rc = RxVIMSetMessageItem(Message,'VIMSEL_ATTACH','VIM_TEXT','VIMSEL_NATIVE',,
         '','',Attachment)
if (rc > 0) then call vimerr


/* Send the message */
rc = RxVIMSendMessage(Message)
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

rc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information -----------------|'

if Status.1 = 'STATUS.1' then
  Say 'Cannot obtain error status information'
else do
  Say '  Error Text -' Status.1
  Say
  Say '  Ext Status -' Status.2
end

rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
exit
