/*  PATCH.CMD
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
 
say 'About to apply the C level patches...'
say
say 'Note: To be patched correctly, all of the VX-REXX DLLs must exist in the'
say 'VX-REXX directory. If you have moved your DLLs to another location you'
say 'must copy them back to the VX-REXX directory before applying the patch.'
say
say 'If the DLLs are not in the VX-REXX directory, press X now to exit and'
say 'restore them before applying the patch.'
say
say 'Press C to apply the patch or X to exit.'
c = SysGetKey( NOECHO )
if( c \= 'C' & c \= 'c' ) then do
    say '*** Patch process aborted ***'
    return
end    
say
say "Patching files..."
say
if( Stream("A2Z.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file A2Z.INF" 
    "@bpatch -p CPATCHES\INF\A2Z.C" 
end
if( Stream("BINDDBI.EXE", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file BINDDBI.EXE" 
    "@bpatch -p CPATCHES\EXE\BINDDBI.C" 
end
if( Stream("DBIDB22.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file DBIDB22.DLL" 
    "@bpatch -p CPATCHES\DLL\DBIDB22.C" 
end
if( Stream("DBIODBC.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file DBIODBC.DLL" 
    "@bpatch -p CPATCHES\DLL\DBIODBC.C" 
end
if( Stream("DBIWSQL.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file DBIWSQL.DLL" 
    "@bpatch -p CPATCHES\DLL\DBIWSQL.C" 
end
if( Stream("PMDBG.EXE", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file PMDBG.EXE" 
    "@bpatch -p CPATCHES\EXE\PMDBG.C" 
end
if( Stream( "PMEXE.NRZ", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Erasing file PMEXE.NRZ" 
    "@erase PMEXE.NRZ" 
end
if( Stream( "PMRUN.NRZ", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Erasing file PMRUN.NRZ" 
    "@erase PMRUN.NRZ" 
end
if( Stream("QUERYED.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file QUERYED.DLL" 
    "@bpatch -p CPATCHES\DLL\QUERYED.C" 
end
if( Stream("README.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file README.INF" 
    "@bpatch -p CPATCHES\INF\README.C" 
end
if( Stream("README2.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file README2.INF" 
    "@bpatch -p CPATCHES\INF\README2.C" 
end
if( Stream("VRCHT.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRCHT.DLL" 
    "@bpatch -p CPATCHES\DLL\VRCHT.C" 
end
if( Stream("VRCHT.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRCHT.INF" 
    "@bpatch -p CPATCHES\INF\VRCHT.C" 
end
if( Stream("VRCHTD.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRCHTD.DLL" 
    "@bpatch -p CPATCHES\DLL\VRCHTD.C" 
end
if( Stream("VRCHTR.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRCHTR.DLL" 
    "@bpatch -p CPATCHES\DLL\VRCHTR.C" 
end
if( Stream("VRCHTW.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRCHTW.DLL" 
    "@bpatch -p CPATCHES\DLL\VRCHTW.C" 
end
if( Stream("VRDB.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRDB.DLL" 
    "@bpatch -p CPATCHES\DLL\VRDB.C" 
end
if( Stream("VRDB.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRDB.INF" 
    "@bpatch -p CPATCHES\INF\VRDB.C" 
end
if( Stream("VREDIT.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VREDIT.DLL" 
    "@bpatch -p CPATCHES\DLL\VREDIT.C" 
end
if( Stream("VROBJ.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VROBJ.DLL" 
    "@bpatch -p CPATCHES\DLL\VROBJ.C" 
end
if( Stream("VRSED.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRSED.DLL" 
    "@bpatch -p CPATCHES\DLL\VRSED.C" 
end
if( Stream("VRXEDIT.EXE", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRXEDIT.EXE" 
    "@bpatch -p CPATCHES\EXE\VRXEDIT.C" 
end
if( Stream("VRXEDIT.HLP", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRXEDIT.HLP" 
    "@bpatch -p CPATCHES\HLP\VRXEDIT.C" 
end
 
say
say 'A number of files are no longer needed.'
say 'Do you want to delete them (you will be prompted for each)?'
parse upper pull response
if( Left( response, 1 ) = 'Y' ) then do
    say 'Delete WDB221B.BND (y/n)?'
    parse upper pull response
    if( Left( response, 1 ) = 'Y' ) then '@erase WDB221B.BND'
end
 
say
say "Patch application is complete."
say
say "You can now erase the CPATCHES directory"
say
say "The patch process has saved an original copy of each file that has been"
say "patched. These files have a .BAK extension and may be used to restore the"
say "original files or may be deleted."
