/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__: 

return

/*:VRX         CNCT_Database_Fini
*/
CNCT_Database_Fini:
 
    /*  Disconnect from the database
    */
    if( VRGet( "CNCT_Database", "Connected" ) = 1 ) then do
        if( VRGet( "CNCT_Database", "Changed" ) = 1 ) then do
            __message = "Changes have been made. Press Save to save them or Discard to throw them away."
            __button.0 = 2
            __button.1 = "~Save"
            __button.2 = "~Discard"
            __retcode = VRMessage( VRWindow(), __message, "Confirm", "Q", "__button.", 1, 2 )
            if( __retcode = 1 ) then do
              __method = "Commit"
            end
            else do
              __method = "Rollback"
            end
            if( VRMethod( "CNCT_Database", __method ) = 0 ) then do
                call VRMessage VRWindow(), method "failed:",
                    VRGet( "CNCT_Database", "Status" ), "Error", "E"
            end
        end
        if( VRMethod( "CNCT_Database", "Disconnect" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close connection:",
                VRGet( "CNCT_Database", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         CNCT_Database_Init
*/
CNCT_Database_Init:
 
    /*  Connect to the database
    */
    if( VRGet( "CNCT_Database", "Connected" ) = 0 ) then do
        if( VRMethod( "CNCT_Database", "Connect" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open connection:",
                VRGet( "CNCT_Database", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         EF_QRY_Student_Address_Change
*/
EF_QRY_Student_Address_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         EF_QRY_Student_Birthdate_Change
*/
EF_QRY_Student_Birthdate_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         EF_QRY_Student_Initials_Change
*/
EF_QRY_Student_Initials_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         EF_QRY_Student_Sex_Change
*/
EF_QRY_Student_Sex_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         EF_QRY_Student_Studnum_Change
*/
EF_QRY_Student_Studnum_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         EF_QRY_Student_Surname_Change
*/
EF_QRY_Student_Surname_Change:
    call QRY_Student_TextBox_Change
return
/*:VRX         FindSampleDB
*/
FindSampleDB: procedure
    /* Finds the location of the WATCOM SQL VX-Rexx database
    */

    vxdir = VALUE( 'vxrexx', , 'os2environment' )

    if( RIGHT(vxdir, 1) = '\' ) then do 
        vxdir = LEFT( vxdir, LENGTH(vxdir) - 1 )
    end
    
    vxdir = vxdir || "\wsample.db"
    
return vxdir
/*:VRX         Fini
*/
Fini:
    /* Globals.!Status = "Abort" if the DBCnct 'Cancel' buttons was pressed.
    */
    if( Globals.!Status = "OK" ) then do
        call QRY_Student_Fini
        call CNCT_Database_Fini
    end

    /* Destroy the window
    */
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0











/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Choose a database type
    */

    database_type = DBCnct( VRWindow() )

    if( database_type = "Abort" ) then do
        call Halt
    end
    
    /* Modify the connection object according to the selected database type.
    */

    if( database_type = "WSQL" ) then do
        call VRSet "CNCT_Database", "DataSource", "WATCOM SQL" 
        call VRSet "CNCT_Database", "userid", "dba" 
        call VRSet "CNCT_Database", "password", "sql" 

        fspec = FindSampleDB()
        call VRSet "CNCT_Database", "database", fspec         
    end
    else do
        /* IBM DB2/2 was choosen
        */

        call VRSet "CNCT_Database", "DataSource", "IBM DB2/2"    
        call VRSet "CNCT_Database", "userid", "" 
        call VRSet "CNCT_Database", "password", "" 
        call VRSet "CNCT_Database", "database", "wsample" 
    end

    /* Initialize the queries
    */

    call CNCT_Database_Init
    call QRY_Student_Init

    /* Load the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return











/*:VRX         PB_QRY_Student_Clear_Click
*/
PB_QRY_Student_Clear_Click:
    /* Call the Clear method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Clear" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not clear:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change
return
/*:VRX         PB_QRY_Student_Delete_Click
*/
PB_QRY_Student_Delete_Click:
    /* Call the Delete method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Delete" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not delete:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change

return
/*:VRX         PB_QRY_Student_First_Click
*/
PB_QRY_Student_First_Click:
    call VRMethod "QRY_Student", "MoveFirst"
    call QRY_Student_TextBox_Change
return
/*:VRX         PB_QRY_Student_Insert_Click
*/
PB_QRY_Student_Insert_Click:
    /* Call the Insert method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Insert" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not insert:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change

return
/*:VRX         PB_QRY_Student_Last_Click
*/
PB_QRY_Student_Last_Click:
    call VRMethod "QRY_Student", "MoveLast"
    call QRY_Student_TextBox_Change
return
/*:VRX         PB_QRY_Student_Next_Click
*/
PB_QRY_Student_Next_Click:
    call VRMethod "QRY_Student", "MoveNext"
    call QRY_Student_TextBox_Change
return
/*:VRX         PB_QRY_Student_Prev_Click
*/
PB_QRY_Student_Prev_Click:
    call VRMethod "QRY_Student", "MovePrev"
    call QRY_Student_TextBox_Change

return
/*:VRX         PB_QRY_Student_Reset_Click
*/
PB_QRY_Student_Reset_Click:
    /* Call the Reset method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Reset" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not reset:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change

return
/*:VRX         PB_QRY_Student_Search_Click
*/
PB_QRY_Student_Search_Click:
    /* Call the Search method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Search" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not search:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change

return
/*:VRX         PB_QRY_Student_Update_Click
*/
PB_QRY_Student_Update_Click:
    /* Call the Update method and check for an error
    */    

    ok = VRMethod( "QRY_Student", "Update" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not update:" VRGet( "QRY_Student", "Status" ),,
                       "Error", "E"
    end
    call QRY_Student_TextBox_Change

return
/*:VRX         QRY_Student_Fini
*/
QRY_Student_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_Student", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_Student", "RowChanged" ) ) then do
            if( VRMethod( "QRY_Student", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_Student", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_Student", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_Student", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_Student_Init
*/
QRY_Student_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_Student", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_Student", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_Student", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_Student_TextBox_Change
*/
QRY_Student_TextBox_Change: 
    procedure expose Globals.

    /* Modify the buttons according to the changed in the text box.
    */

    queryName = "QRY_Student"
    rowChanged = VRGet( queryName, "RowChanged" )

    button = "PB_" || queryName || "_Delete"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", \rowChanged
    end

    button = "PB_" || queryName || "_Insert"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Reset"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Update"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    /* Close the application
    */
    call Quit
return

