/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec

    if( ProjSaved( parent ) = 0 )then signal _VRELeaveMain

    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         AboutMenu_Click
*/
AboutMenu_Click:
    path = VREPath() || "MACROS\VXREZ\about.vrm"
    call VRMacro path, VRWindow()
return

/*:VRX         BeginWait
*/
BeginWait:
    window = VRWindow()
    call VRSet window, 'StatusText', arg(1)
    call VRSet window, 'Pointer', 'Wait'
return

/*:VRX         CompileFile
*/
CompileFile:
    call BeginWait 'Compiling file...'
    address cmd
    old = directory()
    dir = VRParseFileName( RCPath, 'dp' )
    call directory dir

    'rc -r' RCPath '>__out'

    call EndWait

    if( rc \= 0 )then do
        stem.1 = 'Compilation error:'
        stem.2 = ''
        i = 2
        do while lines( '__out' )
            i = i + 1
            stem.i = linein( '__out' )
        end
        call stream '__out', 'c', 'close'
        stem.0 = i
        call VRMessageStem VRWindow(), 'stem.', 'Edit Resources', 'none'
    end

    call VRDeleteFile '__old'
    call directory old
return

/*:VRX         CompileMenu_Click
*/
CompileMenu_Click:
    call SaveFile
    call CompileFile
return

/*:VRX         CopyMenu_Click
*/
CopyMenu_Click:
    call VRMethod 'MLE', 'Copy'
return

/*:VRX         CutMenu_Click
*/
CutMenu_Click:
    call VRMethod 'MLE', 'Cut'
return

/*:VRX         DeleteMenu_Click
*/
DeleteMenu_Click:
    call VRMethod 'Application', 'PostKeyString', 'MLE', '{Del}'
return

/*:VRX         EndWait
*/
EndWait:
    window = VRWindow()
    call VRSet window, 'StatusText', arg(1)
    call VRSet window, 'Pointer', '<Default>'
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         IconMenu_Click
*/
IconMenu_Click:
    dir = VRParseFileName( RCPath, 'DP' )
    old = directory()
    call directory dir
    'start /f iconedit'
    call directory old
return

/*:VRX         ImportFile
*/
ImportFile:
    if( arg() = 0 )then do
        path = VRParseFileName( RCPath, "DP" ) || '\*.*'
        do while( path \= '' )
            path = VRFileDialog( VRWindow(), 'Import file', 'o', path )
            if( path \= '' & VRFileExists( path ) = 1 )then leave
        end
    end; else do
        path = arg( 1 )
    end
    if( path = '' )then return
    
    event = VRGet( 'MLE', 'Change' )
    call VRSet 'MLE', 'Change', ''

    call BeginWait "Loading file..."

    value = charin( path, 1, chars( path ) )
    if( length( value ) > 0 )then do
        call VRMethod 'MLE', 'Insert', value
    end
    call stream path, 'c', 'close'

    call EndWait

    call VRSet 'MLE', 'Change', event
    MLEChanged = 1
return

/*:VRX         ImportMenu_Click
*/
ImportMenu_Click:
    call ImportFile
return

/*:VRX         Init
*/
Init:
    RCPath = VRParseFileName( ProjectPath, "DPN" ) || '.RC'
    MLEChanged = 0

    window = VRWindow()

/*
    call VRSet window, 'Caption', 'Editing RC File' VRParseFileName( RCPath, "NE" )
*/

    call VRSet 'MLE', 'Value', ''
    call ImportFile RCPath
    MLEChanged = 0

    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         InsertResource
*/
InsertResource: 
    path = VREPath() || "MACROS\VXREZ\resource.vrm"
    call VRMacro path, VRWindow(), arg(1)
    insert = result
    if( insert \= '' )then do
        call VRMethod 'MLE', 'Insert', insert || '0d'x
    end
return

/*:VRX         MLE_Change
*/
MLE_Change:
    MLEChanged = 1
return

/*:VRX         MLE_ContextMenu
*/
MLE_ContextMenu:
    call VRMethod 'EditMenu', 'Popup'
return

/*:VRX         OS2Menu_Click
*/
OS2Menu_Click:
    dir = VRParseFileName( RCPath, 'PD' )
    old = directory()
    call directory dir
    'start /k /f'
    call directory old
return

/*:VRX         PasteMenu_Click
*/
PasteMenu_Click:
    call VRMethod 'MLE', 'Paste'
return

/*:VRX         ProjSaved
*/
ProjSaved:
    parse arg parent
    ok = 1
    ProjectPath = VREProjPermPath()
    if( pos( '\', ProjectPath ) = 0 )then do
        msg = 'Please save the project to disk before editing any resources.'
        call VRMessage parent, msg, 'Edit Resources'
        ok = 0
    end
return ok

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ResourceMenu_Click
*/
ResourceMenu_Click:
    call InsertResource
return

/*:VRX         SaveFile
*/
SaveFile:
    call BeginWait 'Saving file...'
    call VRDeleteFile RCPath
    value = VRGet( 'MLE', 'Value' )
    if( length( value ) \= 0 )then do
        last = right( value, 1 )
        if( last \= '0a'x & last \= '0d'x )then do
            value = value || '0d'x
        end
    end
    call charout RCPath, value, 1
    call stream RCPath, 'c', 'close'
    MLEChanged = 0
    call EndWait
return

/*:VRX         SaveMenu_Click
*/
SaveMenu_Click:
    call SaveFile
return

/*:VRX         UndoMenu_Click
*/
UndoMenu_Click:
    call VRMethod 'MLE', 'Undo'
return

/*:VRX         Window1_Close
*/
Window1_Close:
    if( MLEChanged = 1 )then do
        buttons.0 = 3
        buttons.1 = '~Save'
        buttons.2 = '~Discard'
        buttons.3 = '~Cancel'
        default   = 1
        esc       = 3
        msg = 'File has changed.  Do you wish to save it before quitting?'
        response  = VRMessage( VRWindow(), msg, ,
                               'Edit Resources', 'q', ,
                               'buttons.', default, esc )
        if( response = 3 )then return
        if( response = 1 )then call SaveFile        
    end
    call Quit
return

/*:VRX         Window1_DragDrop
*/
Window1_DragDrop: 
    file = VRInfo( "SourceFile" )
    call InsertResource file
return

/*:VRX         Window1_Help
*/
Window1_Help: 
    address cmd 'view progguid.inf Adding resources to your project'
return

