/*  PATCH.CMD
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
 
say 'About to apply the C level patches...'
say
say 'Note: To be patched correctly, all of the VX-REXX DLLs must exist in the'
say 'VX-REXX directory. If you have moved your DLLs to another location you'
say 'must copy them back to the VX-REXX directory before applying the patch.'
say
say 'If the DLLs are not in the VX-REXX directory, press X now to exit and'
say 'restore them before applying the patch.'
say
say 'Press C to apply the patch or X to exit.'
c = SysGetKey( NOECHO )
if( c \= 'C' & c \= 'c' ) then do
    say '*** Patch process aborted ***'
    return
end    
say
say "Patching files..."
say
if( Stream("A2Z.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file A2Z.INF" 
    "@bpatch -p CPATCHES\INF\A2Z.C" 
end
if( Stream("PMDBG.EXE", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file PMDBG.EXE" 
    "@bpatch -p CPATCHES\EXE\PMDBG.C" 
end
if( Stream( "PMEXE.NRZ", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Erasing file PMEXE.NRZ" 
    "@erase PMEXE.NRZ" 
end
if( Stream( "PMRUN.NRZ", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Erasing file PMRUN.NRZ" 
    "@erase PMRUN.NRZ" 
end
if( Stream("README.INF", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file README.INF" 
    "@bpatch -p CPATCHES\INF\README.C" 
end
if( Stream("VREDIT.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VREDIT.DLL" 
    "@bpatch -p CPATCHES\DLL\VREDIT.C" 
end
if( Stream("VROBJ.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VROBJ.DLL" 
    "@bpatch -p CPATCHES\DLL\VROBJ.C" 
end
if( Stream("VRSED.DLL", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRSED.DLL" 
    "@bpatch -p CPATCHES\DLL\VRSED.C" 
end
if( Stream("VRXEDIT.EXE", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRXEDIT.EXE" 
    "@bpatch -p CPATCHES\EXE\VRXEDIT.C" 
end
if( Stream("VRXEDIT.HLP", "C", "QUERY EXISTS" ) \= "" ) then do
    say "Patching file VRXEDIT.HLP" 
    "@bpatch -p CPATCHES\HLP\VRXEDIT.C" 
end
 
 
say
say "Patch application is complete."
say
say "You can now erase the CPATCHES directory"
say
say "The patch process has saved an original copy of each file that has been"
say "patched. These files have a .BAK extension and may be used to restore the"
say "original files or may be deleted."
