/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.PSZ;

public final class FontData {
    String name;
    int height;
    int style;
    public String szFacename;
    public short fsSelection;
    String lang;
    String country;
    String variant;

    public FontData() {
        this.name = "";
        this.szFacename = "";
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException e) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException e) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        if (end == -1) {
            return;
        }
        String platform = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            return;
        }
        String version2 = string.substring(start, end);
        if (platform.equals("OS2") && version2.equals("1")) {
            start = end + 1;
            if ((end = string.indexOf(124, start)) == -1) {
                return;
            }
            this.szFacename = string.substring(start, end);
            try {
                start = end + 1;
                end = string.length();
                this.fsSelection = Short.parseShort(string.substring(start, end));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
        this.szFacename = "";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fd = (FontData)object;
        return this.name.equals(fd.name) && this.height == fd.height && this.style == fd.style && this.szFacename.equals(fd.szFacename) && this.fsSelection == fd.fsSelection;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.height ^ this.style ^ this.szFacename.hashCode() ^ this.fsSelection;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setLocale(String locale) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (locale != null) {
            int secondSep;
            int sep = 95;
            int length = locale.length();
            int firstSep = locale.indexOf(sep);
            if (firstSep == -1) {
                firstSep = secondSep = length;
            } else {
                secondSep = locale.indexOf(sep, firstSep + 1);
                if (secondSep == -1) {
                    secondSep = length;
                }
            }
            if (firstSep > 0) {
                this.lang = locale.substring(0, firstSep);
            }
            if (secondSep > firstSep + 1) {
                this.country = locale.substring(firstSep + 1, secondSep);
            }
            if (length > secondSep + 1) {
                this.variant = locale.substring(secondSep + 1);
            }
        }
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
        this.szFacename = "";
    }

    public void setStyle(int style) {
        this.style = style & 3;
        this.szFacename = "";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        buffer.append("OS2|1|");
        buffer.append(this.szFacename);
        buffer.append("|");
        buffer.append(this.fsSelection);
        return buffer.toString();
    }

    public static FontData pm_new(FATTRS handle) {
        FontData fd = new FontData();
        fd.name = handle.fm_szFamilyname;
        fd.height = handle.height;
        fd.style = 0;
        if (handle.fm_usWeightClass > 5) {
            fd.style |= 1;
        }
        if ((handle.fm_fsSelection & 1) != 0) {
            fd.style |= 2;
        }
        fd.szFacename = new PSZ(handle.szFacename).toString();
        fd.fsSelection = handle.fsSelection;
        return fd;
    }

    public FATTRS getFAttrs() {
        FATTRS fAttrs = new FATTRS();
        fAttrs.szFacename = new PSZ(this.szFacename).getBytes();
        fAttrs.height = this.height;
        fAttrs.fm_usWeightClass = (short)((this.style & 1) != 0 ? 7 : 5);
        fAttrs.fm_fsSelection = (this.style & 2) != 0 ? (short)1 : 0;
        fAttrs.fsSelection = this.fsSelection;
        fAttrs.usRecordLength = (short)56;
        return fAttrs;
    }
}

