/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinDefWindowProc(this.handle, msg, mp1, mp2);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        RECTL rect = new RECTL();
        rect.xLeft = x;
        rect.xRight = x + width;
        rect.yTop = y + height;
        rect.yBottom = y;
        OS.WinCalcFrameRect(this.handle, rect, false);
        if (this.horizontalBar != null) {
            rect.yTop += OS.WinQuerySysValue(this.handle, 23);
        }
        if (this.verticalBar != null) {
            rect.xRight += OS.WinQuerySysValue(this.handle, 22);
        }
        int nWidth = rect.xRight - rect.xLeft;
        int nHeight = rect.yTop - rect.yBottom;
        return new Rectangle(rect.xLeft, rect.yBottom, nWidth, nHeight);
    }

    ScrollBar createScrollBar(int type) {
        ScrollBar bar = new ScrollBar(this, type);
        if ((this.state & 0x1000) != 0) {
            bar.setMaximum(100);
            bar.setThumb(10);
        }
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.parent != null && this.parent.pswp != 0) {
            Control.endDeferWindowPos(this.parent);
            int count = this.parent.getChildrenCount();
            Control.beginDeferWindowPos(this.parent, count);
        }
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        return rect;
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseWidget();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseWidget();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20000;
        if ((this.style & 0x100) != 0) {
            bits |= 0;
        }
        if ((this.style & 0x200) != 0) {
            bits |= 1;
        }
        return bits;
    }

    PSZ windowClass() {
        return this.getDisplay().windowClass;
    }

    int windowProc() {
        return this.getDisplay().windowProc;
    }

    MRESULT WM_HSCROLL(int mp1, int mp2) {
        MRESULT result = super.WM_HSCROLL(mp1, mp2);
        if (result != null) {
            return result;
        }
        return result;
    }

    MRESULT WM_SIZE(int mp1, int mp2) {
        int code = this.callWindowProc(7, mp1, mp2);
        super.WM_SIZE(mp1, mp2);
        if (code == 0) {
            return MRESULT.ZERO;
        }
        return new MRESULT(code);
    }

    MRESULT WM_VSCROLL(int mp1, int mp2) {
        MRESULT result = super.WM_VSCROLL(mp1, mp2);
        if (result != null) {
            return result;
        }
        return result;
    }

    MRESULT wmScroll(int msg, int mp1, int mp2) {
        boolean type = false;
        ScrollBar bar = this.horizontalBar;
        if (msg == 49) {
            type = true;
            bar = this.verticalBar;
        }
        if (bar == null) {
            return null;
        }
        int nPos = bar.getSelection();
        int nMax = bar.getMaximum();
        int nMin = bar.getMinimum();
        switch (OS.SHORT2FROMMP(mp2)) {
            case 7: {
                return null;
            }
            case 2: 
            case 5: 
            case 6: {
                nPos += bar.getIncrement();
                break;
            }
            case 1: {
                int increment = bar.getIncrement();
                nPos = Math.max(nMin, nPos - increment);
                break;
            }
            case 4: {
                nPos += bar.getPageIncrement();
                break;
            }
            case 3: {
                int pageIncrement = bar.getPageIncrement();
                nPos = Math.max(nMin, nPos - pageIncrement);
            }
        }
        OS.WinSendMsg(this.handle, 417, nPos, 0);
        return null;
    }
}

