/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.SWP;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    Display display;
    Menu activeMenu;
    boolean showWithParent;
    Control lastActive;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.getDisplay() : null, parent, style, 1);
    }

    public static Shell pm_new(Display display, int handle) {
        return new Shell(display, null, 8, handle);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    public void close() {
        this.checkWidget();
        OS.WinPostMsg(this.frameHandle, 41, 0, 0);
    }

    void createHandle() {
        super.createHandle();
        SWP swp = new SWP();
        OS.WinQueryTaskSizePos(this.getDisplay().hab, 0, swp);
        OS.WinSetWindowPos(this.frameHandle, 0, swp.x, swp.y, swp.cx, swp.cy, 3);
    }

    void createWidget() {
        super.createWidget();
    }

    public void dispose() {
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        OS.WinSetFocus(1, this.frameHandle);
    }

    int getBounds(SWP swp) {
        if ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0) {
            return super.getBounds(swp);
        }
        int parentHeight = this.getParentHeight();
        OS.WinQueryWindowPos(this.frameHandle, swp);
        swp.y = parentHeight - (swp.y + swp.cy);
        return parentHeight;
    }

    public Display getDisplay() {
        if (this.display == null) {
            this.error(24);
        }
        return this.display;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (!Display.TrimEnabled) {
            return super.getEnabled();
        }
        return (this.state & 0x40) == 0;
    }

    int getParentHeight() {
        return this.display.getHeight();
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public void open() {
        this.checkWidget();
        this.bringToTop();
        this.setVisible(true);
        if (!this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.releaseWidget();
                shell.releaseHandle();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseShells();
        super.releaseWidget();
        this.activeMenu = null;
        this.display.clearModal(this);
        this.display = null;
        this.lastActive = null;
    }

    void remove(Menu menu) {
        super.remove(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    MRESULT selectPalette(int hPalette) {
        int hps = OS.WinGetPS(this.frameHandle);
        OS.GpiSelectPalette(hps, hPalette);
        int[] cclr = new int[1];
        OS.WinRealizePalette(this.frameHandle, hps, cclr);
        OS.WinReleasePS(hps);
        OS.WinInvalidateRect(this.frameHandle, null, true);
        return MRESULT.ZERO;
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        int i2 = activate.length - 1;
        while (i2 >= index) {
            if (!activate[i2].isDisposed()) {
                activate[i2].sendEvent(26);
            }
            --i2;
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if ((OS.WinQueryWindowULong(this.frameHandle, -2) & 0x1000000) != 0) {
            super.setBounds(x, y, width, height, flags);
            return;
        }
        SWP swp = new SWP();
        int parentHeight = this.getBounds(swp);
        if ((flags & 2) != 0) {
            swp.x = x;
            swp.y = y;
        }
        if ((flags & 1) != 0) {
            swp.cx = width;
            swp.cy = height;
            flags |= 2;
        }
        swp.y = parentHeight - (swp.y + swp.cy);
        OS.WinSetWindowPos(this.frameHandle, 0, swp.x, swp.y, swp.cx, swp.cy, flags);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (!Display.TrimEnabled) {
            super.setEnabled(enabled);
        } else {
            this.state &= 0xFFFFFFBF;
            if (!enabled) {
                this.state |= 0x40;
            }
            if (this.isActive()) {
                this.setItemEnabled(32772, enabled);
            }
        }
    }

    void setItemEnabled(int cmd, boolean enabled) {
        int hMenu = OS.WinWindowFromID(this.frameHandle, 32770);
        if (hMenu == 0) {
            return;
        }
        OS.WinSendMsg(hMenu, 402, OS.MPFROM2SHORT((short)cmd, (short)1), OS.MPFROM2SHORT((short)16384, enabled ? (short)0 : 16384));
    }

    void setParent() {
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int bits = OS.WinQueryWindowULong(this.frameHandle, -2);
        if ((bits & 4) != 0) {
            OS.WinSetWindowULong(this.frameHandle, -2, bits &= 0xFFFFFFFB);
            this.layout(false);
        }
        super.setVisible(visible);
        if (this.showWithParent == visible) {
            return;
        }
        this.showWithParent = visible;
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModal(this);
                Control control = this.display.getFocusControl();
                if (control != null && !control.isActive()) {
                    this.bringToTop();
                }
                OS.WinSetCapture(1, 0);
            } else {
                this.display.clearModal(this);
            }
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
        if (!Display.TrimEnabled) {
            return;
        }
        this.setItemEnabled(32772, this.isActive());
    }

    int widgetFrameStyle() {
        int bits = super.widgetFrameStyle();
        if (this.parent == null) {
            bits |= 8;
        }
        return bits | 4;
    }

    MRESULT FRAME_WM_REALIZEPALETTE(int mp1, int mp2) {
        int hPalette = this.display.hPalette;
        if (hPalette != 0) {
            return this.selectPalette(hPalette);
        }
        return super.FRAME_WM_REALIZEPALETTE(mp1, mp2);
    }

    MRESULT WM_COMMAND(int mp1, int mp2) {
        return super.WM_COMMAND(mp1, mp2);
    }
}

