/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messagesSize;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;

    public Synchronizer(Display display) {
        this.display = display;
    }

    void addLast(RunnableLock entry) {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messagesSize == this.messages.length) {
                RunnableLock[] newMessages = new RunnableLock[this.messagesSize + 4];
                System.arraycopy(this.messages, 0, newMessages, 0, this.messagesSize);
                this.messages = newMessages;
            }
            this.messages[this.messagesSize++] = entry;
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable != null) {
            this.addLast(new RunnableLock(runnable));
        }
        this.display.wake();
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messagesSize == 0) {
                RunnableLock runnableLock = null;
                return runnableLock;
            }
            RunnableLock lock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messagesSize);
            this.messages[this.messagesSize] = null;
            if (this.messagesSize == 0) {
                this.messages = null;
            }
            RunnableLock runnableLock = lock;
            return runnableLock;
        }
    }

    boolean runAsyncMessages() {
        if (this.messagesSize == 0) {
            return false;
        }
        RunnableLock lock;
        while ((lock = this.removeFirst()) != null) {
            RunnableLock runnableLock = lock;
            synchronized (runnableLock) {
                Object var5_4;
                this.syncThread = lock.thread;
                try {
                    try {
                        lock.run();
                    }
                    catch (Throwable t) {
                        lock.throwable = t;
                        SWT.error(46, t);
                        var5_4 = null;
                        this.syncThread = null;
                        lock.notifyAll();
                    }
                    var5_4 = null;
                    this.syncThread = null;
                    lock.notifyAll();
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    this.syncThread = null;
                    lock.notifyAll();
                    throw throwable;
                }
            }
        }
        return true;
    }

    protected void syncExec(Runnable runnable) {
        if (this.display.isValidThread()) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        if (runnable == null) {
            this.display.wake();
            return;
        }
        RunnableLock lock = new RunnableLock(runnable);
        lock.thread = Thread.currentThread();
        RunnableLock runnableLock = lock;
        synchronized (runnableLock) {
            this.addLast(lock);
            this.display.wake();
            boolean interrupted = false;
            while (!lock.done()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Compatibility.interrupt();
            }
            if (lock.throwable != null) {
                SWT.error(46, lock.throwable);
            }
        }
    }
}

