/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

class ProgressBarTab
extends RangeTab {
    ProgressBar progressBar1;
    Group progressBarGroup;
    Button smoothButton;

    ProgressBarTab(ControlExample instance) {
        super(instance);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.progressBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.progressBarGroup.setLayout((Layout)new GridLayout());
        this.progressBarGroup.setLayoutData((Object)new GridData(784));
        this.progressBarGroup.setText("ProgressBar");
    }

    void createExampleWidgets() {
        int style = 0;
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.smoothButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.progressBar1 = new ProgressBar((Composite)this.progressBarGroup, style);
        this.progressBar1.setMaximum(100);
        this.progressBar1.setSelection(50);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.smoothButton = new Button((Composite)this.styleGroup, 32);
        this.smoothButton.setText("SWT.SMOOTH");
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.progressBar1};
    }

    String getTabText() {
        return "ProgressBar";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.maximumScale.setMaximum(this.progressBar1.getMaximum());
        this.smoothButton.setSelection((this.progressBar1.getStyle() & 0x10000) != 0);
    }

    void setWidgetMaximum() {
        this.progressBar1.setMaximum(this.maximumScale.getSelection());
        this.updateScales();
    }

    void setWidgetMinimum() {
        this.progressBar1.setMinimum(this.minimumScale.getSelection());
        this.updateScales();
    }

    void setWidgetSelection() {
        this.progressBar1.setSelection(this.selectionScale.getSelection());
        this.updateScales();
    }

    void updateScales() {
        this.minimumScale.setSelection(this.progressBar1.getMinimum());
        this.selectionScale.setSelection(this.progressBar1.getSelection());
        this.maximumScale.setSelection(this.progressBar1.getMaximum());
    }
}

