/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

abstract class RangeTab
extends Tab {
    Button horizontalButton;
    Button verticalButton;
    Scale minimumScale;
    Scale selectionScale;
    Scale maximumScale;

    RangeTab(ControlExample instance) {
        super(instance);
    }

    void createControlWidgets() {
        this.createMinimumGroup();
        this.createMaximumGroup();
        this.createSelectionGroup();
    }

    void createMaximumGroup() {
        Group maximumGroup = new Group((Composite)this.controlGroup, 0);
        maximumGroup.setLayout((Layout)new GridLayout());
        maximumGroup.setText(ControlExample.getResourceString("Maximum"));
        maximumGroup.setLayoutData((Object)new GridData(768));
        this.maximumScale = new Scale((Composite)maximumGroup, 0);
        this.maximumScale.setMaximum(100);
        this.maximumScale.setSelection(100);
        this.maximumScale.setPageIncrement(10);
        this.maximumScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.maximumScale.setLayoutData((Object)data);
        this.maximumScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetMaximum();
            }
        });
    }

    void createMinimumGroup() {
        Group minimumGroup = new Group((Composite)this.controlGroup, 0);
        minimumGroup.setLayout((Layout)new GridLayout());
        minimumGroup.setText(ControlExample.getResourceString("Minimum"));
        minimumGroup.setLayoutData((Object)new GridData(768));
        this.minimumScale = new Scale((Composite)minimumGroup, 0);
        this.minimumScale.setMaximum(100);
        this.minimumScale.setPageIncrement(10);
        this.minimumScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.minimumScale.setLayoutData((Object)data);
        this.minimumScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetMinimum();
            }
        });
    }

    void createSelectionGroup() {
        Group selectionGroup = new Group((Composite)this.controlGroup, 0);
        selectionGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        selectionGroup.setLayoutData((Object)gridData);
        selectionGroup.setText(ControlExample.getResourceString("Selection"));
        this.selectionScale = new Scale((Composite)selectionGroup, 0);
        this.selectionScale.setMaximum(100);
        this.selectionScale.setSelection(50);
        this.selectionScale.setPageIncrement(10);
        this.selectionScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.selectionScale.setLayoutData((Object)data);
        this.selectionScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetSelection();
            }
        });
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setWidgetMinimum();
        this.setWidgetMaximum();
        this.setWidgetSelection();
        Control[] controls = this.getExampleWidgets();
        if (controls.length != 0) {
            this.horizontalButton.setSelection((controls[0].getStyle() & 0x100) != 0);
            this.verticalButton.setSelection((controls[0].getStyle() & 0x200) != 0);
            this.borderButton.setSelection((controls[0].getStyle() & 0x800) != 0);
        }
    }

    abstract void setWidgetMaximum();

    abstract void setWidgetMinimum();

    abstract void setWidgetSelection();
}

