/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ShellTab
extends Tab {
    Button noParentButton;
    Button parentButton;
    Button noTrimButton;
    Button closeButton;
    Button titleButton;
    Button minButton;
    Button maxButton;
    Button borderButton;
    Button resizeButton;
    Button onTopButton;
    Button createButton;
    Button closeAllButton;
    Button modelessButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Group parentStyleGroup;
    Group modalStyleGroup;
    int shellCount = 0;
    Shell[] shells = new Shell[4];

    ShellTab(ControlExample instance) {
        super(instance);
    }

    void closeAllShells() {
        int i = 0;
        while (i < this.shellCount) {
            if (this.shells[i] != null & !this.shells[i].isDisposed()) {
                this.shells[i].dispose();
            }
            ++i;
        }
        this.shellCount = 0;
    }

    public void createButtonSelected(SelectionEvent event) {
        if (this.shellCount >= this.shells.length) {
            Shell[] newShells = new Shell[this.shells.length + 4];
            System.arraycopy(this.shells, 0, newShells, 0, this.shells.length);
            this.shells = newShells;
        }
        int style = 0;
        if (this.noTrimButton.getSelection()) {
            style |= 8;
        }
        if (this.closeButton.getSelection()) {
            style |= 0x40;
        }
        if (this.titleButton.getSelection()) {
            style |= 0x20;
        }
        if (this.minButton.getSelection()) {
            style |= 0x80;
        }
        if (this.maxButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.resizeButton.getSelection()) {
            style |= 0x10;
        }
        if (this.onTopButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.modelessButton.getSelection()) {
            style |= 0;
        }
        if (this.primaryModalButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.applicationModalButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.systemModalButton.getSelection()) {
            style |= 0x20000;
        }
        if (this.noParentButton.getSelection()) {
            this.shells[this.shellCount] = new Shell(style);
        } else {
            Shell shell = this.tabFolderPage.getShell();
            this.shells[this.shellCount] = new Shell(shell, style);
        }
        Button button = new Button((Composite)this.shells[this.shellCount], 8);
        button.setBounds(20, 20, 100, 30);
        this.shells[this.shellCount].setSize(300, 100);
        this.shells[this.shellCount].setText(String.valueOf(ControlExample.getResourceString("Title")) + this.shellCount);
        this.shells[this.shellCount++].open();
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.controlGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        gridLayout = new GridLayout();
        this.styleGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.styleGroup.setLayoutData((Object)new GridData(1808));
        this.styleGroup.setText(ControlExample.getResourceString("Styles"));
        this.parentStyleGroup = new Group((Composite)this.styleGroup, 0);
        this.parentStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(256);
        this.parentStyleGroup.setLayoutData((Object)gridData);
        this.parentStyleGroup.setText(ControlExample.getResourceString("Parent"));
    }

    void createControlWidgets() {
        this.noParentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.noParentButton.setText(ControlExample.getResourceString("No_Parent"));
        this.parentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.parentButton.setText(ControlExample.getResourceString("Parent"));
        Group decorationStyleGroup = new Group((Composite)this.styleGroup, 0);
        decorationStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(256);
        gridData.verticalSpan = 2;
        decorationStyleGroup.setLayoutData((Object)gridData);
        decorationStyleGroup.setText(ControlExample.getResourceString("Decoration_Styles"));
        this.noTrimButton = new Button((Composite)decorationStyleGroup, 32);
        this.noTrimButton.setText("SWT.NO_TRIM");
        this.closeButton = new Button((Composite)decorationStyleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        this.titleButton = new Button((Composite)decorationStyleGroup, 32);
        this.titleButton.setText("SWT.TITLE");
        this.minButton = new Button((Composite)decorationStyleGroup, 32);
        this.minButton.setText("SWT.MIN");
        this.maxButton = new Button((Composite)decorationStyleGroup, 32);
        this.maxButton.setText("SWT.MAX");
        this.borderButton = new Button((Composite)decorationStyleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.resizeButton = new Button((Composite)decorationStyleGroup, 32);
        this.resizeButton.setText("SWT.RESIZE");
        this.onTopButton = new Button((Composite)decorationStyleGroup, 32);
        this.onTopButton.setText("SWT.ON_TOP");
        this.modalStyleGroup = new Group((Composite)this.styleGroup, 0);
        this.modalStyleGroup.setLayout((Layout)new GridLayout());
        this.modalStyleGroup.setText(ControlExample.getResourceString("Modal_Styles"));
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        this.modalStyleGroup.setLayoutData((Object)gridData);
        this.modelessButton = new Button((Composite)this.modalStyleGroup, 16);
        this.modelessButton.setText("SWT.MODELESS");
        this.primaryModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        this.createButton = new Button((Composite)this.styleGroup, 0);
        gridData = new GridData(128);
        this.createButton.setLayoutData((Object)gridData);
        this.createButton.setText(ControlExample.getResourceString("Create_Shell"));
        this.closeAllButton = new Button((Composite)this.styleGroup, 0);
        gridData = new GridData(32);
        this.closeAllButton.setText(ControlExample.getResourceString("Close_All_Shells"));
        this.closeAllButton.setLayoutData((Object)gridData);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTab.this.createButtonSelected(e);
            }
        });
        this.closeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTab.this.closeAllShells();
            }
        });
        SelectionAdapter decorationButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShellTab.this.decorationButtonSelected(event);
            }
        };
        this.noTrimButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.closeButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.titleButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.minButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.maxButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.borderButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.resizeButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.applicationModalButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.systemModalButton.addSelectionListener((SelectionListener)decorationButtonListener);
        this.noParentButton.setSelection(true);
        this.modelessButton.setSelection(true);
    }

    public void decorationButtonSelected(SelectionEvent event) {
        Button widget = (Button)event.widget;
        if (widget == this.applicationModalButton || widget == this.systemModalButton) {
            if (widget.getSelection()) {
                this.closeButton.setSelection(true);
                this.noTrimButton.setSelection(false);
            }
            return;
        }
        if (widget == this.closeButton && (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection())) {
            this.closeButton.setSelection(true);
        }
        if (widget.getSelection() && widget != this.noTrimButton) {
            this.noTrimButton.setSelection(false);
            return;
        }
        if (widget.getSelection() && widget == this.noTrimButton) {
            if (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection()) {
                this.noTrimButton.setSelection(false);
                return;
            }
            this.closeButton.setSelection(false);
            this.titleButton.setSelection(false);
            this.minButton.setSelection(false);
            this.maxButton.setSelection(false);
            this.borderButton.setSelection(false);
            this.resizeButton.setSelection(false);
            return;
        }
    }

    String getTabText() {
        return "Shell";
    }
}

