/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class TableTab
extends ScrollableTab {
    Table table1;
    Group tableGroup;
    Group tableItemGroup;
    Button checkButton;
    Button fullSelectionButton;
    Button headerVisibleButton;
    Button linesVisibleButton;
    Button itemBackgroundButton;
    Button itemForegroundButton;
    Color itemBackgroundColor;
    Color itemForegroundColor;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[] stringLine0 = new String[]{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")};
    static String[] stringLine1 = new String[]{ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")};
    static String[] stringLine2 = new String[]{ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")};

    TableTab(ControlExample instance) {
        super(instance);
    }

    void createColorGroup() {
        super.createColorGroup();
        this.tableItemGroup = new Group((Composite)this.colorGroup, 0);
        this.tableItemGroup.setText(ControlExample.getResourceString("Item_Colors"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.tableItemGroup.setLayoutData((Object)data);
        this.tableItemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.tableItemGroup, 0).setText(ControlExample.getResourceString("Item_Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.tableItemGroup, 8);
        new Label((Composite)this.tableItemGroup, 0).setText(ControlExample.getResourceString("Item_Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.tableItemGroup, 8);
        Shell shell = this.itemBackgroundButton.getShell();
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        final Image itemBackgroundImage = new Image((Device)display, imageSize, imageSize);
        final Image itemForegroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemBackgroundButton.setImage(itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb = backgroundDialog.open();
                if (rgb == null) {
                    return;
                }
                Color oldColor = TableTab.this.itemBackgroundColor;
                TableTab.this.itemBackgroundColor = new Color((Device)TableTab.this.itemBackgroundButton.getDisplay(), rgb);
                TableTab.this.setItemsBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemForegroundButton.setImage(itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb = foregroundDialog.open();
                if (rgb == null) {
                    return;
                }
                Color oldColor = TableTab.this.itemForegroundColor;
                TableTab.this.itemForegroundColor = new Color((Device)TableTab.this.itemForegroundButton.getDisplay(), rgb);
                TableTab.this.setItemsForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemBackgroundButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (itemBackgroundImage != null) {
                    itemBackgroundImage.dispose();
                }
                if (itemForegroundImage != null) {
                    itemForegroundImage.dispose();
                }
                if (TableTab.this.itemBackgroundColor != null) {
                    TableTab.this.itemBackgroundColor.dispose();
                }
                if (TableTab.this.itemForegroundColor != null) {
                    TableTab.this.itemForegroundColor.dispose();
                }
                TableTab.this.itemBackgroundColor = null;
                TableTab.this.itemForegroundColor = null;
            }
        });
    }

    void createDisplayGroup() {
        super.createDisplayGroup();
        this.headerVisibleButton = new Button((Composite)this.displayGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.linesVisibleButton = new Button((Composite)this.displayGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetHeaderVisible();
            }
        });
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetLinesVisible();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.tableGroup = new Group((Composite)this.exampleGroup, 0);
        this.tableGroup.setLayout((Layout)new GridLayout());
        this.tableGroup.setLayoutData((Object)new GridData(784));
        this.tableGroup.setText("Table");
    }

    void createExampleWidgets() {
        TableColumn tableColumn;
        int style = 0;
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.table1 = new Table((Composite)this.tableGroup, style);
        int i = 0;
        while (i < columnTitles.length) {
            tableColumn = new TableColumn(this.table1, 0);
            tableColumn.setText(columnTitles[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            TableItem item = new TableItem(this.table1, 0);
            item.setImage(this.instance.images[i % 3]);
            switch (i % 3) {
                case 0: {
                    TableTab.stringLine0[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine0);
                    break;
                }
                case 1: {
                    TableTab.stringLine1[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine1);
                    break;
                }
                case 2: {
                    TableTab.stringLine2[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine2);
                }
            }
            ++i;
        }
        i = 0;
        while (i < columnTitles.length) {
            tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.table1};
    }

    String getTabText() {
        return "Table";
    }

    void setItemsBackground() {
        if (this.itemBackgroundButton == null) {
            return;
        }
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getBackground();
        }
        Image image = this.itemBackgroundButton.getImage();
        this.drawImage(image, color);
        this.itemBackgroundButton.setImage(image);
        if (this.itemBackgroundColor == null) {
            return;
        }
        TableItem[] items = this.table1.getSelection();
        int i = 0;
        while (i < items.length) {
            items[i].setBackground(this.itemBackgroundColor);
            ++i;
        }
    }

    void setItemsForeground() {
        if (this.itemForegroundButton == null) {
            return;
        }
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getForeground();
        }
        Image image = this.itemForegroundButton.getImage();
        this.drawImage(image, color);
        this.itemForegroundButton.setImage(image);
        if (this.itemForegroundColor == null) {
            return;
        }
        TableItem[] items = this.table1.getSelection();
        int i = 0;
        while (i < items.length) {
            items[i].setForeground(this.itemForegroundColor);
            ++i;
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemsBackground();
        this.setItemsForeground();
        this.setWidgetHeaderVisible();
        this.setWidgetLinesVisible();
        this.checkButton.setSelection((this.table1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.table1.getStyle() & 0x10000) != 0);
    }

    void setWidgetHeaderVisible() {
        this.table1.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetLinesVisible() {
        this.table1.setLinesVisible(this.linesVisibleButton.getSelection());
    }
}

