/* M.DLL usage example */

/* Just to make sure everything fits on one screen */

'@MODE 80,25'

/* Add all available functions of "M" to Rexx */

CALL RxFuncAdd 'MLoadFuncs','M','MLoadFuncs'
CALL MLoadFuncs

/* Make sure the environment is the expected one */

CALL MReset
CALL MScreenSize 25,80

/* Same as '@CLS' or SysCls, and show the usage instructions */

CALL MCls
SAY '        =============================================================='
SAY '        Select a drive by selecting that drive, or by typing the drive'
SAY '        letter. Select the line with "Exit", or press the <ESC>-key to' 
SAY '        stop. Other keyboard input or selections will select no drive.' 
SAY '        =============================================================='
SAY

/* Enable keyboard support */

CALL MKeyboard 'ON'

/* Cursor is visible due to the enabled keyboard support. Hide it: */ 

CALL MCurHide 3

/* Assign HotSpot (=return) value of 27 to the <ESC> key (key 27) */

CALL MHotKey 27,27

/* Assign HotSpot value of 27 to the whole current line */

CALL MHotLine 27
SAY ' '||Copies(D2C(250),17) 'Exit' Copies(D2C(250),55)

SAY
drive.0='none.'
drive.27='none (selection cancelled)'.

/* Uncomment the following line to avoid the selection of a ColdSpot, */
/* i.e. the selection of "drive.0" */

/* CALL MHandle 3 */

DO i=1 TO 13
   j=i+13
   drive.i=D2C(i+64)||':'
   drive.j=D2C(i+77)||':'
   
   /* Assign a HotSpot value of 1-26 to each drive used here */

   CALL MHotSpot (i*80)+570,(i*80)+577,i
   CALL MHotSpot (i*80)+584,(i*80)+591,i+13   
   
   /* Assign a HotSpot value of 1-26 to drive/key "A-Z" */

   CALL MHotKey i+64,i
   CALL MHotKey i+77,j
   
   /* Assign a HotSpot value of 1-26 to drive/key "a-z" */ 

   CALL MHotKey i+96,i
   CALL MHotKey i+109,j
   
   SAY '          Drive' drive.i '     Drive' drive.j
END i

/* Mouse() applies all of the above settings */ 

selected=Mouse()

SAY
SAY 'Selected drive is' drive.selected

EXIT
