#define INCL_PM
#define INCL_DOSPROCESS        // 㦥  DosSleep()
#define INCL_DOSMISC
#define INCL_DOSMODULEMGR
#define INCL_DOSRESOURCES
#include <os2.h>
#define min(a,b)  ( ((a) < (b)) ? (a) : (b) )
#define max(a,b)  ( ((a) > (b)) ? (a) : (b) )
#include "setup.h"
#include "myheader.h"
#define INCL_REXXSAA
#include <rexxsaa.h>
/**************************************************************************/
/* ⨯ 㭪権                                                      */
/**************************************************************************/
MRESULT EXPENTRY WndDlgProc( HWND, ULONG, MPARAM, MPARAM );
VOID SetDlgItemPos( LONG, LONG );

/**************************************************************************/
/* ⠭                                                              */
/**************************************************************************/
#define RETURN_ERROR         1      // 祭   訡
#define MSG_WARN_SIZE       80      //  ᮮ饭  訡
//   㦭 㬥
#define GetArg(num)  ((char *)((&ArgCount)[num]))


/**************************************************************************/
/*  ६                                                  */
/**************************************************************************/
HAB  hab;
HWND hwndMain;
//稪 ⨩   Next
static ULONG NextCounter=0;
static char AppName[255]={0};
/**************************************************************************/
/* 㭪 뢠  REXX  믮 ਯ  ᮢ */
/* ࠬ: ScriptID   - 䨪 ਯ                 */
/*            ArgCount   - ⢮ । ਯ 㬥⮢     */
/*            Arg1..Argn - 㬥                                      */
/**************************************************************************/
ULONG _System ExecScript(ULONG ScriptID, ULONG ArgCount,...) {
ULONG rc,i,ret;
PRXSTRING parg;                     /* argument strings for REXX  */
RXSTRING rexxretval;                /* return value from REXX    */
RXSTRING Instore[2];
SHORT rexxrc;
char * str;
    rc=DosQueryResourceSize(0,REXX_TYPE,ScriptID,&(Instore[0].strlength));
    if (!rc) {
       rc=DosGetResource(0,REXX_TYPE,ScriptID,&(Instore[0].strptr));
    }
    if (rc) return REXX_ERROR;
    rexxretval.strlength=0;       // force REXX to allocate memory itself
    Instore[1].strlength = 0;
    Instore[1].strptr = NULL;
    DosAllocMem(&parg,sizeof(RXSTRING)*ArgCount,PAG_COMMIT|PAG_WRITE|PAG_READ);
    for (i=0;i<ArgCount;i++) {
        str=GetArg(i+1);
        parg[i].strlength=strlen(str);
        parg[i].strptr=str;
    }
    rc=RexxStart(ArgCount,                  /* number of arguments   */
                 parg,                      /* array of arguments    */
                (PSZ)        "script.cmd",  /* name of REXX file     */
                (PRXSTRING)  Instore,       /* No INSTORE used       */
                (PSZ)        "CMD",         /* Command env. name     */
                (LONG)       RXFUNCTION,    /* Code for how invoked  */
                (PRXSYSEXIT) 0,             /* No EXITs on this call */
                (PSHORT)     &rexxrc,       /* Rexx program output   */
                (PRXSTRING)  &rexxretval ); /* Rexx program output   */
    if (rexxretval.strlength)
        HexToULong(rexxretval.strptr,&ret);
    else
        ret=0;
    DosFreeMem(rexxretval.strptr);
    DosFreeMem(Instore[1].strptr);
    DosFreeMem(parg);
    return ret;
}

/**************************************************************************/
/* 㭪 ⨢/⨢              */
/* ࠬ: ItemID     - 䨪                   */
/*            Enable     - TRUE:  ⨢஢                          */
/*                         FALSE: ⨢஢                        */
/**************************************************************************/
ULONG _System EnableDialogItem(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id, parm,rc;
     ret->strlength=0;
     if (argc!=2) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     HexToULong(argv[1].strptr,&parm);
     rc=WinEnableControl(hwndMain,id,parm);
     if (rc) rc=0;else rc=1;
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}

/**************************************************************************/
/* 㭪 뢠/뢠                      */
/* ࠬ: ItemID     - 䨪                   */
/*            Enable     - TRUE:                                  */
/*                         FALSE:                                   */
/**************************************************************************/
ULONG _System ShowDialogItem(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id, parm,rc;
     ret->strlength=0;
     if (argc!=2) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     HexToULong(argv[1].strptr,&parm);
     rc=WinShowControl(hwndMain,id,parm);
     if (rc) rc=0;else rc=1;
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}

/**************************************************************************/
/* 㭪 ⠭ ⥪                             */
/* ࠬ: ItemID     - 䨪                   */
/*            Text       - ப ⥪                                  */
/**************************************************************************/

ULONG _System SetDialogItemText(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id,rc;
     ret->strlength=0;
     if (argc!=2) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     rc=WinSetDlgItemText(hwndMain,id,argv[1].strptr);
     if (rc) rc=0;else rc=1;
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}
/**************************************************************************/
/* 㭪 頥 ⥪                                */
/* ࠬ: ItemID     - 䨪                   */
/**************************************************************************/

ULONG _System GetDialogItemText(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id;
     if (argc!=1) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     if (WinQueryDlgItemText(hwndMain,id,ret->strlength,ret->strptr)) ret->strlength=strlen(ret->strptr);
     return 0;

}
/**************************************************************************/
/* 㭪 ⠭ ⥪    㪠      */
/* ࠬ: ItemID     - 䨪                   */
/*            TextID     - 䨪  ⨯ TEXT_TYPE           */
/**************************************************************************/

ULONG _System SetDialogItemTextFromResource(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id, parm,rc;
     char * ResPtr;
     ret->strlength=0;
     if (argc!=2) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     HexToULong(argv[1].strptr,&parm);
     rc=DosGetResource(0,TEXT_TYPE,parm,&ResPtr);
     if (!rc) {
       rc=WinSetDlgItemText(hwndMain,id,ResPtr);
       if (rc) rc=0;else rc=1;
     }
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}

/**************************************************************************/
/* 㭪 頥 ﭨ                              */
/* ࠬ: ItemID     - 䨪                   */
/**************************************************************************/

ULONG _System GetDialogButtonState(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id,rc;
     if (argc!=1) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     rc=WinQueryButtonCheckstate(hwndMain,id);
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;

}

/**************************************************************************/
/* 㭪 㤠 㪠 䠩.                                        */
/* ࠬ: FileName   -  䠩   ⥬                       */
/**************************************************************************/
ULONG _System DeleteFile(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG rc;
     ret->strlength=0;
     if (argc!=1) {
        return -1;
     }
     //ࠧ稢 䠩  
     rc=DosReplaceModule(argv[0].strptr,NULL,NULL);
     //㤠塞 .
     rc=DosDelete(argv[0].strptr);
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}
/**************************************************************************/
/* 㭪 뢠 㪠    䠩,  室 */
/*  騩 䠩.                                             */
/* ࠬ: FileID     - 䨪 ୮                 */
/*            FileName   -  䠩   ⥬                       */
/*            FileVer    -  䠩 BCD (ᯮ㥬 ६ ᮧ)   */
/**************************************************************************/


ULONG _System WriteFileFromResource(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG id, parm,rc,size,action;
     char * ResPtr;
     HFILE f;
     FILESTATUS3 fstat;

     ret->strlength=0;
     if (argc!=3) {
        return -1;
     }
     HexToULong(argv[0].strptr,&id);
     HexToULong(argv[2].strptr,&parm);
     do {
       rc=DosGetResource(0,FILE_TYPE,id,&ResPtr);
       if (rc) break;
       //ࠧ稢 䠩  
       DosReplaceModule(argv[1].strptr,NULL,NULL);
       //㤠塞 .
       DosDelete(argv[1].strptr);
       rc=DosQueryResourceSize(0,FILE_TYPE,id,&size);
       if (rc) break;
       rc=DosOpen(argv[1].strptr,
                &f,
                &action,
                0,
                0,
                OPEN_ACTION_REPLACE_IF_EXISTS|
                OPEN_ACTION_CREATE_IF_NEW,
                OPEN_SHARE_DENYREADWRITE|
                OPEN_ACCESS_WRITEONLY,
                0);
       if (rc) break;
       rc=DosWrite(f,ResPtr,size,&action);
       if (rc) {
          DosClose(f);
          break;
       }
       rc=DosQueryFileInfo(f,FIL_STANDARD,&fstat,sizeof(FILESTATUS3));
       fstat.ftimeLastWrite.hours=(parm>>8)&0x1f;
       fstat.ftimeLastWrite.minutes=(parm&0x3f);
       rc=DosSetFileInfo(f,FIL_STANDARD,&fstat,sizeof(FILESTATUS3));
       DosClose(f);
     }while (0);
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}
/**************************************************************************/
/* 뢮 ᥤ  ᮮ饭                                        */
/* ࠬ:  Title - ப                                    */
/*             Msg   - ⥪ ᮮ饭                                    */
/*             Style - ⨫                                          */
/**************************************************************************/


ULONG _System DisplayMsgBox(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG style,rc;
     ret->strlength=0;
     if (argc!=3) {
        return -1;
     }
     HexToULong(argv[2].strptr,&style);
     rc=WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, argv[1].strptr,
        argv[0].strptr, ID_MSGBOX,  style );
     ret->strlength=8;
     ULongToHex(ret->strptr,rc);
     return 0;
}
/**************************************************************************/
/* 㭪 頥 㪢 ⮢ ᪠                                */
/* ࠬ -                                                         */
/**************************************************************************/
ULONG _System GetBootDrive(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ULONG BootNum;
     ret->strlength=2;
     DosQuerySysInfo(5,5,&BootNum,4);
     ret->strptr[0]=(char)(0x40+BootNum);
     ret->strptr[1]=0x3a;
     return 0;
}

/**************************************************************************/
/* 㭪 頥 , 㤠 뫠 饭 ணࠬ                */
/* ࠬ -                                                         */
/**************************************************************************/
ULONG _System GetStartPath(
     PSZ       name,                   /* name of the function       */
     LONG      argc,                   /* number of arguments        */
     RXSTRING  argv[],                 /* list of argument strings   */
     PSZ       que,                    /* current queue name         */
     PRXSTRING ret)                    /* returned result string     */
{
     ret->strlength=strlen(AppName);
     memcpy(ret->strptr,AppName,ret->strlength);
     return 0;
}

/**************************************************************************/
/* ⠡ REXX-callable 㭪権                                          */
/**************************************************************************/
REXXFUNC  FuncArray[]={
          {"EnableDialogItem",                   EnableDialogItem},
          {"ShowDialogItem",                     ShowDialogItem},
          {"SetDialogItemText",                  SetDialogItemText},
          {"GetDialogItemText",                  GetDialogItemText},
          {"SetDialogItemTextFromResource",      SetDialogItemTextFromResource},
          {"GetDialogButtonState",               GetDialogButtonState},
          {"DeleteFile",                         DeleteFile},
          {"WriteFileFromResource",              WriteFileFromResource},
          {"DisplayMsgBox",                      DisplayMsgBox},
          {"GetBootDrive",                       GetBootDrive},
          {"GetStartPath",                       GetStartPath}
          };
/**************************************************************************/
/*  㭪 ਫ                                            */
/* 砥 ࠢ  ᪥ ਫ                             */
/**************************************************************************/
int _System main()
{
   HMQ    hmq;
   QMSG   qmsg;
/**************************************************************************/
/* 樠  䥩                                      */
/*                                                                        */
/* (***)  ᬮ   㢥७  ਬ, WinMessageBox()  ࠡ⠥ */
/*         ,   祭 hab   ᮧ । ᮮ饭.  */
/*       ⮬  訡  ᮮ頥 ਥ ᨣ.                */
/**************************************************************************/
   hab = WinInitialize( 0 );
   if ( hab == NULLHANDLE )
   {
      return ( RETURN_ERROR );
   }


/**************************************************************************/
/*  । ᮮ饭                                             */
/**************************************************************************/
   hmq = WinCreateMsgQueue( hab, 0 );
   if ( hmq == NULLHANDLE )
   {
      return ( RETURN_ERROR );
   }


/**************************************************************************/
/*    ਫ (Dialog)                               */
/**************************************************************************/
   hwndMain = WinLoadDlg( HWND_DESKTOP, //  ࠧ
                 HWND_DESKTOP,          //  ᮡ⢥
                 WndDlgProc,            // 楤 ࠡ⪨ 
                 (HMODULE)0,            // 0 -  EXE   #0 -  DLL
                 ID_MAIN,               // 䨪   
                 NULL);                 //   樠樨
   if ( hwndMain == NULLHANDLE )
   {
      WinDestroyMsgQueue( hmq );
      WinTerminate( hab );
      return ( RETURN_ERROR );
   }


/**************************************************************************/
/*  ࠡ⪨ ᮮ饭                                               */
/**************************************************************************/
   while( WinGetMsg( hab, &qmsg, 0, 0, 0 ) )
      WinDispatchMsg( hab, &qmsg );


/**************************************************************************/
/* ⨥ ਫ                                                    */
/**************************************************************************/
   WinDestroyWindow( hwndMain );
   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );
   return ( 0 );
}



/**************************************************************************/
/* 㭪   (Dialog)                                         */
/**************************************************************************/
MRESULT EXPENTRY WndDlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
      case WM_INITDLG:
         WinPostMsg( hwnd, MY_QUERYSIZE, NULL, NULL );
         return (MRESULT)TRUE;

      case MY_QUERYSIZE:
         {
            SWCNTRL swctl;
            HSWITCH hswitch;
            ULONG i;
            swctl.hwnd = hwndMain;
            swctl.hwndIcon = hwndMain;
            swctl.hprog = NULLHANDLE;
            swctl.idProcess = 0;
            swctl.idSession = 0;
            swctl.uchVisibility = SWL_VISIBLE;
            swctl.fbJump = SWL_JUMPABLE;
            swctl.szSwtitle[0] = 0x00;
            swctl.szSwtitle[MAXNAMEL+1] = 0x00;
            hswitch = WinAddSwitchEntry( &swctl );
            for (i=0;i<11;i++)
                RexxRegisterFunctionExe(FuncArray[i].FuncName,FuncArray[i].FuncEntry);
            i=ExecScript(ID_REXX1+NextCounter,0);
            NextCounter=i;

         }
         break;

      case WM_CLOSE:
         WinPostMsg( hwnd, WM_QUIT, NULL, NULL );
         break;
      case WM_COMMAND:
         switch( SHORT1FROMMP( mp1 ) )
         {
            case ID_EXIT:
               WinPostMsg( hwnd, WM_CLOSE, NULL, NULL );
               break;
            case ID_NEXT:
            {
             ULONG  q;
            // ᮡ⢥   ந室   ࠡ...
             q=ExecScript(ID_REXX1+NextCounter,0);
             NextCounter=q;
             return (MRESULT)TRUE;
             break;
            }
            default:
               return WinDefDlgProc( hwnd, msg, mp1, mp2 );
               break;
         }
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
         break;


/**************************************************************************/
/* WinDefDlgProc,  㬮砭                                            */
/**************************************************************************/
      default:
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   }

   return (MRESULT)FALSE;
}

const char HexDigits[]="0123456789ABCDEF";

void ULongToHex(char * buffer, ULONG value) {
ULONG i;
    for (i=0;i<8;i++)
        buffer[i]=HexDigits[(value>>(28-4*i))&0xf];
}

void HexToULong(const char * buffer, PULONG value) {
ULONG i,j,temp;
    i=0;
    *value=0;
    while ((i<8)) {
       for (j=0;j<16;j++) if (buffer[i]==HexDigits[j]) temp=j;
       *value=((*value)<<4)|temp;
       i++;
    }
}
