/* */

/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs

/* =============================================================================== */
/** Read in and display all lines of text from config.sys. **/

handle = FileOpen('c:\config.sys', 'r', "e")
IF handle = 0 THEN DO
   SAY "Error opening file 'c:\config.sys'"
   EXIT
END

DO FOREVER
    contents = FileGets(handle)
    IF FILEERR = 0 THEN LEAVE
    SAY contents
END

err = FileClose(handle)
IF err <> 0 THEN SAY "Error closing file"


/* =============================================================================== */
/* FileDropFuncs: This unloads all of the functions in the FILEREXX DLL. That lets REXX */
/* close the DLL. We could otherwise live it open for some other REXX script */
CALL FileDropFuncs
