/**
 * REXX Communication Control Function Library  Ver.1.1
 *                  copyright 1998, Naga(Kazuo Adachi)
 *                          mailto:nagaw@ibm.net
 *                          mailto:GDB00421@nifty.ne.jp
 *
 * $Id$
 *
 * $Log$
 */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

CALL RxFuncAdd 'RxCommLoadFuncs','RxComm','RxCommLoadFuncs'
CALL RxCommLoadFuncs

/**
 * Setup Communication Parameter
 */
comPort = 'COM2'

/**
 * COM Port Device Open
 */
rc = RxCommOption( 'SEND_CTLCH', 'ON' )
rc = RxCommOpen( comPort, 115200, '8N1' )
IF rc <> 0 THEN
DO
    SAY 'Can Not Open COM Port!!'
    EXIT
END

SAY 'Let''s Start Communication!!'

SAY 'Modem Signal(Start) =' RxCommSignal()

/*--------------------------------------------------------*/
/**
 * Write COM Device Test.
 */
rc = RxCommWrite( 'ATZ\r' )
DO FOREVER
    rc = RxCommRead()
    IF rc <> '' THEN
    DO
        CALL CHAROUT , rc

        IF POS( 'OK', rc ) > 0 THEN LEAVE
    END
END

/*--------------------------------------------------------*/
/**
 * Setup Modem Signal Test
 */
lineDTR = ''
lineRTS = 'OFF'

SAY 'Modem Signal(Modify) =' RxCommSignal( lineDTR, lineRTS )

/**
 * Write COM Device Test.
 */
rc = RxCommWrite( 'ATZ\r' )
DO FOREVER
    rc = RxCommRead( 100 )
    IF rc =  '' THEN LEAVE
    IF rc <> '' THEN
    DO
        CALL CHAROUT , rc

        IF POS( 'OK', rc ) > 0 THEN LEAVE
    END
END

rc = RxCommClose()

