/* SUN.CMD - Calculates Sunrise and Sunsets */
/* Developed by Lone Peak Automation (c) 2009 */
/* http://home.att.net/~LPAInfo */

/* ======== Function to calculate Sunrise and Sunset  ======= */
/*  

    Calling convention: Sundata = EPHM(LocLat, LocLong, LocDate, LocTZ, LocDST, SunAngle)

    Output:
            Sundata will contain a real number in the format of sunrise.sunset
            in this format: HHMM.HHMM.
            i.e if Sundata = 745.1850 then Sunrise = 7:45 and Sunset = 18:50

    Input:
            LocLat = DD.MMSS LATITUDE (north = positive) DD.MMSS Salt Lake City = 41.0246; Bonn = 50.43

            LocLong = DD.MMSS LONGITUDE (west = positive) DD.MMSS Salt Lake City = 111.0324; Bonn = -7.04

            LocDate = Local Date in this format YYYYMMDD. i.e. March 15, 2008 = 20080315

            LocTZ = Time Zone (west of GMT = positive, east of GMT = negative) 
                    i.e. Utah = 7; Bonn, Deutschland = -1

            LocDST = Daylight savings time flag.
                     Daylight savings time not active LocDST = 0
                     Daylight savings time active LocDST = 1

            SunAngle = use -6 degrees for civil dawn/dusk
                       use -12 degrees for nautical dawn/dusk
                       use -18 degrees for astronomical dawn/dusk
                       use -0.833 degrees for sunrise/sunset
                       (any floating positive or negative number is accepted)


    Note: DD.MMSS = Local coordinates in the form of Degrees Minutes Seconds

*/

/*
This sample program calculates the sunrise and sunset times in Salt Lake City, Utah, USA
for the first day of each month of the year 2008 and saves it to the file SUN.TXT.
Daylight savings time is included in the calculations from April through November.
*/

/* Load ephDLL */
call RxFuncAdd 'EPHLoadFuncs', 'rxephDLL', 'EPHLoadFuncs'
call EPHLoadFuncs

/* Log file */
LogFile = 'sun.txt'

LocLong = 111.54  /* DDD.MMSS */
LocLat = 41.48    /* DD.MMSS */
LocDate = 20080101
LocTZ = 7
LocDST = 0
SunAngle = -6  /* this is for civil dawn/dusk */

SAY 'Sunrise and sunset data using REXX DLL'
SAY 'Long = ' || LocLong || ' Lat = ' || LocLat

rc=LINEOUT(LogFile, 'Sunrise and sunset data using REXX DLL')
rc=LINEOUT(LogFile, 'Long = ' || LocLong || ' Lat = ' || LocLat)

DO i = 1 TO 12   /* loop through months of January to December */
    j = i
    IF i < 10 THEN
      j = '0' || j   /* month must be two digits */

   LocDate = '2008' || j || '01'  /* date is for 2008, months Jan - Dec and day = 1 */

   IF i > 3 & i < 12 THEN   /* check when daylight savings time is in effect (April to November) */
      LocDST = 1   /* daylight savings time for SLC */
   ELSE
      LocDST = 0   /* standard time for SLC */

   temp = EPHM(LocLat, LocLong, LocDate, LocTZ, LocDST, SunAngle)  /* get sunrise.sunset times */

   Sunrise = TRUNC(temp)  /* get sunrise only */
   Sunset = TRUNC((temp - Sunrise) * 10000)  /* get sunset only */

   SunriseFormat =  Sunrise % 100 || ":" || RIGHT(Sunrise, 2)  /* format time as HH:MM */
   SunsetFormat =  Sunset % 100 || ":" || RIGHT(Sunset, 2)

   SAY LocDate || ' ' || temp || ' ' || Sunrise || ' ' || Sunset || ' ' || SunriseFormat || ' ' || SunsetFormat

   rc=LINEOUT(LogFile, LocDate || ' ' || temp || ' ' || Sunrise || ' ' || Sunset || ' ' || SunriseFormat || ' ' || SunsetFormat)

END
rc=LINEOUT(LogFile) /* close file */

call EPHDropFuncs

EXIT
