//----------------------------------------------------------
//
// ACSTEST.C -- Test the AccessWPS Agent to verify it is working
//
//----------------------------------------------------------
#pragma strings(readonly)
#define OFF        0
#define ON         1
#ifndef NO
#define NO         0
#endif
#ifndef YES
#define YES        1
#endif
#define GOOD       0
#define BAD        1
typedef unsigned long APRINI;
typedef int SIGNED;
typedef SIGNED *PSIGNED;
typedef unsigned int UNSIGNED;
typedef UNSIGNED *PUNSIGNED;
#define MAXNAME    255
#define GROUPNAME  50
#define null       '\0'
#define THREAD_STACK_SIZE     81920
#define INCL_BASE
#define INCL_WIN
#define INCL_GPI
#define INCL_DEV
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_SPLERRORS
#define INCL_SHLERRORS
#define INCL_WINSTDDRAG
#include <conio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <mscsubs.h>
#include <time.h>
#include <io.h>
#include <memory.h>
#include <malloc.h>
#include <search.h>
#include <math.h>
#include <direct.h>
#include <process.h>
#include <types.h>
#include <stat.h>
#include "accsswps.h"
VOID AcsTestThread(PVOID);
HWND         hwndFrame, hwndListbox;
CHAR         chMessage[MAXNAME];
int main (void) {
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU |
                                 FCF_SIZEBORDER    | FCF_MINMAX  |
                                 FCF_SHELLPOSITION | FCF_TASKLIST;
   HAB          hab;
   HMQ          hmq;
   QMSG         qmsg;
   HPOINTER     hpTemp;
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);
   hwndFrame = WinCreateStdWindow(
      HWND_DESKTOP,                   // Parent window handle
      WS_VISIBLE,                     // Style of frame window
      &flFrameFlags,                  // Pointer to control data
      WC_LISTBOX,                     // Make it a Listbox
      (PSZ)"AccessWPS Test",          // Title bar text
      LS_NOADJUSTPOS | LS_HORZSCROLL, // Style of client window
      0,                              // Module handle for resources
      0,                              // ID of resources
      &hwndListbox);                   // Pointer to client window handle
   hpTemp = WinQuerySysPointer(HWND_DESKTOP, SPTR_APPICON, FALSE);
   (VOID)WinSendMsg(hwndFrame, WM_SETICON, MPFROMP(hpTemp), 0L);
   (VOID)DosBeep(261, 100);
   (VOID)DosBeep(330, 100);
   (VOID)DosBeep(392, 100);
   (VOID)DosBeep(523, 500);
   if (_beginthread(AcsTestThread, (PVOID)NULL, THREAD_STACK_SIZE, NULL)
      == -1) {
      sprintf(chMessage, "AcsAgent Test Thread Could not be Started");
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   }
   while (WinGetMsg(hab, &qmsg, NULL, 0, 0))
        (VOID)WinDispatchMsg(hab, &qmsg);
   (VOID)WinDestroyWindow(hwndFrame);
   (VOID)WinDestroyMsgQueue(hmq);
   (VOID)WinTerminate(hab);
   (VOID)DosBeep(523, 100);
   (VOID)DosBeep(392, 100);
   (VOID)DosBeep(330, 100);
   (VOID)DosBeep(261, 500);
   exit(0);
}
VOID AcsTestThread(PVOID pvPassed)
{
   HAB         habThread;
   HMQ         hmqThread;
   PCHAR       pchMessage;
   BOOL        fAcsErr;
// the only real purpose for the pchMessage variable is to keep PC Lint
//    from conplaining that the pvPassed variable...which is NULL...is
//    not used. it is used a few places below, but chMessage could have
//    been used also.
   pchMessage = (PCHAR)pvPassed;
// set up an anchor block for the thread
   habThread = WinInitialize(0);
   hmqThread = WinCreateMsgQueue(habThread, 0);
// indicate the thread has been started
   pchMessage = chMessage;
   sprintf(chMessage, "AcsAgent Test Thread Started");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
// initialize the agent object
   sprintf(chMessage, "Starting AcsAgent Object Creation");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
   if (AcsInit() != NO_ERROR) {
      fAcsErr = AcsReturnError();
      sprintf(chMessage, "AcsAgent Object Creation Failed Error = %u",
         fAcsErr);
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   // if we got an error, we do not want to try to get the version
      goto do_dump;
   }
   else {
      sprintf(chMessage, "AcsAgent Object Creation Successful");
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   }
   sprintf(chMessage, "Getting Version Information");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
   memset(chMessage, null, MAXNAME);
   AcsVersion(chMessage);
   if (chMessage[0] == null)
      sprintf(chMessage, "Version Information Could not be Obtained");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
do_dump:
// do the dump of the agent stuff
   sprintf(chMessage, "Starting AcsAgent Object Variable Dump");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
dump_more:
   memset(chMessage, null, MAXNAME);
   fAcsErr = AcsDumpLine(chMessage);
   if (chMessage[0] != null) {
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   }
   if (fAcsErr == TRUE) goto dump_more;
   sprintf(chMessage, "AcsAgent Object Variable Dump Completed");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
// terminate the agent object
   sprintf(chMessage, "Starting AcsAgent Object Termination");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
   if (AcsTerminate() != NO_ERROR) {
      fAcsErr = AcsReturnError();
      sprintf(chMessage, "AcsAgent Object Termination Failed Error = %u",
         fAcsErr);
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   }
   else {
      sprintf(chMessage, "AcsAgent Object Termination Successful");
      (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
         MPFROMP(chMessage));
   }
// indicate the thread is ending
   sprintf(chMessage, "AcsAgent Test Thread Terminating");
   (VOID)WinSendMsg(hwndListbox, LM_INSERTITEM, MPFROMSHORT(LIT_END),
      MPFROMP(chMessage));
// destroy the anchor block
   (VOID)WinDestroyMsgQueue(hmqThread);
   (VOID)WinTerminate(habThread);
// end the thread
   _endthread();
}
