//+----------------------------------------------------------------------------+
//| MODEMENGINE.CPP                                                            |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) Sacha Prins, 1995, 1996.                                    |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is code created by Sacha Prins.             |
//|  The code is provided "AS IS", without warranty of any kind. Sacha Prins   |
//|  shall not be liable for any damages arising out of your use of the        |
//|  [enclosed] code.                                                          |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|    22-jun-1996: Initial release to the public                              |
//+----------------------------------------------------------------------------+
#define INCL_DOSSEMAPHORES
#define INCL_DOSFILEMGR
#define INCL_DOSDEVIOCTL
#define INCL_DOSDEVICES
#define INCL_DOSPROCESS
#define INCL_DOSSESMGR
#define INCL_DOSQUEUES
#define INCL_DOSERRORS
#include <os2.h>

#include "\work\modemengine\ModemEngine.h"
#include "\work\modemengine\ModemEngine.hpp"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stream.h>

#define BUFFERSIZE      1024
#define PIPESIZE        65335
#define MESSAGE_QUEUE_NAME              "\\QUEUES\\ANSWERING_MACHINE\\MESSAGE_QUEUE.QUEUE"
#define DLE_QUEUE_NAME                  "\\QUEUES\\ANSWERING_MACHINE\\DLE_QUEUE.QUEUE"

void _System dummyMessageLoopThread (ULONG modem_engine);

void _System dummyRxLoopThread (ULONG modem_engine);

void _Optlink dummyMessageLoopThread2 (void * modem_engine);

void _Optlink dummyRxLoopThread2 (void * modem_engine);

//*****************************************************
// MODEM_ENGINE(...) constructor
//*****************************************************
MODEM_ENGINE :: MODEM_ENGINE (PCHAR _deviceName, FLOW_CONTROL fc, int key) {
        APIRET  rc;

   do {
      operational= FALSE;
      resultCode= noerror;

// // DATE & TIME CHECK
//     DATETIME dateTime;
//     DosGetDateTime (&dateTime);
//     if (dateTime.year != 1995) {
//        break;
//     }
// // END DATE & TIME CHECK
   //---------------------------------------------------------
   // INITIALIZE deviceName
       deviceName = (PCHAR) malloc (strlen (_deviceName)+1);
       strcpy (deviceName, _deviceName);

       if ( !mOpenCOM(fc) || key != 6127181) {
          resultCode= errorOPENCOM;
          break;
       }

      UCHAR        paramPacket=0;
      USHORT       dataPacket=0;
      ULONG        cbParamPacket, cbDataPacket;

      DosDevIOCtl (hcom, IOCTL_GENERAL, DEV_FLUSHINPUT, &paramPacket, sizeof(paramPacket), &cbParamPacket, &dataPacket, sizeof (dataPacket), &cbDataPacket);


   // END INITIALIZE deviceName
   //---------------------------------------------------------
   // INITIALIZE hMessageQueue;
       rc= DosCreateQueue (&hMessageQueue, QUE_FIFO | QUE_CONVERT_ADDRESS, MESSAGE_QUEUE_NAME);
       if (rc) { resultCode= errorCREATEMESSAGEQUEUE; break; }
   // END INITIALIZE hMessageQueue;
   //---------------------------------------------------------
   // INITIALIZE hDLEQueue;
       rc= DosCreateQueue (&hDLEQueue, QUE_FIFO | QUE_CONVERT_ADDRESS, DLE_QUEUE_NAME);
       if (rc) { resultCode= errorCREATEDLEQUEUE; break; }
   // END INITIALIZE hMessageQueue;
   //---------------------------------------------------------
   // INITIALIZE state
       state=idle;
   // END INITIALIZE state
   //---------------------------------------------------------
   // INITIALIZE modemResponse
       modemResponse.code=none;
       modemResponse.verbose[0]=0;
   // END INITIALIZE modemResponse

   // INITIALIZE AT#??? defaults
       device=                 voice;
       bitRange=               four;
       vmLine=                 phone;
       deadMan=                0;
       silenceDetection=       TRUE;
       silenceDetectionValue=  60;
       silenceDeletion=        FALSE;
   // END INITIALIZE AT#??? defaults
   //---------------------------------------------------------
   // INITIALIZE semaphores
       DosCreateMutexSem (NULL, &hModemResponseSem, 0, FALSE);
       DosCreateMutexSem (NULL, &hResultCodeSem, 0, FALSE);
       DosCreateMutexSem (NULL, &hConnectStateSem, 0, FALSE);
       DosCreateEventSem (NULL, &hevModemResponseSem, 0, FALSE);
       DosCreateEventSem (NULL, &hevModemResponseSeenSem, 0, TRUE);
   // END INITIALIZE semaphores
   //---------------------------------------------------------
   // INITIALIZE messageLoop thread
       bRunMessageLoop= TRUE;
       PFNTHREAD    pfnMessageLoop= &dummyMessageLoopThread;
//       DosCreateThread (&tidMessageLoopThread, pfnMessageLoop, (ULONG) this, CREATE_READY, 4096);
       tidMessageLoopThread= _beginthread (dummyMessageLoopThread2, NULL, 8192, this);

   // END INITIALIZE messageLoop thread
   //---------------------------------------------------------
   // INITIALIZE RxLoop thread
       bRunRxLoop= TRUE;
       PFNTHREAD    pfnRxLoop= &dummyRxLoopThread;
//       DosCreateThread (&tidRxLoopThread, pfnRxLoop, (ULONG) this, CREATE_READY, 4096);
       tidRxLoopThread= _beginthread (dummyRxLoopThread2, NULL, 8192, this);

   // END INITIALIZE RxLoop thread

      DosSetPriority (PRTYS_PROCESS, PRTYC_TIMECRITICAL, PRTYD_MAXIMUM, 0);
      operational=TRUE;
   } while (FALSE);
};

//*****************************************************
// mOpenCOM (...) member
//*****************************************************
BOOL    MODEM_ENGINE :: mOpenCOM (FLOW_CONTROL fc) {
   ULONG ulAction, ulParamLen;
   APIRET rc;
   _LINECONTROL linecontrol;
   WORD modemerror;
   BYTE modemsignals;
   _DCBINFO dcbinfo;
   USHORT       usBPS=38400;

   do {
   // OPEN COMMUNICATION PORT
      rc=DosOpen(deviceName , &hcom, &ulAction, 0, FILE_NORMAL, FILE_OPEN,
                 OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, NULL);
      if (rc) break;
   // END OPEN COMMUNICATION PORT
   //---------------------------------------------------------
   // SET LINE CONTROL
      linecontrol.bDataBits=0x08;
      linecontrol.bParity=0x00;
      linecontrol.bStopBits=0x00;

      ulParamLen=sizeof(linecontrol);
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETLINECTRL, &linecontrol, sizeof(linecontrol), &ulParamLen, NULL, 0, NULL);
      if (rc) break;
   // END SET LINE CONTROL
   //---------------------------------------------------------
   // DISABLE BREAK
      ulParamLen=sizeof(modemerror);
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETBREAKOFF, NULL, 0, NULL, &modemerror, sizeof(modemerror), &ulParamLen);
      if (rc) break;
   // END DISABLE BREAK
   //---------------------------------------------------------
   // DROP DTR
   // mDropDTR ();
   // END DROP DTR
   //---------------------------------------------------------
   // SET BAUD RATE
      ulParamLen= sizeof(usBPS);
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETBAUDRATE, (PULONG) &usBPS, sizeof(usBPS), &ulParamLen, NULL, 0, NULL);
      if (rc) {break;}

      ulParamLen = sizeof(dcbinfo);
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_GETDCBINFO, NULL, 0, NULL, &dcbinfo, sizeof(dcbinfo), &ulParamLen);
      if (rc) break;
   // END SET BAUD RATE
   //---------------------------------------------------------
   // SET DCB INFO
      dcbinfo.usReadTimeout= 99;
      dcbinfo.usWriteTimeout= 99;

      dcbinfo.fbCtlHndShake = 0;
      dcbinfo.fbFlowReplace = 0;

      switch (fc) {
      case fc_none:
         break;
      case fc_rtscts:
         dcbinfo.fbCtlHndShake += 8;
         dcbinfo.fbFlowReplace += 32+64;
         break;
      case fc_xonxoff:
         dcbinfo.fbFlowReplace += 1+2+32;
         break;
      case fc_rtscts_xonxoff:
         dcbinfo.fbCtlHndShake += 8;
         dcbinfo.fbFlowReplace += 1+2+32+64;
         break;
      } /* endswitch */


      if (dcbinfo.fbTimeout&(8+16)) dcbinfo.fbTimeout= 2+16+64+128; // 16550 or equivalent UART
      else dcbinfo.fbTimeout= 2;        // Stupid UART

      ulParamLen = sizeof(dcbinfo);
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETDCBINFO,&dcbinfo, sizeof(dcbinfo), &ulParamLen, NULL, 0, NULL);
      if (rc) break;
   // END SET DCB INFO
   //---------------------------------------------------------
    } while (FALSE);

    if (rc) {resultCode= errorOPENCOM; return FALSE;}
    else return TRUE;

// END INITIALIZE hcom
//---------------------------------------------------------
};


//*****************************************************
// ~MODEM_ENGINE(...) destructor
//*****************************************************
MODEM_ENGINE :: ~MODEM_ENGINE () {

   if (operational) {
      TID          tid;
      MESSAGE      *message = new (MESSAGE); message->message= quit;
                                             message->data = NULL;

      DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
      bRunRxLoop= FALSE;
      bRunMessageLoop= FALSE;
      DosWaitThread (&tidMessageLoopThread, DCWW_WAIT);
      DosWaitThread (&tidRxLoopThread, DCWW_WAIT);
      CHAR c= RETURN;
      ULONG cbWritten;
      DosWrite (hcom, &c, sizeof (c), &cbWritten);
      DosClose (hcom);
      free (deviceName);
      DosCloseQueue (hMessageQueue);
      DosCloseQueue (hDLEQueue);
      DosCloseMutexSem (hModemResponseSem);
      DosCloseMutexSem (hResultCodeSem);
      DosCloseMutexSem (hConnectStateSem);
      DosCloseEventSem (hevModemResponseSem);
   }
};


//*****************************************************
// mWaitForModemResponseAndDLECode () member
//*****************************************************
void    MODEM_ENGINE :: mWaitForModemResponseAndDLECode (MODEMRESPONSE &mr, CHAR &ch, BYTE tsec) {
        BYTE    i=0;
   do {
      mr= mWaitForModemResponse(1);
      if (mr.code==none) ch= mWaitForDLECode(1);
      i++;
   } while ( (i*2 < tsec) && (ch==0) && (mr.code==none) ); /* enddo */
};


//*****************************************************
// mWaitForDLECode () member
//*****************************************************
CHAR    MODEM_ENGINE :: mWaitForDLECode (BYTE tsec) {
        REQUESTDATA  request = {0};
        ULONG        DataLength, cbWritten;
        PVOID        DataAddress=NULL;
        BYTE         ElemPriority, temp[2];
        HEV          hDLESem;
        CHAR         ch=0;
        int          i=0;

        DosCreateEventSem (NULL, &hDLESem, 0, FALSE);
        if (DosReadQueue (hDLEQueue, &request, &DataLength, &DataAddress, 0L, 0, &ElemPriority, hDLESem)== ERROR_QUE_EMPTY) {
           if (DosWaitEventSem (hDLESem, tsec*100)== NO_ERROR) {
              DosReadQueue (hDLEQueue, &request, &DataLength, &DataAddress, 0L, 0, &ElemPriority, hDLESem);
              ch= * (CHAR *) DataAddress;
              delete (CHAR*) DataAddress;
           }
        } else {
           ch= * (CHAR *) DataAddress;
           delete (CHAR*) DataAddress;
        }
        DosCloseEventSem (hDLESem);
        return ch;
}


//*****************************************************
// mWaitForModemResponse ( ) member
//*****************************************************
MODEM_ENGINE::MODEMRESPONSE   MODEM_ENGINE :: mWaitForModemResponse (BYTE tsec) {
        MODEMRESPONSE   mr;
        ULONG           ulCount;
        int             i=0;

   DosWaitEventSem (hevModemResponseSem, tsec*100);
   mr= mModemResponse ();
   return mr;
};


//*****************************************************
// mModemResponse ( ) member
//*****************************************************
MODEM_ENGINE::MODEMRESPONSE   MODEM_ENGINE :: mModemResponse () {
        MODEMRESPONSE   mr;
        ULONG           ulCount;

   DosRequestMutexSem (hModemResponseSem, -1);
   mr = modemResponse;
   DosPostEventSem (hevModemResponseSeenSem);
   modemResponse.code =none;
   modemResponse.verbose[0] = 0;
   DosResetEventSem (hevModemResponseSem, &ulCount);
   DosReleaseMutexSem (hModemResponseSem);
   return mr;
};


//*****************************************************
// mResultCode ( ) member
//*****************************************************
MODEM_ENGINE::RESULTCODE      MODEM_ENGINE :: mResultCode () {
        RESULTCODE rc;

   DosRequestMutexSem (hResultCodeSem, -1);
   rc = resultCode;
// resultCode= noerror;
   DosReleaseMutexSem (hResultCodeSem);
   return rc;
};


//*****************************************************
// mDropDTR ( ) member
//*****************************************************
void    MODEM_ENGINE :: mDropDTR () {
   ULONG        ulParamLen1, ulParamLen2;
   _MODEMSTATUS modemstatus;
   WORD         modemerror;
   APIRET       rc;

   do {
      ulParamLen1= sizeof(modemstatus); ulParamLen2 = sizeof(modemerror);
      modemstatus.fbModemOff = 0xFF; modemstatus.fbModemOn= 0x01;
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETMODEMCTRL, &modemstatus, sizeof(modemstatus), &ulParamLen1, &modemerror, sizeof(modemerror), &ulParamLen2);
      if (rc) break;
      DosSleep(500);

      ulParamLen1= sizeof(modemstatus); ulParamLen2 = sizeof(modemerror);
      modemstatus.fbModemOff = 0xFE; modemstatus.fbModemOn= 0x00;
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETMODEMCTRL, &modemstatus, sizeof(modemstatus), &ulParamLen1, &modemerror, sizeof(modemerror), &ulParamLen2);
      if (rc) break;
      DosSleep(1000);

      ulParamLen1= sizeof(modemstatus); ulParamLen2 = sizeof(modemerror);
      modemstatus.fbModemOff = 0xFF; modemstatus.fbModemOn= 0x01;
      rc=DosDevIOCtl(hcom, IOCTL_ASYNC, ASYNC_SETMODEMCTRL, &modemstatus, sizeof(modemstatus), &ulParamLen1, &modemerror, sizeof(modemerror), &ulParamLen2);
      if (rc) break;
   } while (FALSE);
}

//*****************************************************
// messageLoop () member
//*****************************************************
void    MODEM_ENGINE :: messageLoop () {
   MESSAGE      message;

   while (bRunMessageLoop) {
      REQUESTDATA  request={0};
      ULONG        DataLength, cbWritten;
      PVOID        DataAddress;
      BYTE         ElemPriority, temp[2];
      CHAR         ch;
      TID          tid;

      DosReadQueue(hMessageQueue, &request, &DataLength, &DataAddress, 0L, 0, &ElemPriority, 0L);
      message = * (MESSAGE*) DataAddress;
      delete (MESSAGE*) DataAddress;

      switch (message.message) {
      case vmsetdevice:
         device = * (DEVICE*) message.data;
         mSendString (AT);
         mSendString (SETDEVICE);
         switch (device) {
         case data: ch= '0';
            break;
         case class1fax: ch= '1';
            break;
         case class2fax: ch= '2';
            break;
         case voice: ch= '8';
            break;
         } /* endswitch */
         mSendString (ch);
         mSendString (13);
         delete (DEVICE*) message.data;
         break;
      case vmsetbits:
         bitRange = * (BITRANGE*) message.data;
         mSendString (AT);
         mSendString (SETBITS);
         switch (bitRange) {
         case two: ch= '2';
            break;
         case three: ch= '3';
            break;
         case four: ch= '4';
            break;
         case eight: ch= '8';
            break;
         } /* endswitch */
         mSendString (ch);
         mSendString (13);
         delete (BITRANGE*) message.data;
         break;
      case vmsetdeadmantimer:
         deadMan= * (BYTE*) message.data;
         mSendString (AT);
         mSendString (SETDEADMANTIMER);
         ch = * (BYTE*) message.data;
         { char buf[35];
           mSendString (_itoa(ch, buf, 10));
         }
//         mSendString ((ch / 100) + 48);
//         mSendString (((ch / 10) % 10) +48);
//         mSendString ((ch % 10) +48);
         mSendString (13);
         delete (BYTE*) message.data;
         break;
      case vmsetspeed:
         vmSpeed = * (BYTE*) message.data;
         mSendString (AT);
         mSendString (SETSPEED);
         ch = * (BYTE*) message.data;
         { char buf[35];
           mSendString (_itoa(ch, buf, 10));
         }
//         mSendString ((ch / 100) + 48);
//         mSendString (((ch / 10) % 10) +48);
//         mSendString ((ch % 10) +48);
         mSendString (13);
         delete (BYTE*) message.data;
         break;
      case vmsetsilencedetection:
         silenceDetection = * (BOOL*) message.data;
         mSendString (AT);
         mSendString (SETSILENCEDETECTION);
         if (* (BOOL*) message.data) ch ='1';
         else ch = '0';
         mSendString (ch);
         mSendString (13);
         delete (BOOL*) message.data;
         break;
      case vmsetsilencedetectionvalue:
         silenceDetectionValue = * (BYTE*) message.data;
         mSendString (AT);
         mSendString (SETSILENCEDETECTIONVALUE);
         ch = * (BYTE*) message.data;
         { char buf[35];
           mSendString (_itoa(ch, buf, 10));
         }
//         mSendString ((ch / 100) + 48);
//         mSendString (((ch / 10) % 10) +48);
//         mSendString ((ch % 10) +48);
         mSendString (13);
         delete (BYTE*) message.data;
         break;
      case vmsetsilencedeletion:
         silenceDeletion = * (BOOL*) message.data;
         mSendString (AT);
         mSendString (SETSILENCEDELETION);
         if (* (BOOL*) message.data) ch= '1';
         else ch= '0';
         mSendString (ch);
         mSendString (13);
         delete (BOOL*) message.data;
         break;
      case vmsetline:
         vmLine = * (LINE*) message.data;
         mSendString (AT);
         mSendString (SETLINE);
         switch (vmLine) {
         case line: ch= '0';
            break;
         case phone: ch= '1';
            break;
         case speaker: ch= '2';
            break;
         case mic: ch= '3';
            break;
         case lineMonitor: ch= '4';
            break;
         } /* endswitch */
         mSendString (ch);
         mSendString (13);
         delete (LINE*) message.data;
         break;
      case vmbeep:
         mSendATString (BEEP);
         break;
      case vmtransmit:
         DosRequestMutexSem (hConnectStateSem, -1);
         mSendATString (TRANSMIT);
         connectState= transmit;
         DosReleaseMutexSem (hConnectStateSem);
         break;
      case vmreceive:
         DosRequestMutexSem (hConnectStateSem, -1);
         mSendATString (RECEIVE);
         connectState= receive;
         DosReleaseMutexSem (hConnectStateSem);
         break;
      case vmstoptransmit:
         mSendString (PLAYEND);
         break;
      case vmstopreceive:
         mSendString ("!stop!");
         break;
      case vmquerydevice:
         mSendATString (QUERYDEVICE);
         break;
      case vmquerymodel:
         mSendATString (QUERYMODEL);
         break;
      case vmquerymanufacturer:
         mSendATString (QUERYMANUFACTURER);
         break;
      case vmqueryrevision:
         mSendATString (QUERYREVISION);
         break;
      case vmquerycompression:
         mSendATString (QUERYCOMPRESSION);
         break;
      case vmquerydevices:
         mSendATString (QUERYDEVICES);
         break;
      case minitialize:
         mSendATString (INITIALIZE);
         break;
      case manswer:
         mSendATString (ANSWER);
         break;
      case mhangup:
         mSendATString (HANGUP);
         break;
      case quit:
         bRunMessageLoop= FALSE;
         break;
      default:
        break;
      } /* endswitch */

   } /* endwhile */

   DosExit (0,0);
};


//*****************************************************
// RxLoop () member
//*****************************************************
void    MODEM_ENGINE :: RxLoop () {
   BYTE         buf[BUFFERSIZE];
   ULONG        cbRead, cbWritten=0, cbParamPacket, cbDataPacket, ulPostCount;
   BYTE         ch, response[25], prefix[2];
   int          i;
   UCHAR        paramPacket=0;
   USHORT       dataPacket=0;

   while (bRunRxLoop) {

      switch (state) {
      case Vcon:
      case idle:
         DosWaitEventSem (hevModemResponseSeenSem, -1);
//       DosResetEventSem (hevModemResponseSeenSem, &ulPostCount);
         i=0;
         do DosRead (hcom, &ch, sizeof(ch), &cbRead); while (!cbRead && bRunRxLoop);
         if (!bRunRxLoop) DosExit (0,0);
         buf[i]= ch; i++;
         do DosRead (hcom, &ch, sizeof(ch), &cbRead); while (!cbRead && bRunRxLoop);
         if (!bRunRxLoop) DosExit (0,0);
         buf[i]= ch; i++;
         if (buf[0]==13 && buf[1]==10) {
            do {
               do DosRead (hcom, &ch, sizeof(ch), &cbRead); while (!cbRead && bRunRxLoop);
               if (!bRunRxLoop) DosExit (0,0);
               buf[i]= ch; i++;
            } while ( ch != 13 ); /* enddo */
            buf[i-1]=0;
            do DosRead (hcom, &ch, sizeof(ch), &cbRead); while (!cbRead && bRunRxLoop);
            if (!bRunRxLoop) DosExit (0,0);
            DosRequestMutexSem (hModemResponseSem, -1);
            if (!strcmp (OK,            &buf[2])) modemResponse.code= ok;
            else if (!strcmp (CONNECT,       &buf[2])) {
                    state= connected;
                    modemResponse.code= connect;
                 }
            else if (!strcmp (RING,          &buf[2])) modemResponse.code= ring;
            else if (!strcmp (NO_CARRIER,    &buf[2])) modemResponse.code= no_carrier;
            else if (!strcmp (ERROR,         &buf[2])) modemResponse.code= error;
            else if (!strcmp (NO_DIALTONE,   &buf[2])) modemResponse.code= no_dialtone;
            else if (!strcmp (BUSY,          &buf[2])) modemResponse.code= busy;
            else if (!strcmp (VCON,          &buf[2])) { modemResponse.code= vcon; state= Vcon; }
            // ... Place for new commands
            else /* Unknown answer */ modemResponse.code= unknown;
            strcpy (modemResponse.verbose, &buf[2]);
            DosResetEventSem (hevModemResponseSeenSem, &ulPostCount);
            DosReleaseMutexSem (hModemResponseSem);
            DosPostEventSem (hevModemResponseSem);

         } else {
            if ((buf[0] & 223)== 'A' && (buf[1] & 223)== 'T') {
               do {
                  do DosRead (hcom, &ch, sizeof(ch), &cbRead); while (!cbRead && bRunRxLoop);
                  if (!bRunRxLoop) DosExit (0,0);
                  buf[i]= ch; i++;
               } while ( ch != 13 ); /* enddo */
               buf[i-1]=0;
               DosRequestMutexSem (hModemResponseSem, -1);
               modemResponse.code= atCommand;
               strcpy (modemResponse.verbose, buf);
               DosResetEventSem (hevModemResponseSeenSem, &ulPostCount);
               DosReleaseMutexSem (hModemResponseSem);
               DosPostEventSem (hevModemResponseSem);

            } else {
               if (buf[0]==DLE) {
                  // In case of state==Vcon
                  BYTE  *b=new (BYTE); *b= buf[1];
                  DosWriteQueue (hDLEQueue, 0, sizeof(BYTE), b, 0);
               }

            } /* endif */
         } /* endif */
         break;

      case connected:
         do {
            BOOL        dlestate=FALSE;
            CHAR        vconstate='v';

            DosRead (hcom, &buf, sizeof (buf), &cbRead);
            for (i=0; i<cbRead ; i++ ) {
               if ( (buf[i] & 223)=='V' && vconstate=='v') vconstate= 'c';
               else if ( (buf[i] & 223)=='C' && vconstate=='c') vconstate= 'o';
               else if ( (buf[i] & 223)=='O' && vconstate=='o') vconstate= 'n';
               else if ( (buf[i] & 223)=='N' && vconstate=='n') {
                                                                  state= Vcon;
                                                                  DosRequestMutexSem (hModemResponseSem, -1);
                                                                  modemResponse.code= vcon;
                                                                  strcpy (modemResponse.verbose, VCON);
                                                                  DosReleaseMutexSem (hModemResponseSem);
                                                                  DosPostEventSem (hevModemResponseSem);
                                                                  break; }
               else { vconstate='v';
                      if ( buf[i]==DLE ) dlestate= TRUE;
                      else if ( dlestate== TRUE ) {
                              dlestate=FALSE;
                              BYTE  *b=new (BYTE); *b= buf[i];
                              DosWriteQueue (hDLEQueue, 0, sizeof(BYTE), b, 0);
                              if (buf[i]==EXT) { state= Vcon;
                                                 DosRequestMutexSem (hModemResponseSem, -1);
                                                 modemResponse.code=vcon;
                                                 strcpy (modemResponse.verbose, VCON);
                                                 DosReleaseMutexSem (hModemResponseSem);
                                                 DosPostEventSem (hevModemResponseSem);
                                                 break; }
                           }
               }
            }

            DosRequestMutexSem (hConnectStateSem, -1);
            if (connectState==receive) {
               DosReleaseMutexSem (hConnectStateSem);
               DosWrite (hfile, buf, i, &cbWritten);
            } else DosReleaseMutexSem (hConnectStateSem);

         } while ( state==connected && bRunRxLoop); /* enddo */
         cbParamPacket= sizeof (paramPacket); cbDataPacket= sizeof (dataPacket);
         DosDevIOCtl (hcom, IOCTL_GENERAL, DEV_FLUSHINPUT, &paramPacket, sizeof(paramPacket), &cbParamPacket, &dataPacket, sizeof (dataPacket), &cbDataPacket);
         break;
      default:
        break;
      } /* endswitch */

   } /* endwhile */

   DosExit (0,0);

};


//*****************************************************
// mSendString ( PCHAR ) member
//*****************************************************
void    MODEM_ENGINE :: mSendString (PCHAR p) {

        ULONG   cbWritten;
        APIRET  rc=0;

   do {
     rc=DosWrite (hcom, p, strlen(p), &cbWritten);
     if (rc) break;
     rc=DosDevIOCtl (hcom, IOCTL_ASYNC, ASYNC_STARTTRANSMIT, NULL, 0, NULL, NULL, 0, NULL);
     if (rc) break;
   } while (FALSE);
   if (rc) resultCode= errorSENDSTRING;
};


//*****************************************************
// mSendString ( CHAR ) member
//*****************************************************
void    MODEM_ENGINE :: mSendString (CHAR c) {

        ULONG   cbWritten;
        APIRET  rc=0;
        CHAR    p[1]; p[0]=c;

   do {
     rc=DosWrite (hcom, &p, 1, &cbWritten);
     if (rc) break;
     rc=DosDevIOCtl (hcom, IOCTL_ASYNC, ASYNC_STARTTRANSMIT, NULL, 0, NULL, NULL, 0, NULL);
     if (rc) break;
   } while (FALSE);
   if (rc) resultCode= errorSENDSTRING;
};


//*****************************************************
// vmSetDevice (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetDevice (DEVICE d) {
        DEVICE       *device = new (DEVICE); *device= d;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetdevice;
                                               message->data = device;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};


//*****************************************************
// vmSetBits (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetBits (BITRANGE b) {
        BITRANGE     *bitrange = new (BITRANGE); *bitrange= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetbits;
                                               message->data = bitrange;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetDeadmanTimer (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetDeadmanTimer (BYTE b) {
        BYTE         *byte = new (BYTE); *byte= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetdeadmantimer;
                                               message->data = byte;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetSpeed (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetSpeed (BYTE b) {
        BYTE         *byte = new (BYTE); *byte= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetspeed;
                                               message->data = byte;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetSilenceDetection (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetSilenceDetection (BOOL b) {
        BOOL         *bool = new (BOOL); *bool= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetsilencedetection;
                                               message->data = bool;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetSilenceDetectionValue (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetSilenceDetectionValue (BYTE b) {
        BYTE         *byte = new (BYTE); *byte= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetsilencedetectionvalue;
                                               message->data = byte;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetSilenceDeletion (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetSilenceDeletion (BOOL b) {
        BOOL         *bool = new (BOOL); *bool= b;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetsilencedeletion;
                                               message->data = bool;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmSetLine (...) member
//*****************************************************
void    MODEM_ENGINE :: vmSetLine (LINE l) {
        LINE         *_line = new (LINE); *_line= l;
        MESSAGE      *message = new (MESSAGE); message->message= vmsetline;
                                               message->data = _line;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmBeep (...) member
//*****************************************************
void    MODEM_ENGINE :: vmBeep () {
        MESSAGE      *message = new (MESSAGE); message->message= vmbeep;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmTransmit (...) member
//*****************************************************
void    MODEM_ENGINE :: vmTransmit (HFILE& hf) {
        MESSAGE      *message = new (MESSAGE); message->message= vmtransmit;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
        hf= hcom;
};

//*****************************************************
// vmReceive (CHAR) member
//*****************************************************
void    MODEM_ENGINE :: vmReceive (HFILE hf) {
        MESSAGE      *message = new (MESSAGE); message->message= vmreceive;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
        hfile= hf;
};

//*****************************************************
// vmStopTransmit (...) member
//*****************************************************
void    MODEM_ENGINE :: vmStopTransmit () {
        MESSAGE      *message = new (MESSAGE); message->message= vmstoptransmit;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmStopreceive (...) member
//*****************************************************
void    MODEM_ENGINE :: vmStopReceive () {
        MESSAGE      *message = new (MESSAGE); message->message= vmstopreceive;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryDevice (...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryDevice () {
        MESSAGE      *message = new (MESSAGE); message->message= vmquerydevice;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryModel (...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryModel () {
        MESSAGE      *message = new (MESSAGE); message->message= vmquerymodel;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryManufacturer(...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryManufacturer () {
        MESSAGE      *message = new (MESSAGE); message->message= vmquerymanufacturer;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryRevision (...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryRevision () {
        MESSAGE      *message = new (MESSAGE); message->message= vmqueryrevision;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryCompression (...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryCompression() {
        MESSAGE      *message = new (MESSAGE); message->message= vmquerycompression;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// vmQueryDevices (...) member
//*****************************************************
void    MODEM_ENGINE :: vmQueryDevices () {
        MESSAGE      *message = new (MESSAGE); message->message= vmquerydevices;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};

//*****************************************************
// mInitialize (...) member
//*****************************************************
void    MODEM_ENGINE :: mInitialize () {
        MESSAGE      *message = new (MESSAGE); message->message= minitialize;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};


//*****************************************************
// mHangup (...) member
//*****************************************************
void    MODEM_ENGINE :: mHangup () {
        MESSAGE      *message = new (MESSAGE); message->message= mhangup;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};


//*****************************************************
// mAnswer (...) member
//*****************************************************
void    MODEM_ENGINE :: mAnswer () {
        MESSAGE      *message = new (MESSAGE); message->message= manswer;
                                               message->data = NULL;
        DosWriteQueue (hMessageQueue, 0, sizeof (MESSAGE), message, 0);
};


//*****************************************************
// dummyMessageLoopThread (...)
//*****************************************************
void _System dummyMessageLoopThread (ULONG modem_engine) {

        ( (MODEM_ENGINE *) modem_engine ) ->messageLoop();
        DosExit (0, 0);

};


//*****************************************************
// dummyRxLoopThread (...)
//*****************************************************
void _System dummyRxLoopThread (ULONG modem_engine) {

        ( (MODEM_ENGINE *) modem_engine ) ->RxLoop();
        DosExit (0, 0);

};

//*****************************************************
// dummyMessageLoopThread2 (...)
//*****************************************************
void _Optlink dummyMessageLoopThread2 (void * modem_engine) {

        ( (MODEM_ENGINE *) modem_engine ) ->messageLoop();
};


//*****************************************************
// dummyRxLoopThread2 (...)
//*****************************************************
void _Optlink dummyRxLoopThread2 (void * modem_engine) {

        ( (MODEM_ENGINE *) modem_engine ) ->RxLoop();
};


