#define INCL_WINSHELLDATA
#include <ibase.hpp>
#include <iapp.hpp>
#include <ifont.hpp>
#include <icolor.hpp>
#include <icombobx.hpp>
#include <ilistbox.hpp>
#include <ispintxt.hpp>
#include <ipushbut.hpp>
#include <icheckbx.hpp>
#include <iprofile.hpp>
#include <imsgbox.hpp>
#include <ithread.hpp>
#include <isysmenu.hpp>
#include <fstream.h>
#include <ifiledlg.hpp>
#include <stdio.h>
#include "notebook.hpp"
#include "notebook.h"
#include "\work\modemengine\modemengine.hpp"
#include <os2.h>

int main()
{
   IFrameWindow::setDefaultStyle((IFrameWindow::defaultStyle() & ~IFrameWindow::sizingBorder & ~IFrameWindow::maximizeButton) | IFrameWindow::border);
   GeneralSettings mainWindow(WND_MAIN);
   mainWindow.show();
   IApplication::current().run();
   return 0;
}

//**************************************************************************
GeneralSettings :: GeneralSettings(unsigned long windowId)
        :IFrameWindow(windowId)
        ,reslib()
        ,notebook(WND_NB, this, this, IRectangle()
                        , INotebook::defaultStyle()
                        | INotebook::solidBinding
                  )
        ,wnd_tab1(WND_TAB1, &notebook, &notebook, dialogResource)
        ,comPort(DID_COMPORT, &wnd_tab1)
        ,testOutput(DID_TESTOUTPUT, &wnd_tab1)
        ,testbtn(DID_TESTBTN, &wnd_tab1)
        ,wnd_tab2(WND_TAB2, &notebook, &notebook, dialogResource)
        ,rings(DID_RINGS, &wnd_tab2)
        ,quality(DID_QUALITY, &wnd_tab2)
        ,silenceVal(DID_SILENCEVAL, &wnd_tab2)
        ,silenceDel(DID_ENABLESILENCEDEL, &wnd_tab2)
        ,silenceDet(DID_ENABLESILENCEDET, &wnd_tab2)
        ,monitor(DID_MONITOR, &wnd_tab2)
        ,wnd_tab3(WND_TAB3, &notebook, &notebook, dialogResource)
        ,startOn(DID_STARTON, &wnd_tab3)
        ,startMin(DID_STARTMIN, &wnd_tab3)
        ,singleMbx(DID_SINGLEMBX, &wnd_tab3)
        ,multipleMbx(DID_MULTIPLEMBX, &wnd_tab3)
        ,powerOff(DID_POWEROFF, &wnd_tab3)
        ,powerOn(DID_POWERON, &wnd_tab3)
        ,statOutput(DID_STATOUTPUT, &wnd_tab3)
        ,wnd_tab4(WND_TAB4, &notebook, &notebook, dialogResource)
        ,greeting(DID_GREETING, &wnd_tab4)
        ,messages(DID_MESSAGES, &wnd_tab4)
{

  INotebook::PageSettings majorTab(INotebook::PageSettings::majorTab|
                                   INotebook::PageSettings::statusTextOn |
                                   INotebook::PageSettings::autoPageSize);

  notebook.setMajorTabSize(ISize(75,20));
  notebook.setMajorTabBackgroundColor(IColor::paleGray);

  comPort.addAsLast("COM1");
  comPort.addAsLast("COM2");
  comPort.addAsLast("COM3");
  comPort.addAsLast("COM4");

  majorTab.setTabText(TAB_1);
  majorTab.setStatusText(TAB_1_STAT);
  tab1= notebook.addLastPage(majorTab, &wnd_tab1);

  rings.addAsLast("1");
  rings.addAsLast("2");
  rings.addAsLast("3");
  rings.addAsLast("4");
  rings.addAsLast("5");
  rings.addAsLast("6");

  quality.addAsLast("2");
  quality.addAsLast("3");
  quality.addAsLast("4");

  silenceVal.addAsLast("5");
  silenceVal.addAsLast("10");

  majorTab.setTabText(TAB_2);
  majorTab.setStatusText(TAB_2_STAT);
  tab2= notebook.addLastPage(majorTab, &wnd_tab2);

  majorTab.setTabText(TAB_3);
  majorTab.setStatusText(TAB_3_STAT);
  tab3= notebook.addLastPage(majorTab, &wnd_tab3);


  majorTab.setTabText(TAB_4);
  majorTab.setStatusText(TAB_4_STAT);
  tab4= notebook.addLastPage(majorTab, &wnd_tab4);

  greeting.setLimit(1024);

  setFont(IFont("Helv", 8));
  setIcon(WND_MAIN);
  sizeTo(ISize(450, 375));
  setClient(&notebook);

  ICommandHandler :: handleEventsFor(this);
  ICommandHandler :: handleEventsFor(&wnd_tab1);
  ICommandHandler :: handleEventsFor(&wnd_tab2);
  ICommandHandler :: handleEventsFor(&wnd_tab3);
  ICommandHandler :: handleEventsFor(&wnd_tab4);

  ISelectHandler :: handleEventsFor(this);
  ISelectHandler :: handleEventsFor(&wnd_tab1);
  ISelectHandler :: handleEventsFor(&wnd_tab2);
  ISelectHandler :: handleEventsFor(&wnd_tab3);
  ISelectHandler :: handleEventsFor(&wnd_tab4);

  power= off;

  loadSettings();

}

//**************************************************************************
GeneralSettings :: ~GeneralSettings() {

  ICommandHandler :: stopHandlingEventsFor(this);
  ICommandHandler :: stopHandlingEventsFor(&wnd_tab1);
  ICommandHandler :: stopHandlingEventsFor(&wnd_tab2);
  ICommandHandler :: stopHandlingEventsFor(&wnd_tab3);
  ICommandHandler :: stopHandlingEventsFor(&wnd_tab4);

  ISelectHandler :: stopHandlingEventsFor(this);
  ISelectHandler :: stopHandlingEventsFor(&wnd_tab1);
  ISelectHandler :: stopHandlingEventsFor(&wnd_tab2);
  ISelectHandler :: stopHandlingEventsFor(&wnd_tab3);
  ISelectHandler :: stopHandlingEventsFor(&wnd_tab4);

}



//**************************************************************************
Boolean GeneralSettings :: command (ICommandEvent &cmdEvent) {

  switch (cmdEvent.commandId()) {
  case DID_CLEARBTN:
     testOutput.removeAll();
     break;

  case DID_SAVEBTN:
     saveTest(testOutput);
     return true;
     break;

  case DID_SAVESTAT:
     saveTest(statOutput);
     return true;
     break;

  case DID_CLEARSTAT:
     statOutput.removeAll();
     break;

  case DID_TESTBTN:
     modemTest();
     return true;
     break;

  case DID_SELECTGREETING:
     selectGreeting();
     return true;
     break;

  default:
    break;
  } /* endswitch */
  return false;
}


//**************************************************************************
Boolean GeneralSettings :: systemCommand (ICommandEvent &cmdEvent) {

  if (cmdEvent.commandId()==ISystemMenu::idClose) saveSettings();
  return false;
}

//**************************************************************************
Boolean GeneralSettings :: selected(IControlEvent &event) {

  switch (event.controlId()) {

  case DID_POWERON:
     if (power == off) {
       modemAnswer();
       power=on;
     }
     return true;
     break;

  case DID_POWEROFF:
     if (power == on) {
       powerOff.disable();
       powerOn.disable();
       power=off;
     }
     return true;
     break;

  default:
    break;
  } /* endswitch */
  return false;
}

//**************************************************************************
void GeneralSettings :: loadSettings () {

  IProfile general("answer.ini");
  general.setDefaultApplicationName("general");

  if (general.containsKeyName("comPort")) comPort.setText(general.elementWithKey("comPort"));
  else comPort.setText("COM1");

  if (general.containsKeyName("quality")) quality.setText(general.elementWithKey("quality"));
  else quality.setText("4");
  if (general.containsKeyName("silenceVal")) silenceVal.setText(general.elementWithKey("silenceVal"));
  else silenceVal.setText("5");
  if (general.containsKeyName("rings")) rings.setText(general.elementWithKey("rings"));
  else rings.setText("4");
  if (general.containsKeyName("silenceDel")) {
     if (general.elementWithKey("silenceDel")!="0") silenceDel.select();
  }
  if (general.containsKeyName("silenceDet")) {
     if (general.elementWithKey("silenceDet")!="0") silenceDet.select();
  }
  if (general.containsKeyName("monitor")) {
     if (general.elementWithKey("monitor")!="0") monitor.select();
  }

  if (general.containsKeyName("startMin")) {
     if (general.elementWithKey("startMin")!="0") startMin.select();
  }

  if (general.containsKeyName("startOn")) {
     if (general.elementWithKey("startOn")!="0") startOn.select();
  }

  if (general.containsKeyName("singleMbx")) {
     if (general.elementWithKey("singleMbx")!="0") singleMbx.select();
     else multipleMbx.select();
  } else singleMbx.select();

  if (general.containsKeyName("greeting"))
     greeting.setText(general.elementWithKey("greeting"));

  powerOff.select();
}


//**************************************************************************
void GeneralSettings :: saveSettings () {

  IProfile general("answer.ini");
  general.setDefaultApplicationName("general");
  general.addOrReplaceElementWithKey("comPort", comPort.text());

  general.addOrReplaceElementWithKey("quality", quality.text());
  general.addOrReplaceElementWithKey("silenceVal", silenceVal.text());
  general.addOrReplaceElementWithKey("rings", rings.text());
  general.addOrReplaceElementWithKey("silenceDet", silenceDet.isSelected() ? "1" : "0");
  general.addOrReplaceElementWithKey("silenceDel", silenceDel.isSelected() ? "1" : "0");
  general.addOrReplaceElementWithKey("monitor", monitor.isSelected() ? "1" : "0");

  general.addOrReplaceElementWithKey("startMin", startMin.isSelected() ? "1" : "0");
  general.addOrReplaceElementWithKey("startOn", startOn.isSelected() ? "1" : "0");
  general.addOrReplaceElementWithKey("singleMbx", singleMbx.isSelected() ? "1" : "0");

  general.addOrReplaceElementWithKey("greeting", greeting.text());

}


//**************************************************************************
void GeneralSettings :: saveTest(IListBox &listbox) {

   IFileDialog::Settings settings;
   settings.setSaveAsDialog();
   IFileDialog fileDialog(0, this, settings);
   if (fileDialog.pressedOK()) {
      ofstream fout(fileDialog.fileName());
      if (!fout.good()) {
         IMessageBox msgbox(this);
         msgbox.show(MSG_ERR_FILEOPEN, IMessageBox::okButton | IMessageBox::errorIcon);
         return;
      }
      for (int i=0; i< listbox.count() ; i++ )
         fout << listbox.itemText(i) << endl;
      fout.close();
   }
}


//**************************************************************************
void GeneralSettings :: selectGreeting() {

   IFileDialog::Settings settings;
   settings.setOpenDialog();
   settings.setFileName("*.msg");
   IFileDialog fileDialog(0, this, settings);
   if (fileDialog.pressedOK()) {
      greeting.setText(fileDialog.fileName());
   }
}

//**************************************************************************
void GeneralSettings :: modemTest () {

  testbtn.disable();
  testThread.start(new IThreadMemberFn<GeneralSettings>(*this, GeneralSettings::modemTestThread));
}

//**************************************************************************
void GeneralSettings :: modemTestThread () {

  Boolean  testPassed=false;
  IString  reason;
  MODEM_ENGINE::MODEMRESPONSE mr;
  IMessageBox msgbox(this);

  testOutput.addAsLast(MSG_MODEMTESTSTART);

  do {
    if (IMessageBox::cancel == msgbox.show(MSG_PREMODEMTEST, IMessageBox::okCancelButton | IMessageBox::queryIcon)) {
       reason= reslib.loadString(MSG_ERR_TESTABORT);
       break;
    }
    // Let the test begin

    MODEM_ENGINE me((char*)comPort.text(), MODEM_ENGINE::fc_rtscts_xonxoff, 6127181);
    IString   sentToModem(reslib.loadString(MSG_SENTTOMODEM));

    if (me.mResultCode () != MODEM_ENGINE::noerror) {
       reason= reslib.loadString(MSG_ERR_COMOPEN);
       break;
    }
    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTINIT));
    me.mInitialize();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQDEV));
    me.vmQueryDevice();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQMOD));
    me.vmQueryModel();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQMAN));
    me.vmQueryManufacturer ();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQREV));
    me.vmQueryRevision ();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTSDEV));
    me.vmSetDevice ();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQCOMP));
    me.vmQueryCompression ();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTQDEV2));
    me.vmQueryDevices ();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTINIT));
    me.mInitialize();
    mr= modemResponse(me, &testOutput);
    if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

    testPassed= true;
  } while ( false ); /* enddo */

  if (testPassed) {
     reason= reslib.loadString(MSG_TESTPASSED);
     msgbox.show(reason, IMessageBox::okButton | IMessageBox::informationIcon);
  } else {
     if (reason== "") {
       switch (mr.code) {
       case MODEM_ENGINE::error:
          reason= reslib.loadString(MSG_ERR_GOTERROR);
          break;
       case MODEM_ENGINE::none:
          reason= reslib.loadString(MSG_ERR_GOTNOTHING);
          break;
       } /* endswitch */
     }
     msgbox.show(reason, IMessageBox::okButton | IMessageBox::errorIcon);
  } /* endif */

  testOutput.addAsLast(reason);
  testOutput.addAsLast(MSG_MODEMTESTEND);
  testOutput.setTop(testOutput.count());

  testbtn.enable();
}

//**************************************************************************
void GeneralSettings :: modemAnswer() {


  answerThread.start(new IThreadMemberFn<GeneralSettings>(*this, GeneralSettings::modemAnswerThread));
}

//**************************************************************************
void GeneralSettings :: modemAnswerThread () {

#define __CHECK__ if (power == off) break;
#define __ERROR__ if (MODEM_ENGINE::none == mr.code || MODEM_ENGINE::error == mr.code) break;

  statOutput.addAsLast(MSG_MODEMANSWERSTART);
  statOutput.setTop(statOutput.count());


  do {
    ifstream greetingFile((char*)greeting.text(), ios::bin);
    MODEM_ENGINE::MODEMRESPONSE mr;
    MODEM_ENGINE me((char*)comPort.text(), MODEM_ENGINE::fc_rtscts_xonxoff, 6127181);
    IString   sentToModem(reslib.loadString(MSG_SENTTOMODEM)), reason("");

    if (!greetingFile.good()) {
       reason= reslib.loadString(MSG_ERR_NOGREETING);
       break;
    }

    if (me.mResultCode() != MODEM_ENGINE::noerror) {
      break;
    }

    while (true) {
      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMTESTINIT));

      me.mInitialize();
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __CHECK__
      __ERROR__
      statOutput.addAsLast(MSG_WAITINGFORCALL);
      statOutput.setTop(statOutput.count());

      mr= modemResponse(me, NULL, 10);
      __CHECK__
      while (mr.code != MODEM_ENGINE::ring) {
         __CHECK__
         mr= modemResponse(me, NULL, 10);
      } /* endwhile */
      __CHECK__

      // RING! Answer the damn thing!

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETDEV));
      me.vmSetDevice(MODEM_ENGINE::voice);
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETSPEED));
      me.vmSetSpeed();
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETSILENCEDET));
      me.vmSetSilenceDetection(silenceDet.isSelected());
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETSILENCEDEL));
      me.vmSetSilenceDeletion(silenceDel.isSelected());
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      me.vmSetDeadmanTimer();
      __CHECK__
      mr= modemResponse(me, NULL);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETSILENCEVAL));
      me.vmSetSilenceDetectionValue((BYTE) silenceVal.text().asInt());
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETQUALITY));
      switch (quality.text().asInt()) {
        case 2:
        me.vmSetBits(MODEM_ENGINE::two);
        break;
        case 3:
        me.vmSetBits(MODEM_ENGINE::three);
        break;
        case 4:
        me.vmSetBits(MODEM_ENGINE::four);
        break;
      } // endswitch
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSETLINE));
      if (monitor.isSelected()) {
        me.vmSetLine(MODEM_ENGINE::lineMonitor);
      } else {
        me.vmSetLine(MODEM_ENGINE::line);
      }
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMANSWER));
      me.mAnswer();
      __CHECK__
      mr= modemResponse(me, &statOutput, 10);
      __ERROR__
      if (MODEM_ENGINE::connect == mr.code) break;

      { HFILE com_port;
        unsigned char buf[1024];
        ULONG cbWritten=0;

        statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMPLAYGREETING));
        me.vmTransmit(com_port);
        __CHECK__
        mr= modemResponse (me, &statOutput);
        __ERROR__
        __CHECK__

        while (!greetingFile.eof()) {

           greetingFile.read(buf, sizeof(buf));
           DosWrite(com_port, &buf, greetingFile.gcount(), &cbWritten);
           __CHECK__
        }
      __CHECK__

      }
      __CHECK__


      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMGREETINGEND));
      me.vmStopTransmit();
      __CHECK__
      mr= modemResponse (me, NULL, 50);
      __CHECK__

      while (mr.code==MODEM_ENGINE::none) {
         me.vmStopTransmit();
         __CHECK__
         mr= modemResponse (me, NULL, 50);
         __CHECK__
      }
      __CHECK__

      statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMBEEP));
      me.vmBeep();
      __CHECK__
      mr= modemResponse(me, &statOutput);
      __ERROR__
      __CHECK__

      { FILE * message;
        char c;

        // GET A GOOD NAME FOR THE MESSAGE
        message= fopen ("test.msg", "wb");

        statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMRECMSG));
        me.vmReceive(fileno(message));
        __CHECK__
        mr= modemResponse(me, &statOutput);
        __ERROR__
        __CHECK__

        c=me.mWaitForDLECode();
        __CHECK__

        while (c != 'q' && c != 'b' && c !='a' && c !='c' && c !='d' && c !='e' && c !='f' && c !='s') {

           c=me.mWaitForDLECode();
           __CHECK__

        } /* endwhile */
        __CHECK__

        statOutput.addAsLast(sentToModem + reslib.loadString(MSG_MODEMSTOPRECMSG));
        me.vmStopReceive();
        __CHECK__
        mr= modemResponse (me, NULL, 50);
        __CHECK__

        while (mr.code==MODEM_ENGINE::none) {
           me.vmStopReceive();
           __CHECK__
           mr= modemResponse (me, NULL, 50);
           __CHECK__
        } /* endwhile */
        __CHECK__

        fclose(message);
      }


    } // End While (TRUE)



  } while (false);

  if (power == on) powerOff.click();

  statOutput.addAsLast(MSG_MODEMANSWEREND);
  statOutput.setTop(statOutput.count());

  powerOn.enable();
  powerOff.enable();

#undef __CHECK__
#undef __ERROR__
}

//**************************************************************************
MODEM_ENGINE::MODEMRESPONSE GeneralSettings :: modemResponse (MODEM_ENGINE & me, IListBox * lb, int timeout) {

 MODEM_ENGINE::MODEMRESPONSE mr;

    do {
       mr= me.mWaitForModemResponse (timeout);
       if (mr.verbose[0]== 0) {
          mr.code= MODEM_ENGINE::none;
       } else {
          if (mr.code != MODEM_ENGINE::atCommand && lb != NULL) {
             lb->addAsLast(reslib.loadString(MSG_GOTFROMMODEM) + IString(mr.verbose));
             lb->setTop(lb->count());
          }
       }
    } while ((mr.code != MODEM_ENGINE::ok) &&
             (mr.code != MODEM_ENGINE::error) &&
             (mr.code != MODEM_ENGINE::connect) &&
             (mr.code != MODEM_ENGINE::none) &&
             (mr.code != MODEM_ENGINE::vcon) &&
             (mr.code != MODEM_ENGINE::no_carrier) &&
             (mr.code != MODEM_ENGINE::ring));

   return mr;
}


