/* C routine which calls a fortran function */

#define INCL_REXXSAA
#include <rexxsaa.h>
#include <stdlib.h>

/* definitions for calling fortran from c with g77 */
#include <g2c.h>

/* fortranfunction takes three arguments, which are all strings. The return
 * value is also a string, and it gets put first */
E_f ffunc_(real *a1, integer * atl, char * a2, real *a3, int a2l);

/* this function ensures there are sufficient arguments to satisfy the
 * underlying fortran function, converts the string arguments to reals,
 * then calls the fortran function. GNU fortran (and f2c) translates a
 * string argument into a pointer and a length (with the lengths going
 * at the end of the argument list) */

APIRET APIENTRY cfunc(PCSZ name, ULONG argc, PRXSTRING argv, PCSZ queuename,
                      PRXSTRING returnstring)
{
   real a1, a3, res;
   integer atl;

   if (argc < 3) return 40;

   /* convert character arguments to floating point in C */
   a1 = atof(argv[0].strptr);
   a3 = atof(argv[2].strptr);
   atl = argv[1].strlength;
   
   res = ffunc_(&a1, &atl, argv[1].strptr, &a3, argv[1].strlength);
   returnstring->strlength = sprintf(returnstring->strptr, "%f", res);

   return 0;
}

