/* list1104.cmd */

SAY "Enter the month and year:"
PULL month year

day = 1
dow = Zeller() + 1

/* space over days before first of month */
week = ''
DO dow - 1
  week = week || '   '
END

/* get number of days for month (ignores leap years) */
SELECT
WHEN month = 2 THEN
  mthLen = 28
WHEN month = 4 | month = 6 | month = 9 | month = 11 THEN
  mthLen = 30
OTHERWISE
  mthLen = 31
END

/* display the heading */
SAY
SAY Center(month || '/' || year, 21)
SAY '  S  M  T  W  T  F  S'

/* build each week and display it */
DO wk = 1 TO 6 UNTIL day > mthLen
  DO dow = dow TO 7 UNTIL day > mthLen
    week = week Format(day, 2)
    day = day + 1
  END
  dow = 1
  SAY week
  week = ''
END

EXIT

/* Zeller's Congruence */
Zeller:
  IF month > 2 THEN
    DO
    adjMonth = month - 2
    adjYear = year
    END
  ELSE
    DO
    adjMonth = month + 10
    adjYear = year - 1
    END

  century = adjYear % 100
  yearInCentury = adjYear - 100 * century
  dayOfWeek = ((13 * adjMonth - 1) % 5 + day + yearInCentury + ,
	yearInCentury % 4 + century % 4 - century - century + 77) ,
	// 7
  RETURN dayOfWeek

