/* list1502.cmd */

CALL SetLocal
config = 'C:\config.sys'
newcfg = 'C:\config.new'

IF Lines(newcfg) > 0 THEN
  DO
  CALL LineOut(newcfg) /* close the file */
  '@del' newcfg '> NUL'
  END

DO WHILE Lines(config) >< 0
  line = LineIn(config)
  line = Strip(line, 'B')
  SELECT
    WHEN Left(line, 9) = 'SET PATH=' THEN
      DO
      SAY 'Cleaning PATH...'
      PARSE VAR line . '=' thePath
      line = 'SET PATH=' || CleanPath(thePath)
      END
    WHEN Left(line, 8) = 'LIBPATH=' THEN
      DO
      SAY 'Cleaning LIBPATH...'
      PARSE VAR line . '=' thePath
      line = 'LIBPATH=' || CleanPath(thePath)
      END
    WHEN Left(line, 10) = 'SET DPATH=' THEN
      DO
      SAY 'Cleaning DPATH...'
      PARSE VAR line . '=' thePath
      line = 'SET DPATH=' || CleanPath(thePath)
      END
    OTHERWISE
      NOP
  END
  CALL LineOut newcfg, line
END


SAY 'All changes written to' newcfg
CALL EndLocal
EXIT

CleanPath: PROCEDURE
  thePath = Arg(1)
  newPath = ''
  IF Left(thePath, 1) = ';' THEN
    thePath = SubStr(thePath, 2)
  DO WHILE thePath >< ''
    PARSE VAR thePath aDir ';' thePath
    SELECT
      WHEN aDir = '' THEN /* handle double semicolons */
	ITERATE
      WHEN aDir = '.' THEN
	newPath = '.;' || newPath
      WHEN Directory(aDir) >< aDir THEN
	SAY '  Removing "' || aDir || '" (dir not found)'
      OTHERWISE
	newPath = newPath || aDir || ';'
    END
  END
  RETURN newPath
