/* list1508.cmd */

PARSE ARG filename printer
IF printer = '' THEN
  printer = 'PRN:'
IF filename = '' THEN
  DO
  SAY 'Usage:'
  SAY '  list1508 filename [printer-port]'
  EXIT
  END

pointsPerInch = 72
margins      = Trunc(pointsPerInch * 0.5)
pageLength   = 11 * pointsPerInch /* 8.5 x 11 inch paper */
linesPerPage = 66
lineHeight   = (pageLength - margins * 2) / linesPerPage
lineHeight   = Trunc(lineHeight)

CALL LineOut printer, '% Generated by list1508.cmd'
CALL LineOut printer, '/fnt /Courier findfont' lineHeight ,
    'scalefont def'
CALL LineOut printer, 'fnt setfont gsave'

lineLoc = pageLength - margins
DO i = 1 WHILE Lines(filename)
  IF i > linesPerPage THEN
    DO
    CALL LineOut printer, 'showpage grestore gsave'
    i = 1
    lineLoc = pageLength - margins
    END
  text = LineIn(filename)
  IF text >< '' THEN
    DO
    ix = Verify(text, '\()', 'M')
    DO WHILE ix >< 0
      text = Insert('\', text, ix - 1)
      ix = Verify(text, '\()', 'M', ix + 2)
    END
    CALL LineOut printer, margins lineLoc 'moveto (' || ,
	text || ') show'
    END
  lineLoc = lineLoc - lineHeight
END

CALL LineOut printer, 'showpage grestore'
CALL CharOut printer, D2C(4)  /* ^D (end of job) */
CALL Stream printer, 'C', 'Close'

EXIT
