/* list1705.cmd */
IF LoadRexxUtil() THEN
  EXIT

PARSE ARG commandLine
IF commandLine = '' THEN
  DO
  SAY 'File name was expected.'
  EXIT
  END

/* extended attribute types */
eat. = ''
eat.ascii    = 'FFFD'x
eat.asn1     = 'FFDD'x
eat.binary   = 'FFFE'x
eat.bitmap   = 'FFFB'x
eat.ea	     = 'FFEE'x
eat.icon     = 'FFF9'x
eat.metafile = 'FFFA'x
eat.mvmt     = 'FFDF'x
eat.mvst     = 'FFDE'x

/* standard EA's */
eaNames.0 = 8
eaNames.1 = '.SUBJECT'
eaNames.2 = '.COMMENTS'
eaNames.3 = '.TYPE'
eaNames.4 = '.LONGNAME'
eaNames.5 = '.HISTORY'
eaNames.6 = '.KEYPHRASES'
eaNames.7 = '.VERSION'
eaNames.8 = '.CLASSINFO'

DO j = 1 TO eaNames.0
  IF GetAndFormatEA(commandLine, eaNames.j) THEN
    DO
    SAY eaNames.j':'
    DO i = 1 TO ea.0
      IF ea.i.type = 'BINARY' THEN
	DO
	SAY '  BINARY:  length =' Length(ea.i.data)
	hex = C2X(ea.i.data)
	junk = Translate(ea.i.data, Copies('.', 256), XRange('7F'x, '1F'x))
	loc = 0
	DO WHILE hex >< ''
	  addr = D2X(loc, 4)
	  out = Translate('abcdefgh ijklmnop qrstuvwx ABCDEFGH',,
	      Left(hex, 32), 'abcdefghijklmnopqrstuvwxABCDEFGH')
	  SAY '    'addr':  'out'  'Left(junk, 16)
	  hex = SubStr(hex, 33)
	  junk = SubStr(junk, 17)
	  loc = loc + 16
	END
	END
      ELSE
	SAY '  'ea.i.type':' ea.i.data
    END
    END
END

EXIT

/* Get an EA and parse it. */
GetAndFormatEA: PROCEDURE EXPOSE eat. ea.
  fileName = Arg(1)
  eaName = Arg(2)
  ea.0 = 0
  IF SysGetEA(fileName, eaName, stuff) = 0 ,
  & stuff >< '' THEN
    DO
    CALL FormatEA stuff, 1
    RETURN 1
    END
  RETURN 0

/* Recursive function to parse EAs. */
FormatEA: PROCEDURE EXPOSE eat. ea.
  stuff = Arg(1)
  count = Arg(2)
  PARSE VAR stuff eat 3 .
  eat = Reverse(eat)
  SELECT
    WHEN eat == eat.ascii THEN
      DO
      ea.0 = count
      PARSE VAR stuff 3 leng 5
      leng = C2D(Reverse(leng))
      PARSE VAR stuff 5 ea.count.data +(leng) stuff
      ea.count.type = 'ASCII'
      END
    WHEN eat == eat.icon THEN
      DO
      ea.0 = count
      PARSE VAR stuff 3 leng 5
      leng = C2D(Reverse(leng))
      PARSE VAR stuff 5 ea.count.data +(leng) stuff
      ea.count.type = 'ICON'
      END
    WHEN eat == eat.mvmt THEN
      DO
      PARSE VAR stuff 5 leng 7 stuff
      leng = C2D(Reverse(leng))
      DO i = 0 TO (leng - 1)
	stuff = FormatEA(stuff, count + i)
      END
      END
    WHEN eat == eat.mvst THEN
      DO
      PARSE VAR stuff 5 leng 7 stuff
      leng = C2D(Reverse(leng))
      DO i = 0 TO (leng - 1)
	stuff = FormatEA(stuff, count + i)
	stuff = Reverse(eat.ascii) || stuff
      END
      END
    WHEN eat == eat.binary THEN
      DO
      ea.0 = count
      PARSE VAR stuff 3 leng 5
      leng = C2D(Reverse(leng))
      PARSE VAR stuff 5 ea.count.data +(leng) stuff
      ea.count.type = 'BINARY'
      END
    OTHERWISE
      ea.0 = count
      ea.count.type = '???'
      ea.count.data = 'Unknown EA type' C2X(eat)
  END
  RETURN stuff
