#ifndef _HELP_H_
#define _HELP_H_

#include <pm/StdApp.h>

#ifndef _ARCHIVING_H_
#include <pm/Archiving.h>
#endif

#define DEFAULT_HELPTABLE 1000

@interface Help : Object <Archiving>
{
  BOOL helpEnabled;
  HWND helpInstance;

  id    helpFileName;
  id    helpWindowTitle;
  ULONG helpTable;
  HAB   hab;
}

- init;
- initForApp: (StdApp *) anApp helpFile: (char *) fileName;
- initForApp: (StdApp *) anApp helpFile: (char *) fileName
   withTitle: (char *) helpTitle;
- initForApp: (StdApp *) anApp helpFile: (char *) fileName
   withTitle: (char *) helpTitle helpTable: (ULONG) helpTableID;

- free;

- associateWith: aWindow;

- createHelpInstance;

- helpForHelp: sender;
- helpExtended: sender;
- helpIndex: sender;
- helpFor: sender;
- helpForTopic: (int) topic;

/* ---------------------- Instance Variables ---------------------- */
-helpFileName;
-helpWindowTitle;
-(ULONG) helpTable;
-setHelpTable: (ULONG) anId;

/* -------------------------- Archiving --------------------------- */
-awake;
-initializeObjectWithHab: (HAB) aHab;
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end

#endif
