/************************************************************************/
/***                                                                  ***/
/*** AUTHOR :            RH                                           ***/
/***                                                                  ***/
/*** SHORT DESCRIPTION : test PM tracin                               ***/
/***                                                                  ***/
/*** COPYRIGHT :         (C) 1995 a priori Computer Solutions GmbH    ***/
/***                                                                  ***/
/************************************************************************/

#ifdef __IBMC__
#pragma strings(readonly)
#endif

/*----------------------------------------------------------------------*/
/* includes                                                             */
/*----------------------------------------------------------------------*/

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <setjmp.h>
#ifndef __IBMC__
#include <process.h>
#endif

/*--------------------------------------*/
/* Define trace levels                  */
/*--------------------------------------*/
#define   DATT_BASE_LEVEL   2000
#define   DATT_TM_LEVEL     2001
#define   TM_I              DATT_BASE_LEVEL + 1   /* Info */
#define   TM_E              DATT_BASE_LEVEL + 2   /* error */
#define   TM_H              DATT_BASE_LEVEL + 3   /* hex dump */

/*--------------------------------------*/
/* include the C-Scout definitions here */
/*--------------------------------------*/
#include "datt.h"

#include "mtestpm.h"
#include "resid.h"

/*----------------------------------------------------------------------*/
/* defines                                                              */
/*----------------------------------------------------------------------*/

#define TITLE "mtestpm"
#define DESC "test PM tracing"

#define TEST_DLG_TITLE "Test Dialog"
#define TEST_DLG_PROMPT "Prompt"

/*----------------------------------------------------------------------*/
/* macros                                                               */
/*----------------------------------------------------------------------*/

// sets the text contents h = hwnd, i = id, s = string of text
#define SetText( h, i, s ) \
        WinSetWindowText(WinWindowFromID( h , i ), s )

/*----------------------------------------------------------------------*/
/* declarations                                                         */
/*----------------------------------------------------------------------*/

int main (int argc, char * argv [] );

static MRESULT EXPENTRY wpClient ( HWND hwndClient,
                                   ULONG msg,
                                   MPARAM mp1,
                                   MPARAM mp2 );

static MRESULT EXPENTRY dlgpTest ( HWND    dialog,
                                   ULONG   msg,
                                   MPARAM  mp1,
                                   MPARAM  mp2 );

static MRESULT EXPENTRY dlgpAbout( HWND     hwnd,
                                   ULONG    msg,
                                   MPARAM   mp1,
                                   MPARAM   mp2 );

static  VOID  WmCreate (HWND client);
static  VOID  StartThreads( USHORT   usNumThreads );
static  VOID  fnThread ( PVOID   lfn );
static  VOID  WmCommand (HWND client, MPARAM mp1);
static  VOID  WmPaint (HWND client);

static VOID   RegisterExceptionHandler( _REGREC     *pstRegRec,
                                        _UserExcRec *pstUserExcRec );

#ifdef __IBMC__
ULONG _System ExHandler( EXCEPTIONREPORTRECORD       *pExRep,
#else
ULONG _syscall ExHandler( EXCEPTIONREPORTRECORD       *pExRep,
#endif
                         EXCEPTIONREGISTRATIONRECORD *pExReg,
                         CONTEXTRECORD               *pConRec,
                         VOID                        *pDspCon );

BOOL   APIENTRY ConditionHandler( PTXMI  ptxBuffer );

/*----------------------------------------------------------------------*/
/* external static variables                                            */
/*----------------------------------------------------------------------*/
HAB  habThis ;
HWND hwndFrame, hwndClient;

static LONG ulCxFrame, ulCyFrame ;

ULONG TCOUNT  = 0;
ULONG TLOOP   = 100;
ULONG TSLEEP  = 1000;

/************************************************************************/
/* FUNCTION-NAME       : main                                           */
/*                                                                      */
/* DESCRIPTION         :                                                */
/*                                                                      */
/* PARAMETERS          :                                                */
/*                                                                      */
/* RETURN-VALUE        :                                                */
/*                                                                      */
/************************************************************************/
int main (int argc, char * argv [] )
  {
  HMQ     hmq;
  QMSG    qmsg;
  ULONG   cf;

  argc = argc;
  argv = argv;

  /*----------------------------------------*/
  /* Register my own critical error handler */
  /*----------------------------------------*/
  SetErrorInfo ( ConditionHandler );

  TX (! (habThis = WinInitialize (0) ) );

  TX(! (hmq = WinCreateMsgQueue( habThis, 0 ) ) );
  TX(! WinRegisterClass( habThis,
                         TITLE,
                         wpClient,
                         CS_SIZEREDRAW,
                         0 ) );

  cf = FCF_TITLEBAR | FCF_SYSMENU | FCF_MENU | FCF_ICON
          | FCF_SIZEBORDER | FCF_MINMAX | FCF_ACCELTABLE;

  TX(! (hwndFrame = WinCreateStdWindow( HWND_DESKTOP,
                                        0L,
                                        &cf,
                                        TITLE,
                                        TITLE,
                                        0L,
                                        0,
                                        ID_mtestpm,
                                        &hwndClient ) ) );

  TX(! WinSetWindowPos( hwndFrame,
                        HWND_TOP,
                        (SHORT) (ulCxFrame * 3L / 18L),
                        (SHORT) (ulCyFrame * 3L / 14L),
                        (SHORT) (ulCxFrame * 12L / 18L),
                        (SHORT) (ulCyFrame * 8L / 14L),
                        SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW) );

  while (WinGetMsg (habThis, & qmsg, 0L, 0L, 0L) )
          WinDispatchMsg (habThis, & qmsg);

  TX(! WinDestroyWindow (hwndFrame) );
  TX(! WinDestroyMsgQueue (hmq) );
  TX(! WinTerminate (habThis) );

  return 0;
  }

/************************************************************************/
/* FUNCTION-NAME       : wpClient                                       */
/*                                                                      */
/* DESCRIPTION         : hwndClient window procedure                    */
/*                                                                      */
/* PARAMETERS          :                                                */
/*                                                                      */
/* RETURN-VALUE        :                                                */
/*                                                                      */
/************************************************************************/
static MRESULT EXPENTRY wpClient ( HWND    hwndClient,
                                   ULONG   msg,
                                   MPARAM  mp1,
                                   MPARAM  mp2 )
  {
  switch (msg)
    {
    case WM_START_THREADS:
         StartThreads( SHORT1FROMMP( mp1 ) );
         return FALSE;

    case WM_CREATE:
         WmCreate (hwndClient);
         return FALSE;

    case WM_COMMAND:
         WmCommand (hwndClient, mp1);
         return FALSE;

    case WM_ERASEBACKGROUND:
         return (MRESULT) TRUE;

    case WM_PAINT:
         WmPaint (hwndClient);
         return FALSE;

    case HM_ERROR:
         MiscDisplayMsg( hwndClient,
                         IDMSG_HELPERROR,
                         MB_OK | MB_ERROR,
                         TRUE );
         break;

    case HM_QUERY_KEYS_HELP:
         return (MRESULT) PANEL_KEYS;

    default:
          break;
    }

  return ( WinDefWindowProc (hwndClient, msg, mp1, mp2) );

  }                                    /* wpClient                      */

/************************************************************************/
/* FUNCTION-NAME       : StartThreads                                   */
/*                                                                      */
/* DESCRIPTION         : handle message WM_START_THREADS                */
/*                                                                      */
/* PARAMETERS          : number of threads to start                     */
/*                                                                      */
/* RETURN-VALUE        : VOID                                           */
/*                                                                      */
/************************************************************************/
static VOID  StartThreads( USHORT   usNumThreads )
  {
  #define   STACK_SIZE   32000

  ULONG      i;
  TID        tid;

#if defined __WATCOMC__
  char      *stack;
#endif

  FncEntry();

  Tracef( TM_I, "Starting threads now" );

  /*----------------------------------------------*/
  /* thread starter loop                          */
  /*----------------------------------------------*/

  for (i = 1 ; i <= usNumThreads; i++)
      {
      tid = -1;
      /*----------------------------------------------*/
      /* _beginthread  logic                          */
      /*----------------------------------------------*/
      #if defined __IBMC__
      TX( -1 == (LONG)( tid = (TID)_beginthread( fnThread,
                                                 NULL,
                                                 STACK_SIZE,
                                                 (PVOID) i ) ) );
      #elif defined __WATCOMC__
      TX( -1 == (LONG)( tid = (TID)_beginthread( fnThread,
                                                 NULL,
                                                 STACK_SIZE,
                                                 (PVOID) i ) ) );
      #elif defined __BORLANDC__
      TX( -1 == (LONG)( tid = (TID)_beginthread( fnThread,
                                                 8192,
                                                 (void*) i ) ) );
      #endif
      if ( -1 == (LONG)tid )
         {
         Tracef( TM_E, "ERROR !!! - beginthread returns [%ld]", tid );
         DosBeep(100,100);
         }
      else
         Tracef( TM_I, "thread tid %ld lfn %ld started", tid, i );
      }                                // END(IF) usNumThreads

  Tracef( TM_I, "Threads all started" );

  FncExitVoid();
  }

/************************************************************************/
/* FUNCTION-NAME       : fnThread                                       */
/*                                                                      */
/* DESCRIPTION         : test function running in a thread              */
/*                                                                      */
/* PARAMETERS          :                                                */
/*                                                                      */
/* RETURN-VALUE        :                                                */
/*                                                                      */
/************************************************************************/
static  VOID fnThread ( PVOID   lfn )
  {
  INT     i;
  PTIB    ptib;
  PPIB    ppib;
  ULONG   ulLevel = (ULONG)lfn;
  HAB     hab;
  HMQ     hmq;
  ULONG            ulException;
  _REGREC          stRegRec;
  _UserExcRec      stUserExcRec;
  BOOL             fRegistered = FALSE;

  FncEntry();

  // Register Exception Handler
  RegisterExceptionHandler( &stRegRec, &stUserExcRec );
  fRegistered = TRUE;
  stUserExcRec.pvBuffer = calloc( 1, DUMP_BUFFER_LEN );
  ulException = setjmp( stUserExcRec.jmp );
  if ( ulException )
    {
    /*--------------------------------------*/
    /* An exception has occurred somewhere  */
    /* which we have handled. Just exit     */
    /* this thread.                         */
    /*--------------------------------------*/
    goto FnExit;
    }

  TCOUNT ++;

  TX (! (hab = WinInitialize (0) ) );
  TX (! (hmq = WinCreateMsgQueue (hab, 0) ) );
  TX (! WinCancelShutdown( hmq, TRUE ) );

  DosGetInfoBlocks(&ptib, &ppib);

  if ( ptib->tib_ptib2->tib2_ultid == 3 )
    {
    /*----------------------*/
    /* Force an error       */
    /*----------------------*/
    TX( NULL == ( fopen( "test.ter", "r" ) ) );
    TX (!GpiAssociate( (HPS)2, (HDC)22 ) );
    }
  else
    {
    /*----------------------*/
    /* Force an error       */
    /*----------------------*/
    DosSleep(10);
    TX (DosCloseEventSem( 9083 ) );
    }

  for (i = 1; i <= TLOOP; i++)
     {
     Tracef( TM_I,
             "thread pid %ld tid %ld ulLevel %ld running",
             ppib->pib_ulpid, ptib->tib_ptib2->tib2_ultid, ulLevel );
     if ( ( ptib->tib_ptib2->tib2_ultid == 3 ) &&
          ( i == 5 ) )
       {
       UCHAR    test[8200];
       PLONG    ptr = NULL;
       memset( test, '0', sizeof(test) );

       /*----------------------*/
       /* Force an exception   */
       /*----------------------*/
       i = (int)*ptr;
       }

     DosSleep(TSLEEP);
     }

FnExit:

  Tracef( TM_I,
          "thread tid %ld ulLevel %ld ended",
          ptib->tib_ptib2->tib2_ultid, ulLevel );

  TX (! WinDestroyMsgQueue (hmq) );
  TX (! WinTerminate (hab) );

  TCOUNT --;

  if ( fRegistered )
     /*-------------------------------*/
     /* De-Register Exception Handler */
     /*-------------------------------*/
     DosUnsetExceptionHandler( (PEXCEPTIONREGISTRATIONRECORD) &stRegRec );

  free( stUserExcRec.pvBuffer );

  FncExitVoid();
  }                                    /* thread            */

/************************************************************************/
/* FUNCTION-NAME       : WmCreate                                       */
/*                                                                      */
/* DESCRIPTION         : handle message WM_CREATE                       */
/*                                                                      */
/*                                                                      */
/* PARAMETERS          : hwndClient window handle                       */
/*                                                                      */
/* RETURN-VALUE        : VOID                                           */
/*                                                                      */
/************************************************************************/
static VOID WmCreate (HWND hwndClient)
  {
  SWCNTRL sw;

  /* defaults */
  memset (& sw, 0, sizeof sw);

  sw.hwnd = WinQueryWindow (hwndClient, QW_PARENT);
  strcpy (sw.szSwtitle, TITLE);

  TX(! WinAddSwitchEntry (& sw) );

  /* QUERY SCREEN SIZE */
  ulCxFrame = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) ;
  ulCyFrame = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) ;

  MiscInitHelp(hwndClient);

  return;
  }                                    /* WmCreate             */

/************************************************************************/
/* FUNCTION-NAME       : WmCommand                                      */
/*                                                                      */
/* DESCRIPTION         : handle message WM_COMMAND                      */
/*                                                                      */
/* PARAMETERS          : - hwndClient window handle                     */
/*                       - message parameter                            */
/*                                                                      */
/* RETURN-VALUE        : VOID                                           */
/*                                                                      */
/************************************************************************/
static VOID WmCommand (HWND hwndClient, MPARAM mp1)
  {
  switch (SHORT1FROMMP (mp1) )
     {
     case IDD_ABOUTDLG:

         TX(WinDlgBox (HWND_DESKTOP,
                       hwndClient,
                       dlgpAbout,
                       0,
                       IDD_ABOUTDLG,
                       NULL ) == DID_ERROR );

         break;

     case IDD_TESTDLG:
         {
         SHORT     sNumThreads;
         TX( WinDlgBox ( HWND_DESKTOP,
                         hwndClient,
                         dlgpTest,
                         0,
                         IDD_TESTDLG,
                         &sNumThreads ) == DID_ERROR );

         Tracef( TM_I, "Number of threads to be started %d", sNumThreads );

         TX(! WinPostMsg (hwndClient,
                          WM_START_THREADS,
                          MPFROMSHORT( sNumThreads ),
                          NULL ) );
         break;
         }

     case ID_EXIT:

             MiscDestroyHelp();
             TX(! WinPostMsg (hwndClient, WM_QUIT, NULL, NULL) );
             break;
     }

  return;
  }                 /* WmCommand                   */

/************************************************************************/
/* FUNCTION-NAME       : WmPaint                                        */
/*                                                                      */
/* DESCRIPTION         : handle message WM_PAINT                        */
/*                                                                      */
/* PARAMETERS          : hwndClient window handle                       */
/*                                                                      */
/* RETURN-VALUE        : VOID                                           */
/*                                                                      */
/************************************************************************/
static VOID WmPaint (HWND hwndClient)
  {
  HPS     hps;
  RECTL   rc;
  POINTL  pt;

  /* create a cache presentation space */
  hps = WinBeginPaint (hwndClient, 0L, & rc);

  /* Set the text coordinates, */
  pt.x = pt.y = 20;

  /* set text color */
  GpiSetColor (hps, SYSCLR_WINDOWTEXT);

  /* set background color */
  GpiSetBackColor (hps, SYSCLR_WINDOW);

  /* set mix mode */
  GpiSetBackMix (hps, BM_OVERPAINT);

  /* draw the string */
  GpiCharStringAt (hps, & pt, (LONG) sizeof DESC - 1, DESC);

  WinEndPaint (hps);

  } /* WmPaint  */

/************************************************************************/
/* FUNCTION-NAME       : ConditonHandler                                */
/*                                                                      */
/* DESCRIPTION         : handles errors detected by TX macro            */
/*                                                                      */
/* PARAMETERS          : PTXMI                                          */
/*                                                                      */
/* RETURN-VALUE        : TRUE - don't terminate process                 */
/*                                                                      */
/************************************************************************/

BOOL   APIENTRY ConditionHandler( PTXMI  pTxmi )
  {
  BOOL     fRc = TRUE;        // call default error handler
                              // FALSE = terminate process
  FncEntry();

  /*----------------------------------------------*/
  /* Can now do whatever I want in this situation */
  /*----------------------------------------------*/

  Tracef ( TM_I,
           "An internal Program Error has occurred - "
           "for detailed information see below\n"
           "Module (Line)    : %.50s (%ld)\n"\
           "Function Name    : %.60s\n"\
           "Source Line      : %.60s\n"\
           "Return Code      : %ld(dec) %08x(hex)\n"\
           "Kernel RC text   : %.60s\n"\
           "PM RC text       : %.60s\n"\
           "CRT error text   : %.60s\n",
           pTxmi->szModuleName,
           pTxmi->ulLineNo,
           pTxmi->szFunction,
           pTxmi->szSourceLine,
           pTxmi->apiretRc,            // decimal
           pTxmi->apiretRc,            // hex
           pTxmi->szErrBuff2,          // Kernel
           pTxmi->szErrBuff1,          // PM
           pTxmi->szErrBuff3 );        // CRT

  FncExit( fRc );
  }

/************************************************************************/
/*                                                                      */
/* Function name      : RegisterExceptionHandler                        */
/*                                                                      */
/* Description        :                                                 */
/*                                                                      */
/* Parameters         :                                                 */
/*                                                                      */
/* Return value       :                                                 */
/*                                                                      */
/************************************************************************/

static VOID  RegisterExceptionHandler( _REGREC     *pstRegRec,
                                       _UserExcRec *pstUserExcRec )
  {
  FncEntry();

  pstRegRec->pstUserExRec = pstUserExcRec;
  pstRegRec->pnext        = NULL;
  pstRegRec->pfnHandler   = ExHandler;

  DosSetExceptionHandler((PEXCEPTIONREGISTRATIONRECORD)pstRegRec );

  FncExitVoid();
  }                                    // END(RegisterExceptionHandler)

/*************************************************************************/
/* Function name      : ExHandler                                        */
/*                                                                       */
/* Description        : handles exceptions                               */
/*                                                                       */
/* Parameters         : pointer to EXCEPTIONREPORTRECORD                 */
/*                      pointer to EXCEPTIONREGISTRATIONRECORD           */
/*                      pointer to CONTEXTRECORD                         */
/*                      pointer to VOID                                  */
/*                                                                       */
/* Return value       : XCPT_CONTINUE_SEARCH                             */
/*                      XCPT_CONTINUE_EXECUTION                          */
/*                                                                       */
/*************************************************************************/
#ifdef __IBMC__
ULONG _System ExHandler( EXCEPTIONREPORTRECORD       *pExRep,
#else
ULONG _syscall ExHandler( EXCEPTIONREPORTRECORD       *pExRep,
#endif
                          EXCEPTIONREGISTRATIONRECORD *pExReg,
                          CONTEXTRECORD               *pConRec,
                          VOID                        *pDspCon )
  {
  PTIB     ptib;
  PPIB     ppib;
  PREGREC  pstRegRec = (PREGREC)pExReg;

  if ( pExRep->fHandlerFlags & EH_NESTED_CALL )
    {
    /*----------------------------------------------------------------*/
    /* an exception is already in progress - don't do anything        */
    /*----------------------------------------------------------------*/
    goto FnExit;
    }

  DosGetInfoBlocks(&ptib, &ppib);

  /*-------------------------------------------------------------------*/
  /* identify the exception                                            */
  /*-------------------------------------------------------------------*/
  switch (pExRep-> ExceptionNum)
    {
    case XCPT_ACCESS_VIOLATION:
    case XCPT_INTEGER_DIVIDE_BY_ZERO:
    case XCPT_INTEGER_OVERFLOW:
       /*--------------------------------------------------------------*/
       /* unexpected Trap has occurred                                 */
       /*--------------------------------------------------------------*/
       longjmp(pstRegRec->pstUserExRec->jmp, pExRep->ExceptionNum);
       break;

    default:
       /*-------------------------------------------------------------*/
       /* default handles rest                                        */
       /*-------------------------------------------------------------*/
       break;
    }                                  // END(SWITCH)

FnExit:
  return( XCPT_CONTINUE_SEARCH );
  }                                    // ExHandler

/*----------------------------------------------------------------------*/
/*                       Dialog - Procedures                            */
/*----------------------------------------------------------------------*/

/************************************************************************/
/* FUNCTION-NAME       : dlgpTest                                       */
/*                                                                      */
/* DESCRIPTION         : dialog procedure for test dialog.              */
/*                       Gets the number of threads to start.           */
/*                                                                      */
/* PARAMETERS          : HWND of dialog                                 */
/*                       ULONG message id                               */
/*                       MPARAM parameter 1                             */
/*                       MPARAM parameter 2                             */
/*                                                                      */
/* RETURN-VALUE        :                                                */
/*                                                                      */
/************************************************************************/
static MRESULT EXPENTRY dlgpTest ( HWND    dialog,
                                   ULONG   msg,
                                   MPARAM  mp1,
                                   MPARAM  mp2 )
  {
  switch(msg)
    {
    case WM_INITDLG:
         SetText( dialog, FID_TITLEBAR, TEST_DLG_TITLE);
         SetText( dialog, IDD_TESTDLG_ENTRY, "2" );
         TX ( !WinSetWindowULong( dialog,
                                  QWL_USER,
                                  (ULONG) mp2 ) );
         MiscCenterDialog(HWND_DESKTOP, dialog);
         break;

    case WM_COMMAND:
          switch (SHORT1FROMMP (mp1))
            {
            PSHORT   psNumThreads;

            case DID_OK:
                {
                psNumThreads = (PSHORT)WinQueryWindowULong( dialog,
                                                            QWL_USER );
                TX( !WinQueryDlgItemShort( dialog,
                                           IDD_TESTDLG_ENTRY,
                                           psNumThreads,
                                           FALSE ) );

                TX(! WinDismissDlg (dialog, TRUE) );
                return ( (MRESULT) FALSE );
                break ;
                }

            case DID_CANCEL:
                psNumThreads = (PSHORT)WinQueryWindowULong( dialog,
                                                            QWL_USER );
                *psNumThreads = 0;
                TX(! WinDismissDlg (dialog, FALSE) );
                return ( (MRESULT) FALSE );
                break ;
            }
          break ;

    default:
       return ( WinDefDlgProc (dialog, msg, mp1, mp2) );
    }

  return ( (MRESULT) 0 );

  } /* dlgpTest             */

/************************************************************************/
/* FUNCTION-NAME       : dlgpAbout                                      */
/*                                                                      */
/* DESCRIPTION         : dialog procedure for about box                 */
/*                                                                      */
/* PARAMETERS          : HWND of dialog                                 */
/*                       ULONG message id                               */
/*                       MPARAM parameter 1                             */
/*                       MPARAM parameter 2                             */
/*                                                                      */
/* RETURN-VALUE        :                                                */
/*                                                                      */
/************************************************************************/
static MRESULT EXPENTRY dlgpAbout( HWND     hwnd,
                                   ULONG    msg,
                                   MPARAM   mp1,
                                   MPARAM   mp2 )
  {
  switch(msg)
    {
    case WM_INITDLG:
         MiscCenterDialog(HWND_DESKTOP,hwnd) ;
         break;

    case WM_COMMAND:

          if (SHORT1FROMMP (mp1) == DID_OK)
             {
             TX(! WinDismissDlg (hwnd, TRUE) );
             return (FALSE);
             }
          break ;

    default:
       return WinDefDlgProc (hwnd, msg, mp1, mp2);
    }

  return (FALSE);
  }                                    /* END(dlgpAbout)        */

/************************************************************************/
/*** EOF mtestpm.c                                                    ***/
/************************************************************************/
