/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dumpairq     */

/* script to decode the "airqi" table. This table */
/* contains info about hooked PSD functions */
/* irq numbers and their associated irq vectors */
/* and type/properties of interrupts */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

address df "cmd xxx .lmo 'acpi'"
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
if yyy.0 > 2 then do
   /*
    for newer ACPI.PSD, airqi Table is located within ACPI.PSD
    for ACPI.PSD v 3.23.10, it can be found at 4:102f8
    for ACPI.PSD v 3.23.12, it can be found at 4:107d4
    for ACPI.PSD v 3.23.13, it can be found at 4:10884
    for ACPI.PSD v 3.23.14, it can be found at 4:107f8
    for ACPI.PSD v 3.23.15, it can be found at 4:106a0
    for ACPI.PSD v 3.23.16, it can be found at 4:1057c

    ACPI Version string at 3:15f
   */
   MEMOBJ = 3
   OFFSET = x2d(15f)
   n = 2+MEMOBJ

   parse var yyy.n . . baseaddr .

   address df 'cmd xxx da %(' baseaddr ' + ' d2x(OFFSET) ')'
   rc = CompressDfReturn()
   parse var xxx.1 . version
   say version
   version = word(xxx.1,8)
   if version == '3.23.12' then do
      OBJOFFSET = x2d(107d4)
   end
   else if version == '3.23.13' then do
      OBJOFFSET = x2d(10884)
   end
   else if version == '3.23.14' then do
      OBJOFFSET = x2d(107f8)
   end
   else if version == '3.23.15' then do
      OBJOFFSET = x2d(106a0)
   end
   else if version == '3.23.16' then do
      OBJOFFSET = x2d(1057c)
   end
   else if version == '3.23.10' then do
      OBJOFFSET = x2d(102f8)
   end
   else do
      say 'unknown ACPI version !'
      signal bailout
   end

   OBJNUM = 4
   NUMENTRIES=64
   last = yyy.0-1
   do i=3 to last
      parse var yyy.i obj . vbase .
      if x2d(obj) == OBJNUM then do
         leave
      end
   end
   airqi = d2x(OBJOFFSET+x2d(vbase))
   len = 'l100'
end
else do
   OBJOFFSET = 0
   NUMENTRIES=48
   address df "cmd xxx ln airqi"
   rc = CompressDfReturn()
   parse var xxx.1 vbase .
end

say 'Info about irqi_usFlags:'
say '0x0080: SPI IRQ (ACPI SPI Handler interrupt)'
say '0x0040: LSI IRQ (local SW interrupt)'
say '0x0020: IPI IRQ (interprocessor interrupt)'
say '0x0010: candidate for routing to VDM if not claimed by PDD'
say '0x0008: NPX IRQ'
say '0x0004: shareable IRQ'
say '0x0002: system IRQ (slave IRQ)'
say '0x0001: IRQ shared by more than one DD'
say
say

do i=0 to (NUMENTRIES-1)
   addr = '%('vbase'+'d2x(OBJOFFSET)'+'d2x(i*16)')'

   address df 'cmd xxx dd 'addr' l4'
   rc = CompressDfReturn()
   parse var xxx.1 . irqi_pdirqHead 21 irqi_usFlags 25 irqi_ucIRQVec 27 irqi_ucIRQNum irqi_PSDHandler .

   /* fix bug: strip additional whitespace for first parsed variable */
   irqi_pdirqHead = strip(irqi_pdirqHead)

   say 'irqi_pdirqHead:  %'irqi_pdirqHead' (linear address)'
   say 'irqi_ucIRQNum:   'x2d(irqi_ucIRQNum)
   say 'irqi_ucIRQVec:   0x'irqi_ucIRQVec
   say 'irqi_usFlags:    0x'irqi_usFlags
   say 'irqi_PSDHandler: %'irqi_PSDHandler' (linear address)'
   say '---------------------------------------------------'
end
bailout:
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */

