/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dumpdate     */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

address df 'cmd xxx lm'
address df 'cmd xxx lg'

address df 'cmd xxx ln SysInfoSeg'
rc = CompressDfReturn()
parse var xxx.1 addr .

address df 'cmd xxx dw 'addr' l1'
rc = CompressDfReturn()
parse var xxx.1 . selector .

gisaddr = selector':0000+8t'
address df 'cmd xxx db 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . hour .
hour = x2d(hour)

gisaddr = selector':0000+9t'
address df 'cmd xxx db 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . minutes .
minutes = x2d(minutes)

gisaddr = selector':0000+10t'
address df 'cmd xxx db 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . seconds .
seconds = x2d(seconds)


gisaddr = selector':0000+16t'
address df 'cmd xxx db 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . day .
day = x2d(day)

gisaddr = selector':0000+17t'
address df 'cmd xxx db 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . month .
month = x2d(month)

gisaddr = selector':0000+18t'
address df 'cmd xxx dw 'gisaddr' l1'
rc = CompressDfReturn()
parse var xxx.1 . year .
year = x2d(year)

say 'Date of Dump:'day'.'month'.'year' at 'hour':'minutes':'seconds

return 0

CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
