/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %u    */

/* script to do a "u" (unassemble) command and to resolve addresses to symbol names */
/* NOTE: this code will query the symbol file that is loaded LAST and which therefore appears */
/* first in the list of loaded symbol files */
/* therefore, by unloading symbol files and reloading the symbol file you are interested in */
/* as the LAST file, you can control which symbol file will be used to query symbol names */
/* this script takes the same paramters as the "u" command */

numeric digits 20

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

parse arg argument

address df 'cmd xxx u 'argument
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
if yyy.1 = 'Expression error' then do
   say 'pass valid address that you want to disassemble !'
   return 1
end

tmp=''
if pos(':',argument) = 0 then do
   tmp = strip(argument,'L','%')
end
else do
   parse var argument sel ':' off
   tmp = sel||off
end /* do */

if length(tmp)>8 & datatype(tmp,'X') = 1 then do
   say 'pass valid address that you want to disassemble !'
   return 1
end

do n=1 to yyy.0-1
   line = yyy.n

   addr = ''
   mc   = ''
   instr = ''
   args  = ''
   parse var line addr mc instr args
   args = strip(args,'B',' ')

   if instr = '' | args = '' then do
      say line
      iterate
   end

   /* check for calls and jumps if we can resolve to symbolic addresses */
   if instr = 'call' | substr(instr,1,1) = 'j' | substr(instr,1,4) = 'loop' then do
      /*
         expand near adresses to far adresses, necessary as the 'ln' command will
         only allow either segmented far adresses or linear addresses
      */
      if length(args) <= 4 & datatype(args,'X') = 1 then do
         parse var addr sel ':' .
         off = args
         args = sel':'off
      end
      parse var args sel ':' off
      /*
         if segmented address and if offset = 0 we look for a call gate address
         by following the selector value
      */
      if pos(':',args) > 0 & off = 0 then do
         address df 'cmd xxx dg 'sel
         rc = CompressDfReturn()
         parse var xxx.1 . '=' args .
      end
      if pos(':',args) = 0 then do
         args = strip(args,'L','%')
         args = '%'args
      end
      address df 'cmd xxx ln 'args
      rc = CompressDfReturn()
      xxx.1=strip(xxx.1,'T',' ')
      if xxx.1 \= 'No Symbols Found' & xxx.1 \= 'Expression error' then do
         parse var xxx.1 . . routinename
         line = overlay(routinename,line,40,40,' ')
         if words(routinename) > 1 then do
            line = line' ('args')'
         end
      end
   end

   /* check for direct memory references if we can resolve to symbolic addresses */
   beginning = ''
   rest = ''
   dataaddr = '-'
   startsep = '['
   endsep   = ']'
   parse var line beginning (startsep) dataaddr (endsep) rest
   if dataaddr = '' then do
      dataaddr = '-'
   end /* do */

/*
   /* check for constant addresses */
   /* problem1: an ABSOLUTE constant might be defined that does not decode into a symbol */
   /* problem2: for an offset, it cannot be determined if it is a code or a data offset */
   if instr = 'mov' & dataaddr = '-' then do
      beginning = ''
      startsep=','
      endsep=''
      rest=''
      dataaddr='-'
      parse var line beginning (startsep) dataaddr
      if dataaddr = '' then do
         dataaddr = '-'
      end /* do */
   end /* do */
*/

   if instr = 'push' & dataaddr = '-' then do
      beginning = ''
      startsep=''
      endsep=''
      rest=''
      dataaddr='-'
      idx = wordindex(line,4)
      idx = idx-1
      parse var line beginning =(idx) dataaddr
      if dataaddr = '' then do
         dataaddr = '-'
      end /* do */
   end /* do */

   if datatype(dataaddr,'X') = 1 then do
      if x2d(dataaddr) < 65536 then do
         /* looking for near addresses and converting to far addresses */
         address df 'cmd xxx lg'
         rc = CompressDfReturn()
         parse var xxx.5 segbase
         segbase = strip(segbase,'L',' ')
         parse var segbase sel ':' .
         address df 'cmd xxx ln 'sel':'dataaddr
         rc = CompressDfReturn()

         if xxx.1 = 'No Symbols Found' then do
            address df 'cmd xxx lg'
            rc = CompressDfReturn()
            parse var xxx.6 segbase
            segbase = strip(segbase,'L',' ')
            parse var segbase sel ':' .
            address df 'cmd xxx ln 'sel':'dataaddr
            rc = CompressDfReturn()
         end

         if xxx.1 \= 'No Symbols Found' then do
            parse var xxx.1 . . symbolname
            line = beginning||startsep||symbolname||endsep||rest
         end
      end
      else do
         /* looking for flat addresses */
         address df 'cmd xxx ln %'dataaddr
         rc = CompressDfReturn()

         /* we are testing if we can find the address in the 1st group of the symbols file (MPDATAGROUP for the OS2KRNL) */
         /* many 32-bit addresses can only be queried indirectly via the group selector */
         if xxx.1 = 'No Symbols Found' then do
            address df 'cmd xxx lg'
            rc = CompressDfReturn()
            parse var xxx.5 segbase .
            segbase = strip(segbase,'L',' ')
            address df 'cmd xxx ? 'segbase
            rc = CompressDfReturn()
            parse var xxx.1 '%' linbase .
            parse var segbase sel ':' .
            if dataaddr >= linbase then do
               off = d2x(x2d(dataaddr)-x2d(linbase))
               address df 'cmd xxx ln 'sel':'off
               rc = CompressDfReturn()
            end
            else do
               xxx.1 = 'No Symbols Found'
            end
         end

         /* we are testing if we can find the address in 2nd group of the symbols file (DOSGROUP for the OS2KRNL) */
         /* many 32-bit addresses can only be queried indirectly via group selector */
         if xxx.1 = 'No Symbols Found' then do
            address df 'cmd xxx lg'
            rc = CompressDfReturn()
            parse var xxx.4 segbase .
            segbase = strip(segbase,'L',' ')
            address df 'cmd xxx ? 'segbase
            rc = CompressDfReturn()
            parse var xxx.1 '%' linbase .
            parse var segbase sel ':' .
            if dataaddr >= linbase then do
               off = d2x(x2d(dataaddr)-x2d(linbase))
               address df 'cmd xxx ln 'sel':'off
               rc = CompressDfReturn()
            end
            else do
               xxx.1 = 'No Symbols Found'
            end
         end

         if xxx.1 \= 'No Symbols Found' then do
            parse var xxx.1 . . symbolname
            line = beginning||startsep||symbolname||endsep||rest
         end
      end
   end

   say line
end
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
