
#ifndef PMM_INCLUDED
   #define PMM_INCLUDED

   #ifdef __cplusplus
      extern "C" {
   #endif

   #define PMMENTRY             APIENTRY

   typedef ULONG                PMMRET;
   typedef LHANDLE              HPMMSESSION;
   typedef HPMMSESSION *        PHPMMSESSION;

   /* Errors Returned by Functions ********************************************/
   #define PMMESuccess                          0
   #define PMMECannotQueryOS2Version            1
   #define PMMECannotRunInThisOS2Version        2
   #define PMMEMultipleSessionsNotAllowed       3
   #define PMMECannotQueryDesktopWindow         4
   #define PMMECannotQueryObjectWindow          5
   #define PMMENotEnoughMemory                  6
   #define PMMECannotRegisterInternalClass      7
   #define PMMECannotCreateInternalWindow       8
   #define PMMECannotSetSendMsgHook             9
   #define PMMECannotSetInputMsgHook            10
   #define PMMECannotOpenTraceFile              11
   #define PMMEWriteFailed                      12
   #define PMMECannotCloseTraceFile             13
   #define PMMETraceSessionNotCreated           14
   #define PMMEInvalidHandle                    15
   #define PMMEAlreadyTracing                   16
   #define PMMENotTracingNow                    17
   #define PMMECannotReleaseInputMsgHook        18
   #define PMMECannotReleaseSendMsgHook         19
   #define PMMECannotDestroyInternalWindow      20
   #define PMMEKeyNotDefinable                  21
   #define PMMEKeysCannotBeTheSame              22
   #define PMMEKeyAlreadyDefined                23
   #define PMMEInvalidPointer                   24

   /* Errors Occurring when Using PMM *****************************************/
   #define PMMECritWriteFailed                  1001
   #define PMMECritNotEnoughMemory              1002
   #define PMMECritCannotSubclassWindow         1003
   #define PMMECritTooManyNestedMsgCalls        1004

   /* Warnings Occurring when Using PMM ***************************************/
   #define PMMWInvalidWindow                    5001
   #define PMMWInvalidWindowProc                5002

   /* Message Groups to Trace *************************************************/
   #define PMMTMG_MAX_GROUPS            18

   #define PMMTMG_WINDOW                0x00000001L
   #define PMMTMG_CONTROLS              0x00000002L
   #define PMMTMG_KEYBOARD              0x00000004L
   #define PMMTMG_MOUSE                 0x00000008L
   #define PMMTMG_CLIPBOARD             0x00000010L
   #define PMMTMG_DDE                   0x00000020L
   #define PMMTMG_HELP                  0x00000040L
   #define PMMTMG_DIRECT_MANIP          0x00000080L
   #define PMMTMG_DBCS                  0x00000100L
   #define PMMTMG_PEN                   0x00000200L
   #define PMMTMG_MULTIMEDIA            0x00000400L
   #define PMMTMG_SYSTEM                0x00000800L
   #define PMMTMG_OTHER                 0x00001000L
   #define PMMTMG_FILE_DIALOG           0x00002000L
   #define PMMTMG_FONT_DIALOG           0x00004000L
   #define PMMTMG_RESERVED              0x01000000L
   #define PMMTMG_UNDOCUMENTED          0x02000000L
   #define PMMTMG_USER                  0x04000000L

   #define PMMTMG_ALL                   0xffffffffL

   /* Controls to Trace *******************************************************/
   #define PMMTCO_MAX_CONTROLS          20

   #define PMMTCO_FRAME                 0x00000001L
   #define PMMTCO_COMBOBOX              0x00000002L
   #define PMMTCO_BUTTON                0x00000004L
   #define PMMTCO_MENU                  0x00000008L
   #define PMMTCO_STATIC                0x00000010L
   #define PMMTCO_ENTRYFIELD            0x00000020L
   #define PMMTCO_LISTBOX               0x00000040L
   #define PMMTCO_SCROLLBAR             0x00000080L
   #define PMMTCO_TITLEBAR              0x00000100L
   #define PMMTCO_MLE                   0x00000200L
   #define PMMTCO_APPSTAT               0x00000400L
   #define PMMTCO_KBDSTAT               0x00000800L
   #define PMMTCO_PECIC                 0x00001000L
   #define PMMTCO_DBE_KKPOPUP           0x00002000L
   #define PMMTCO_SPINBUTTON            0x00004000L
   #define PMMTCO_CONTAINER             0x00008000L
   #define PMMTCO_SLIDER                0x00010000L
   #define PMMTCO_VALUESET              0x00020000L
   #define PMMTCO_NOTEBOOK              0x00040000L
   #define PMMTCO_OTHER                 0x80000000L

   #define PMMTCO_ALL                   0xffffffffL

   /***************************************************************************/
   /* Avoid warning: "Macro name 'x' on #define is also an identifier." */
   #pragma info( noppc )
   #define WinSubclassWindow( hwnd, pfnwp )        \
      PMMSubclassWindow( (hwnd), (pfnwp) )
   #define WinSetWindowPtr( hwnd, index, p )       \
      PMMSetWindowPtr( (hwnd), (index), (p) )
   #define WinQueryWindowPtr( hwnd, index )        \
      PMMQueryWindowPtr( (hwnd), (index) )
   #pragma info( restore )

   /* Function Prototypes *****************************************************/
   PMMRET PMMENTRY PMMCreateTraceSession(   PHPMMSESSION phpmms
                                          , HAB hab
                                          , PSZ pszTraceFileName );
   PMMRET PMMENTRY PMMStartTracing( HPMMSESSION hpmms );
   PMMRET PMMENTRY PMMStopTracing( HPMMSESSION hpmms );
   PMMRET PMMENTRY PMMDestroyTraceSession( HPMMSESSION hpmms );
   PMMRET PMMENTRY PMMQueryVersion( HPMMSESSION hpmms, PULONG pulVersion );
   PMMRET PMMENTRY PMMQueryTraceFileHandle(   HPMMSESSION hpmms
                                            , PHFILE TraceFileHandle );
   PMMRET PMMENTRY PMMSetMsgGroupsToTrace(   HPMMSESSION hpmms
                                           , ULONG ulMask
                                           , ULONG ulFlags );
   PMMRET PMMENTRY PMMSetControlsToTrace(   HPMMSESSION hpmms
                                          , ULONG ulMask
                                          , ULONG ulFlags );
   PMMRET PMMENTRY PMMShowWindowText( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowClassName( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowWindowID( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowPointers( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowAllArrayItems( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowAllLinkedListItems( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowFullMsgInfo( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMShowInternalMessages( HPMMSESSION hpmms, BOOL bShow );
   PMMRET PMMENTRY PMMDefineStartStopTracingKeys(   HPMMSESSION hpmms
                                                  , USHORT usStartKey
                                                  , USHORT usStopKey );
   PMMRET PMMENTRY PMMQueryIfIgnoreMsg( HPMMSESSION hpmms, PBOOL pbIgnore );
   PMMRET PMMENTRY PMMSMHQueryMsg(   HPMMSESSION hpmms
                                   , PBOOL pbChanged
                                   , PSMHSTRUCT psmh );
   PFNWP  APIENTRY PMMSubclassWindow( HWND hwnd, PFNWP pNewWindowProc );
   BOOL   APIENTRY PMMSetWindowPtr( HWND hwnd, LONG lb, PVOID pp );
   PVOID  APIENTRY PMMQueryWindowPtr( HWND hwnd, LONG index );

   #ifdef __cplusplus
      }
   #endif

   /* End #ifndef PMM_INCLUDED */
#endif

