/* Definitions used by the iid program.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
extern char * getenv() ;
extern int getopt() ;
extern char * optarg ;
extern int optind ;
#define TRUE 1
#define FALSE 0

#ifdef DEF
#define EXTERN
#define INIT(a) =(a)
#else
#define EXTERN extern
#define INIT(a)
#endif

#define BITS_PER_BYTE 8                /* used by bit set manipulation */

#define HASH_SIZE 947                  /* size of hash table for file names */

#ifndef HELPFILE
#define HELPFILE "/usr/local/iid.help" /* The help file location */
#endif

#define INIT_FILES 8000                /* start with bits for this many */

#define INIT_SETSPACE 500              /* start with room for this many */

#define MAX(a,b) (((a)<(b))?(b):(a))

#define MAXCMD 1024                    /* input command buffer size */

#define MIN(a,b) (((a)>(b))?(b):(a))

#ifndef PAGER
#define PAGER "pg"
#endif

#define PROMPT "iid> "

/* set_type is the struct defining a set of file names
 * The file names are stored in a symbol table and assigned
 * unique numbers. The set is a bit set of file numbers.
 * One of these set structs is calloced for each new set
 * constructed, the size allocated depends on the max file
 * bit number. An array of pointers to sets are kept to
 * represent the complete set of sets.
 */

typedef struct set_struct {
   char *                 set_desc ;   /* string describing the set */
   int                    set_num ;    /* the set number */
   int                    set_size ;   /* number of long words in set */
   unsigned long int      set_tail ;   /* set extended with these bits */
   unsigned long int      set_data[1] ;/* the actual set data (calloced) */
} set_type ;

/* id_type is one element of an id_list
 */

typedef struct id_struct {
   struct id_struct *     next_id ;    /* Linked list of IDs */
   char                   id [ 1 ] ;   /* calloced data holding id string */
} id_type ;

/* id_list_type is used during parsing to build lists of
 * identifiers that will eventually represent arguments
 * to be passed to the database query programs.
 */

typedef struct id_list_struct {
   int                    id_count ;   /* count of IDs in the list */
   id_type * *            end_ptr_ptr ;/* pointer to link word at end of list */
   id_type *              id_list ;    /* pointer to list of IDs */
} id_list_type ;

/* symtab_type is used to record file names in the symbol table.
 */
typedef struct symtab_struct {
   struct symtab_struct * hash_link ;  /* list of files with same hash code */
   int                    mask_word ;  /* word in bit vector */
   unsigned long          mask_bit ;   /* bit in word */
   char                   name [ 1 ] ; /* the file name */
} symtab_type ;

extern void DescribeSets();
extern id_list_type * ExtendList();
extern void FlushSets();
extern void InitIid();
extern id_list_type * InitList();
extern symtab_type * InstallFile();
extern void OneDescription();
extern void PrintSet();
extern void RunPager();
extern set_type * RunProg();
extern void RunShell();
extern void ScanInit();
extern void SetDirectory();
extern set_type * SetIntersect();
extern set_type * SetInverse();
extern id_list_type * SetList();
extern set_type * SetUnion();
extern int yylex();

/* LidCommand is the command to run for a Lid_group. It is set
 * to "lid -kmn" if explicitly preceeded by "lid", otherwise
 * it is the default command which is determined by an option.
 */
EXTERN char * LidCommand ;

/* DefaultCommand is the default command for a Lid_group. If
 * the -a option is given to iid, it is set to use 'aid'.
 */
EXTERN char * DefaultCommand INIT("lid -kmn") ;

/* FileList is a lexically ordered list of file symbol table
 * pointers. It is dynamically expanded when necessary.
 */
EXTERN symtab_type * *    FileList INIT(NULL) ;

/* FileSpace is the number of long ints in TheFiles array.
 */
EXTERN int                FileSpace INIT(0) ;

/* HashTable is the symbol table used to store file names. Each
 * new name installed is assigned the next consecutive file number.
 */
EXTERN symtab_type *      HashTable [ HASH_SIZE ] ;

/* HelpSet is a dummy set containing only one bit set which corresponds
 * to the help file name. Simply a cheesy way to maximize sharing of
 * the code that runs the pager.
 */
EXTERN set_type *         HelpSet ;

/* high_bit is a unsigned long with the most significant bit set.
 */
EXTERN unsigned long      high_bit ;

/* ListSpace is the amount of space avail in the FileList.
 */
EXTERN int                ListSpace INIT(0) ;

/* MaxCurFile - max word that has any bit currently set in the
 * TheFiles array.
 */
EXTERN int                MaxCurFile INIT(0) ;

/* NextFileNum is the file number that will be assigned to the next
 * new file name seen when it is installed in the symtab.
 */
EXTERN int                NextFileNum INIT(0) ;

/* NextMaskBit is the bit within the next mask word that will
 * correspond to the next file added to the symbol table.
 */
EXTERN unsigned long      NextMaskBit ;

/* NextMaskWord is the next word number to be assigned to a file
 * bit mask entry.
 */
EXTERN int                NextMaskWord INIT(0) ;

/* NextSetNum is the number that will be assigned to the next set
 * created. Starts at 0 because I am a C programmer.
 */
EXTERN int                NextSetNum INIT(0) ;

/* The PAGER program to run on a SHOW command.
 */
EXTERN char               Pager[MAXCMD] ;

/* Prompt - the string to use for a prompt.
 */
EXTERN char               Prompt[MAXCMD] ;

/* SetSpace is the number of pointers available in TheSets. TheSets
 * is realloced when we run out of space.
 */
EXTERN int                SetSpace INIT(0) ;

/* TheFiles is a bit set used to construct the initial set of files
 * generated while running one of the subprograms. It is copied to
 * the alloced set once we know how many bits are set.
 */
EXTERN unsigned long *    TheFiles INIT(NULL) ;

/* TheSets is a dynamically allocated array of pointers pointing
 * the sets that have been allocated. It represents the set of
 * sets.
 */
EXTERN set_type * *       TheSets INIT(NULL) ;

/* VerboseQuery controls the actions of the semantic routines during
 * the process of a query. If TRUE the sets are described as they
 * are constructed.
 */
EXTERN int                VerboseQuery ;
