// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved


#include "winbase.h"

//-------------------------------------------------------------------
//  getScreenPS
HPS TWinBase::getScreenPS()
{
   WinGetPS( getFrame() );
}

//-------------------------------------------------------------------
//  TWinBase
TWinBase::TWinBase(ULONG resource)
{
   fResource = resource;
}

//-------------------------------------------------------------------
//  ~TWinBase
TWinBase::~TWinBase(void)
{
   if (hwndFrame!=(HWND)NULL)
      WinDestroyWindow(hwndFrame);
}

//-------------------------------------------------------------------
//   getClassName
const char *TWinBase::getClassName(void)
{
   return "TWinBase";
}

//-------------------------------------------------------------------
//   GetFrame
HWND TWinBase::getFrame(void)
{
   return hwndFrame;
}


//-------------------------------------------------------------------
//   isEnabled
BOOL TWinBase::isEnabled()
{
   return WinIsWindowEnabled( getFrame() );
}

//-------------------------------------------------------------------
//   enableUpdate
BOOL TWinBase::enableUpdate(BOOL enable)
{
   WinEnableWindowUpdate( getFrame(),enable);
}

//-------------------------------------------------------------------
//   isVisible
BOOL TWinBase::isVisible()
{
   return WinIsWindowVisible( getFrame() );
}


//-------------------------------------------------------------------
//   setParent
BOOL TWinBase::setParent(TWinBase *parent, BOOL redraw)
{
   BOOL res = WinSetParent( getFrame(), parent->getFrame(), redraw);
   //fParent = parent;

   return res;
}


//-------------------------------------------------------------------
//   isChild
BOOL TWinBase::isChild(TWinBase *parent)
{
   return WinIsChild(getFrame() , parent->getFrame() );
}


//-------------------------------------------------------------------
//   setWindowPosition
void TWinBase::setWindowPosition(LONG x, LONG y, LONG cx, LONG cy, ULONG fl)
{
   WinSetWindowPos(getFrame(), (HWND) NULL,  x, y, cx, cy, fl);

}


//-------------------------------------------------------------------
//   getWindowPosition
void TWinBase::getWindowPosition(LONG &x, LONG &y, LONG &cx, LONG &cy)
{
   SWP swp;

   WinQueryWindowPos( getFrame(),&swp);
   x = swp.x;
   y = swp.y;
   cx = swp.cx;
   cy = swp.cy;

}


//-------------------------------------------------------------------
//   Update
void TWinBase::Update()
{
   WinUpdateWindow(getFrame());

}



