.. ------------------------------------------------------------
.2 Hints for authors
.. ------------------------------------------------------------
.an HINTS

[=TOPICS]

.su V30 u 1

.. ------------------------------------------------------------
.3 Layout decisions
.. ------------------------------------------------------------

In order to create well-readable help documents, the following
items should be more or less respected:

.ul
- Make *sections* (pages) for help documents *short*.
- Be careful with text *emphasizing* and *decoration*. Too much
  of them would confuse the readers and would make them loose
  orientation and overview.
- Since hyperlinks appear themselves highly emphasized, you should
  better choose a *stronger emphasizing* than used for other
  (e.g. printed) documents. (Therefore in this document the bold
  attribute is used for emphasizing instead of italic.)
- Use a special font for *source code*. For example blocks, use the
  [.CMD_FORMAT] environment. Before using examples as inline text,
  please read the notes in the [.CMD_TTFONT] section. So maybe you'll
  decide to dispense with monospace inline fonts for your document.
  In that case, probably the bold attribute would be most suited for
  inline source code text.
- *Slanted fonts* are not well readable with screen resolutions.
  Even though the slant factor in italic shapes for OS/2 bitmap
  fonts is increased, upright fonts are much better readable in
  online documents. Slanted fonts are often used for command
  parameters in program documentations.
- Use predefined environments for special blocks of text instead
  of playing with layout parameters extensively. Always prefer
  the *Logical Markup*.
- Avoid the *underlined* attribute in non-typewriter documents.
  Better use bold, italic or any other emphasizing. Moreover, with
  the current version of the
  [ [=URL_INNOTEK_FONTENGINE] Innotek Font Engine],
  underlined text looks ugly, because the line appears too close to
  the baseline. Of course, that drawback applies only if a user has
  activated it for his help viewer, while the current v2.19 of NewView
  doesn't support it yet.
- For headers and underlined words, omit a possible *trailing colon*.
- Avoid too many *different types* of text emphasizing and fonts.
- Try to avoid *hard-coded font* specifications in your document,
  maybe except [.CMD_ATTRIBUTE .ATTRIBUTE TT].
- Try to avoid manually added empty lines using the [.CMD_PAR] or
  [.CMD_LINEBREAK line break] commands.
- If you have designed an alternate, maybe more beautiful and
  more eye-catching *page style*, some of the items above don't
  apply. (Then you're probably not writing a help document.)
- Always test your document with both IBM's *View* and the newest
  version of [ [=URL_NEWVIEW] *NewView*].


.. ------------------------------------------------------------
.3 Alternate for writing help documents
.. ------------------------------------------------------------

It's possible to write simple IPF code directly with an text editor.
For more complex and highly-linked documents, that would be a very
uncomfortable option.

There exist a couple of suitable IPF preprocessors:

.ul
- *Html2Ipf* uses HTML as its source file format. As its biggest advantage,
  any HTML editor can be used, even a WYSIWYG one. It does a good
  job, but also has disadvantages: You'll have to maintain countless HTML
  files (one file per IPF page). Moreover, there exist some minor issues
  with vertical spacing.
- *Vyperhelp* has a GUI, but unfortunately produces poor output.
  Lists are not handled correctly in the IPF files. That will lead to
  hardly portable help file sources.
- *Hypermake* is in some cases more powerful than *HyperText/2*, but costs
  a shareware fee. Additionally, its IPF output has a few spacing issues.
- *HyperText/2* doesn't come with those drawbacks, but you have to "learn"
  another new language. That language is simple, but you have to read at
  least a few pages of this doc (or look at the examples) before being able
  to use it. Its input source files are highly readable, especially with an
  [.FN_NEPMD_HTEXT_SUPPORT text editor] supporting syntax highlighting for
  *HyperText/2*. So WYSIWYG editing is not required. Moreover, the
  [.USAGE_IPF2HTEXT Ipf2Htext] compiler allows for using source files, that
  were originally not written with *HyperText/2* and exist only in the IPF
  format. Compared to other IPF import solutions, manual postprocessing is
  not required in most cases.


.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_NEPMD_HTEXT_SUPPORT

Since version 2.00 (to be released in 2007), the
[ [=URL_NEPMD] Netlabs EPM Distribution] comes with
highlighting support for *HyperText/2* and IPF. Additionally, contained
sections can be listed to jump in between them.

