.. ----------------------------------------
.2 Limitations
.. ----------------------------------------
.an LIMITATIONS

The current version of [=TITLE] has the following limitation:
.ul compact
- Links cannot span over multiple lines, as yet.

The [=TITLE] macro language comes with some elements not being found in
the low-level IPF language. As a result, several logical markup elements
can't be exactly recreated when compiling forth and back.

Although *Ipf2Htext* tries to do its best, postprocessing will pay for
more complex files.
Note that the viewable output of a forth and back compiled file looks
equal to the original.

The following limitations apply to the current version of the *Ipf2Htext*
compiler:
.ul compact
- [.CMD_SUBLINK] commands are not recreated, as well as specified
  autolink properties of panels. Instead of just ignoring auto-links,
  *Htext* was changed to automatically recognize auto-linked pages,
  determined from their dimensions. Since that, forth-and-back-compiled
  texts will look equal to the original in most cases.
  For simpler HTEXT code and easier reading, .SUBLINK commands should
  be inserted by hand optionally.
- Multiple *:p.* tags are converted to one empty line (or one *.p*
  command if required).
- *:link.* header tags with the attribute #auto# to open a panel
  automatically are not supported, as well as other attributes of it.
  As a rule of thumb: IPF header links that don't require an *:elink.*
  tag are ignored. (That doesn't apply to artlinks.)
- The #group# attribute for panels is ignored.
- Imbedded (included) IPF source files must be processed separately. An
  *.im* IPF command must be changed to an [.CMD_INCLUDE] command
  manually. (Note that also *Htext* creates a single output file only.)
- When *Htext* creates an IPF file, all anchor names get lost and were
  converted to IPF refids. Therefore *Ipf2Htext* is not able to restore
  the original anchor names. Instead of that, it converts the ids back to
  anchor names, determined from the pages' titles. The first four words of
  a title were taken, while only unique names are created, maybe by
  appending a number. All non-alphanumeric characters of a title name are
  converted to underscores.
- [.CMD_LOL] commands are not recreated.
- [.CMD_HNUMBERING] additions were removed from the panel headers in the
  IPF output file. They can be readded to produce the same output on
  back-and-forth-compiling.
- Mirrored panels, previously created by the *Htext* [.CMD_MIRROR] command,
  are not recognized. That means that they will be present in the output,
  but only copied.
- In nested lists, *Htext* allows for omitting repeated list commands when
  the list level changes. That results in better readable text. *Ipf2Htext*
  doesn't remove all of these optional ones.
- Second level IPF index entries *:I2.* are converted to standard index entries,
  preceded with the value of the first level one and separated with " - ".
- IPF's *:lp.* tags are converted to [.CMD_PAR] commands.
- IPF's *:caution.* and *:warning.* lists are converted to [.CMD_NOTE] lists.
- Many more exotic IPF tags/attributes are ignored.
- Ignored IPF code produces a warning. Additionally, a comment holding the
  original IPF line is added to the output file. In order to find these
  lines, search for "******" (without the quotes).

