.. ------------------------------------------------------------
.2 HyperText/2 source samples
.. ------------------------------------------------------------
.an SAMPLES

.su V30 u 1

.. ------------------------------------------------------------
.3 Panel header sample
.. ------------------------------------------------------------
.an SAMPLE_PANEL

.hr Level 2 panel and a link to it created by [=BASETITLE] code
.fo off
 .2 HyperText/2 source samples
 .an SAMPLES

 This is a link to [[.SAMPLES the previous panel]]
.fo on

.hr Resulting link (the header is defined in the previous panel)

This is a link to [.SAMPLES the previous panel]

.hr Level 2 panel and a link to it created by IPF code
.fo off
 :h2 name=SAMPLES.HyperText/2 source samples
 :p.
 This is a link to
 :link reftype=hd refid=SAMPLES.the previous panel:elink.
.fo on

(The IPF code created by [=TITLE] is slightly different.)

.. ------------------------------------------------------------
.3 List sample
.. ------------------------------------------------------------
.an SAMPLE_LIST

.hr Unordered list created by [=BASETITLE] code
.fo off
 .ul compact
 - this is the first level 1 item
 - this is the second level 1 item
   - this is the first level 2 item
   - this is the second level 2 item
   - this is the third level 2 item
.fo on

.hr Resulting list
.ul compact
- this is the first level 1 item
- this is the second level 1 item
  - this is the first level 2 item
  - this is the second level 2 item
  - this is the third level 2 item

.hr Unordered list created by IPF code
.fo off
 :ul compact.
 :li.this is the first level 1 item
 :li.this is the second level 1 item
 :ul compact.
 :li.this is the first level 2 item
 :li.this is the second level 2 item
 :li.this is the third level 2 item
 :eul.
 :eul.
.fo on

.. ------------------------------------------------------------
.3 Parameter list sample 1
.. ------------------------------------------------------------
.an SAMPLE_PLIST1

.hr Parameter list created by [=BASETITLE] code
.fo off
 .pl compact bold
 - item1
 = this is description for item 1
 - item2
 = this is description for item 2
 - item3
 = this is description for item 3
.fo on

.hr Resulting parameter list
.pl compact bold
- item1
= this is description for item 1
- item2
= this is description for item 2
- item3
= this is description for item 3

.hr Parameter list created by IPF code
.fo off
 :parml compact.
 :pt.:hp2.item1:ehp2.&rbl.
 :pd.this is description for item 1
 :pt.:hp2.item2:ehp2.&rbl.
 :pd.this is description for item 2
 :pt.:hp2.item3:ehp2.&rbl.
 :pd.this is description for item 3
 :eparml.
.fo on

.. ------------------------------------------------------------
.3 Parameter list sample 2
.. ------------------------------------------------------------
.an SAMPLE_PLIST2

.hr Parameter list created by [=BASETITLE] code
.fo off
 .pl bold break=none tsize=5
 - item1:
 = this is description for item 1
 - item2:
 = this is description for item 2
 - item3:
 = this is description for item 3
.fo on

.hr Resulting parameter list
.pl bold break=none tsize=5
- item1:
= this is description for item 1
- item2:
= this is description for item 2
- item3:
= this is description for item 3

.hr Parameter list created by IPF code
.fo off
 :parml break=none tsize=5.
 :pt.:hp2.item1&colon.:ehp2.&rbl.
 :pd.this is description for item 1
 :pt.:hp2.item2&colon.:ehp2.&rbl.
 :pd.this is description for item 2
 :pt.:hp2.item3&colon.:ehp2.&rbl.
 :pd.this is description for item 3
 :eparml.
.fo on

.hr Same list with longer text

The following notes are set with the same list attributes as above
to demonstrate how it looks with longer text:

.pl bold break=none tsize=5
- Same line:
= Compared to the previous example, the description text comes here
  on the same line as the term text.
- Common indentation:
= Following wrapped lines are indented by 5 units instead of the
  default value 10. That leads to the same indent as used by
  unordered, ordered and simple lists.
- Longer item texts:
= The above list looks good for longer term and description texts
  as well.
- Short term texts:
= For short term texts (like for descriptions of key bindings) it
  may look better to increase the #tsize# parameter. See also:
  [.SAMPLE_PLIST3].

.. ------------------------------------------------------------
.3 Parameter list sample 3
.. ------------------------------------------------------------
.an SAMPLE_PLIST3

.hr Parameter list created by [=BASETITLE] code
.fo off
 .pl bold compact break=none tsize=15
 - Ctrl+Esc
 = Open the window list.
 - Alt+F6
 = Switch to the next window belonging to the current process.
 - Esc
 = Close the window. Works for child windows only.
.fo on

.hr Resulting parameter list
.pl bold compact break=none tsize=15
- Ctrl+Esc
= Open the window list.
- Alt+F6
= Switch to the next window belonging to the current process.
- Esc
= Close the window. Works for child windows only.

.hr Parameter list created by IPF code
.fo off
 :parml bold compact break=none tsize=15.
 :pt.:hp2.Ctrl+Esc:ehp2.&rbl.
 :pd.Open the window list.
 :pt.:hp2.Alt+F6:ehp2.&rbl.
 :pd.Switch to the next window belonging to the current process.
 :pt.:hp2.Esc:ehp2.&rbl.
 :pd.Close the window. Works for child windows only.
 :eparml.
.fo on

If you want to indent your table, use the [.CMD_LMARGIN] command. It's
also possible to use a [.CMD_SLIST] with a single - sign for that, but
not recommended:

.hr Parameter list created by [=BASETITLE] code
.fo off
 .lm 5
 .pl bold compact break=none tsize=15
 - Ctrl+Esc
 = Open the window list.
 - Alt+F6
 = Switch to the next window belonging to the current process.
 - Esc
 = Close the window. Works for child windows only.

 .lm
.fo on

.hr Resulting parameter list
.lm 5
.pl bold compact break=none tsize=15
- Ctrl+Esc
= Open the window list.
- Alt+F6
= Switch to the next window belonging to the current process.
- Esc
= Close the window. Works for child windows only.

.lm

.hr Parameter list created by IPF code
.fo off
 :lm margin=5.
 :parml bold compact break=none tsize=15.
 :pt.:hp2.Ctrl+Esc:ehp2.&rbl.
 :pd.Open the window list.
 :pt.:hp2.Alt+F6:ehp2.&rbl.
 :pd.Switch to the next window belonging to the current process.
 :pt.:hp2.Esc:ehp2.&rbl.
 :pd.Close the window. Works for child windows only.
 :eparml.
 :lm margin=1.
.fo on

.. ------------------------------------------------------------
.3 Code macro sample
.. ------------------------------------------------------------
.an SAMPLE_CODE_MACRO

.hr [=BASETITLE] code

.fo off
 .set mytt=.at fc=darkgreen|.lm 5|.fo off
 .set /mytt=.fo on|.lm|.at fc=default|.par

 Now using the defined environment with .get:
 .get mytt
 Some text.
 Another line of text.
 .get /mytt

 Now using the defined environment with text replacement links:
 [[=mytt]]
 Some text.
 Another line of text.
 [[=/mytt]]
.fo on

.hr Resulting text

.set mytt=.at fc=darkgreen|.lm 5|.fo off
.set /mytt=.fo on|.lm|.at fc=default|.par

Now using the defined environment with .get:
.get mytt
Some text.
Another line of text.
.get /mytt

Now using the defined environment with text replacement links:
[=mytt]
Some text.
Another line of text.
[=/mytt]

.hr IPF code

.fo off
 Now using the defined environment with .get&colon.
 :color fc=darkgreen.
 :lm margin=5.
 :xmp.
 Some text.
 Another line of text.
 :exmp.
 :lm margin=1.
 :color fc=default.
 :p.
 Now using the defined environment with text replacement links&colon.
 :color fc=darkgreen.
 :lm margin=5.
 :xmp.
 Some text.
 Another line of text.
 :exmp.
 :lm margin=1.
 :color fc=default.
.fo on

.. ------------------------------------------------------------
.3 Nested environment variables sample
.. ------------------------------------------------------------
.an SAMPLE_NESTED_ENV_VARS

.hr [=BASETITLE] code

.fo off
 .set var1=bold text
 .set var2=**[[=var1]]**
 .set var3=text with [[=var2]] included
 Even redefinition is possible before its final usage:
 .set var1=##italic text##

 Now using var3 in both ways:
 .
 .get var3
 .
 [[=var3]]

 The content of var1 is now: [[=var1]]
.fo on

.hr Resulting text

.set var1=bold text
.set var2=*[=var1]*
.set var3=text with [=var2] included
Even redefinition is possible before its final usage:
.set var1=#italic text#

Now using var3 in both ways:
.
.get var3
.
[=var3]

The content of var1 is now: [=var1]

.hr IPF code

.fo off
 Even redefinition is possible before its final usage:
 :p.
 Now using var3 in both ways&colon.
 .br
 text with :hp2.bold text:ehp2. included
 .br
 text with :hp2.bold text:ehp2. included
 :p.
 The content of var1 is now&colon. :hp1.italic text:ehp1.
.fo on

