/*
================================================================================
                        Texinfo converting Tools
                         Release 1.00 28.03.97
                       (c) 1996 by Andreas Kaiser
                    (c) 1997 by Karl Heinz Marbaise
================================================================================

Discription:
    Mainprogram for the Texinfo to IPF converter.

Authors:
   Andreas Kaiser
   Karl Heinz Marbaise

e-mail:
   Internet: KHMarbaise@p69.ks.fido.de
   Fido-net: 2:2452/117.69

Bugs, question:
   to above e-mail adress.

Register:
   Please send a e-mail to above adress to register.
   (include the release you want to register)
   This registration should be done to let me
   know how many people using these tools and
   if it is worth to invest more time in continuing
   development these tools or let the first release
   of them be the last.
   That is the only reason to make a registration.
   I think a e-mail is not to much, isn't it?

License:
   The "Texinfo converting tools" are free software;
   you can redistribute it and/or modify it under the terms of
   the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option)
   any later version.

   The "Texinfo converting tools" are distributed in the hope that
   they will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the "Texinfo converting tools" ; see the file COPYING.
   If not, write to the:
   Free Software Foundation,
   59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   See \texicvt1.00\COPYING for details.

================================================================================
*/

/*
------------------------------------------------------------------------------
                      (R)evision (C)ontrol (S)ystem
------------------------------------------------------------------------------
*/

#if defined (__RCS__)
static char *main_cc = "$Id: MAIN.CC 1.8 1997/03/30 15:08:19 KHM Exp $";
#endif

#define EXTERN
#define INIT(x) = x
#include "info.h"
#include <fstream.h>
#include <stdio.h>
#include <ctype.h>
#if defined (__EMX__)
#include <getopt.h>
#include <process.h> /* spawnlp () */
#else
#include <GetOpt.h>
#endif

#include "version.h"

void usage()
{
	cout <<"texi2ipf [options {in [out]]" << endl
	     <<" -Dflag	set Texinfo flag" << endl
	     <<" -Uflag	clear Texinfo flag" << endl
	     <<" -i	create IPF index" << endl
	     <<" -n	use @node to split into panels, not @chapter" << endl
	     <<" -d	debugging aid" << endl
	     <<" -f	flex scanner trace" << endl
	     <<" -v	print out version, copyright and" << endl
             <<"        copying conditions." << endl
	     <<" in	texinfo file, default=stdin" << endl
	     <<" out	inf file (*.inf) or ipf source (else)" << endl;
}

main(int argc, char **argv)
{
        int c;
	int compile = 0;
        int direct = 0;
        char *fn = (char *)NULL;
#if defined (__EMX__)
        char s[_MAX_PATH];
        char drive[_MAX_DRIVE];
        char dir[_MAX_DIR];
        char file[_MAX_FNAME];
        char ext[_MAX_EXT];
#endif
	ofstream *outf = 0;

	extern int yy_flex_debug;

	yy_flex_debug = 0; /* usualy we don't put out debug information */

        f_node = 0; /* use chapter */
        f_index = 0; /* don't create index */

        IncludeFile = 0;

#if defined (__EMX__)
        GetOpt getopt(argc, argv, "?hdD:finU:ov");
#else
        GetOpt getopt(argc, argv, "?hdD:finU:v");
#endif
	for (c = 0; (c = getopt()) != EOF; )
		switch (c) {
                case 'o':
                        direct = 1;
                        break;
		case 'd':
			++debug;
			break;
		case 'D':
			flags[(String &)getopt.optarg] = 1;
			break;
		case 'f':
			++yy_flex_debug;
			break;
		case 'i':
			++f_index;
			break;
		case 'n':
			++f_node;
			break;
		case 'U':
			flags[(String &)getopt.optarg] = (const char *)0;
			break;
                case 'v':
                        PrintCopyright ();
                case '?':
                case 'h':
		default:
			usage();
			exit(2);
		}
	if (getopt.optind < argc) {
                fn = argv[getopt.optind];
		if (freopen(fn, "r", stdin) == NULL) {
			perror(fn);
			exit(1);
		}
	}
	String ipfname, basename;


#if defined (__EMX__)
        if (direct)
        {
            sprintf (s, fn);
            /* might not work on other systems like linux ! */
            _splitpath(s,drive,dir,file,ext);
            _makepath (s,drive,dir,file,".ipf");
            fprintf (stderr, "converting %s to %s\n", fn, s);
	    out = outf = new ofstream(s);
	    if (!outf->good()) {
		    perror(s);
		    exit(1);
	    }
        }
#endif
	if (++getopt.optind < argc) {
		ipfname = argv[getopt.optind];
		int ext = ipfname.index('.', -1);
		if (ext >= 0) {
			basename = ipfname.before(ext);
			if (fcompare(ipfname.from(ext), ".inf") == 0) {
				compile = 1;
				ipfname.from(ext) = ".ipf";
			}
		}
		out = outf = new ofstream(ipfname);
		if (!outf->good()) {
			perror(ipfname);
			exit(1);
		}
	}

        *out << ".* " << RELEASENAME << endl;
        *out << ".* " << COPYRIGHT << endl;

	*out << ":userdoc." << endl
	     << ":docprof toc=123456." << endl;


	while ((c = yylex()) > 0)
		if (c == '\n')
			newline();
		else
			PUTS((char)c);

	*out << ":euserdoc." << endl;

	if (outf) {
		outf->close();
        if (IncludeFile)
            cerr << endl;
#if defined(__EMX__)
		if (compile) {
			Regex rpath ("[:\\\\/]");
			int split = basename.index(rpath, -1);
			if (split >= 0) {
				String path (basename.through(split));
				_chdrive(toupper(path[0])); // EMX library bug
				_chdir2(path);
				basename.del(0, split + 1);
			}
			int r = spawnlp(0, "ipfc", "ipfc",
				"/w1", "/codepage=850", "/inf",
				basename.chars(), NULL);
			if (r < 0) {
				perror("starting ipfc");
				exit(1);
			} else if (r == 0) {
				basename += ".ipf";
				remove(basename);
			}
		}
#endif
	}

	return c ? 1 : 0;
}

