/*
================================================================================
                        Texinfo converting Tools
                         Release 1.00 28.03.97
                       (c) 1996 by Andreas Kaiser
                    (c) 1997 by Karl Heinz Marbaise
================================================================================

Discription:
    Mainprogramm for Texinfo to RTF converter

Authors:
   Andreas Kaiser
   Karl Heinz Marbaise

e-mail:
   Internet: KHMarbaise@p69.ks.fido.de
   Fido-net: 2:2452/117.69

Bugs, question:
   to above e-mail adress.

Register:
   Please send a e-mail to above adress to register.
   (include the release you want to register)
   This registration should be done to let me
   know how many people using these tools and
   if it is worth to invest more time in continuing
   development these tools or let the first release
   of them be the last.
   That is the only reason to make a registration.
   I think a e-mail is not to much, isn't it?

License:
   The "Texinfo converting tools" are free software;
   you can redistribute it and/or modify it under the terms of
   the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option)
   any later version.

   The "Texinfo converting tools" are distributed in the hope that
   they will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the "Texinfo converting tools" ; see the file COPYING.
   If not, write to the:
   Free Software Foundation,
   59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   See \texicvt1.00\COPYING for details.

================================================================================
*/


/*
------------------------------------------------------------------------------
                      (R)evision (C)ontrol (S)ystem
------------------------------------------------------------------------------
*/

#ifdef __RCS__
static const char *mainrtf_cc = "$Id: MAINRTF.CC 1.5 1997/03/30 15:08:20 KHM Exp $";
#endif

/*--------------------------------------------------------------------------*/
/*                             Include Files                                */
/*--------------------------------------------------------------------------*/

#define EXTERN
#define INIT(x) = x
#include "info.h"
#include <fstream.h>
#include <stdio.h>
#include <ctype.h>
#if defined (__EMX__)
#include <getopt.h>
#else
#include <GetOpt.h>
#endif

#include "version.h"

void
usage()
{
	cout <<"texi2rtf [options {in [out]]" << endl
	     <<" -Dflag	set Texinfo flag" << endl
	     <<" -Uflag	clear Texinfo flag" << endl
	     <<" -i	create IPF index" << endl
	     <<" -n	use @node to split into panels, not @chapter" << endl
	     <<" -d	debugging aid" << endl
	     <<" -f	flex scanner trace" << endl
	     <<" -v	print out version, copyright and" << endl
             <<"        copying conditions." << endl
	     <<" in	texinfo file, default=stdin" << endl
	     <<" out	inf file (*.inf) or ipf source (else)" << endl;
}

main(int argc, char **argv)
{
        int c;
	int compile = 0;
        int direct = 0;
        char *fn = (char *)NULL;
#if defined (__EMX__)
        char s[_MAX_PATH];
        char drive[_MAX_DRIVE];
        char dir[_MAX_DIR];
        char file[_MAX_FNAME];
        char ext[_MAX_EXT];
#endif
	ofstream *outf = 0;

	extern int yy_flex_debug;
	yy_flex_debug = 0;

        f_node = 0; /* use chapter */
        f_index = 0; /* don't create index */

        IncludeFile = 0;
#if defined (__EMX__)
        GetOpt getopt(argc, argv, "?hdD:finU:ov");
#else
        GetOpt getopt(argc, argv, "?hdD:finU:v");
#endif
	for (c = 0; (c = getopt()) != EOF; )
		switch (c) {
                case 'o':
                        direct = 1;
                        break;
		case 'd':
			++debug;
			break;
		case 'D':
			flags[getopt.optarg] = 1;
			break;
		case 'f':
			++yy_flex_debug;
			break;
		case 'i':
			++f_index;
			break;
		case 'n':
			++f_node;
			break;
		case 'U':
			flags[getopt.optarg] = (const char *)0;
			break;
                case 'v':
                        PrintCopyright ();
                case '?':
                case 'h':
		default:
			usage();
			exit(2);
		}
	if (getopt.optind < argc) {
                fn = argv[getopt.optind];
		if (freopen(fn, "r", stdin) == NULL) {
			perror(fn);
			exit(1);
		}
	}
	String ipfname, basename;

#if defined (__EMX__)
        if (direct)
        {
            sprintf (s, fn);
            _splitpath(s,drive,dir,file,ext);
            _makepath (s,drive,dir,file,".rtf");
            fprintf (stderr, "converting %s to %s\n", fn, s);
	    out = outf = new ofstream(s);
	    if (!outf->good()) {
		    perror(s);
		    exit(1);
	    }
        }
#endif
	if (++getopt.optind < argc) {
		ipfname = argv[getopt.optind];
		int ext = ipfname.index('.', -1);
		if (ext >= 0) {
			basename = ipfname.before(ext);
			if (fcompare(ipfname.from(ext), ".inf") == 0) {
				compile = 1;
				ipfname.from(ext) = ".ipf";
			}
		}
		out = outf = new ofstream(ipfname);
		if (!outf->good()) {
			perror(ipfname);
			exit(1);
		}
	}

*out << "{\\rtf1\\ansi \\deff4\\deflang1033{\\fonttbl" << endl;
*out << "{\\f4\\froman\\fcharset0\\fprq2 Times New Roman;}}" << endl;
*out << "{\\colortbl;\\red0\\green0\\blue0;" << endl;
*out << "\\red0\\green0\\blue255;" << endl;
*out << "\\red0\\green255\\blue255;" << endl;
*out << "\\red0\\green255\\blue0;" << endl;
*out << "\\red255\\green0\\blue255;" << endl;
*out << "\\red255\\green0\\blue0;" << endl;
*out << "\\red255\\green255\\blue0;" << endl;
*out << "\\red255\\green255\\blue255;" << endl;
*out << "\\red0\\green0\\blue128;" << endl;
*out << "\\red0\\green128\\blue128;" << endl;
*out << "\\red0\\green128\\blue0;" << endl;
*out << "\\red128\\green0\\blue128;" << endl;
*out << "\\red128\\green0\\blue0;" << endl;
*out << "\\red128\\green128\\blue0;" << endl;
*out << "\\red128\\green128\\blue128;" << endl;
*out << "\\red192\\green192\\blue192;}" << endl;
*out << "{\\stylesheet{\\f4\\fs20\\lang1031 \\snext0 Normal;}" << endl;
*out << "{\\*\\cs10 \\additive Default Paragraph Font;}" << endl;
*out << "{\\s15 \\f4\\fs20\\lang1031 \\sbasedon0\\snext15 footnote text;}" << endl;
*out << "{\\*\\cs16 \\additive\\super \\sbasedon10 footnote reference;}}" << endl;
*out << "{\\info{\\author Marbaise Karl Heinz}" << endl;
*out << "{\\creatim\\yr1997\\mo3\\dy2\\hr22\\min31}" << endl;
*out << "{\\version1}{\\edmins0}" << endl;
*out << "{\\nofpages0}" << endl;
*out << "{\\nofwords0}" << endl;
*out << "{\\nofchars0}" << endl;
*out << "{\\vern49205}}" << endl;
*out << "\\paperw11906\\paperh16838\\margl1417\\margr1417\\margt1417\\margb1134" << endl;
*out << "\\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\formshade" << endl;
*out << "\\fet0\\sectd" << endl;
*out << "\\linex0\\headery709\\footery709\\colsx709\\endnhere" << endl;
*out << "{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}" << endl;
*out << "{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}" << endl;
*out << "{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}" << endl;
*out << "{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}" << endl;
*out << "{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}" << endl;
*out << "{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}" << endl;
*out << "{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}" << endl;
*out << "{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}" << endl;
*out << "{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}" << endl;
*out << "{\\comment " << RELEASENAME << " }" <<  endl;
*out << "{\\comment " << COPYRIGHT << " }" << endl;
*out << "\\pard\\plain" << endl;

	while ((c = yylex()) > 0)
        {
		if (c == '\n')
                     /* *out << endl << "\\par "; */
			newline (); /**out << endl;*/
                else
                    PUTS ((char)c); /* *out << (char)c; */
        }

        *out << "\\par }" << endl;

        if (outf)
            outf->close();

        if (IncludeFile)
            cerr << endl;

	return c ? 1 : 0;
}
