#=======================================================
#
# Configuration specific to the Gnu Compiler Collection
#
#=======================================================

# Define the C and C++ compilers

CC = gcc
CCC = gcc

# Define the compiler version.  (This is mostly to distinguish
# between constructs valid in 3.X versions from those of 2.9.)

CV = 32


# ------------- CPU type and target system architecture --------------
#
# This probably needs to be separated out somewhere because different
# versions of the compiler support different target CPU optimisations.
# For now, I am generating Pentium-II code.
#
# --------------------------------------------------------------------

arch = i686
cpu  = pentium3

# ------------- Optimisations for specific compilers ---------------
#
# ------------------------------------------------------------------

optflags = -funroll-loops -malign-strings=2 -fomit-frame-pointer

# Do not define MAKE_SH if you want to use the standard command processor

.IF $(MAKE_SH) == $(NULL)

SHELL       := $(COMSPEC)
SHELLFLAGS  := /c
GROUPFLAGS  := $(SHELLFLAGS)
SHELLMETAS  := *"?<>|&
DIVFILE      = $(TMPFILE:s,/,\)

# This is nonsense and doesn't distinguish between OS/2 and Windows 2000
# because they both use CMD.EXE as a command processor.

#.IF $(COMSPEC:s,.,/,:f) == COM
#GROUPSUFFIX := .bat
#WINDOWS     := 1
#.ELIF $(COMSPEC:s,.,/,:f) == com
#GROUPSUFFIX := .bat
#WINDOWS     := 1
#.ELSE
#GROUPSUFFIX := .cmd
#OS2         := 1
#.END

# This is more robust but it may not be needed at all.

.IF $(OS) == win32
WINDOWS = 1
.ELIF $(OS) == os2
OS2 = 1
.ENDIF

# Define MAKE_SH (path name) to use a Unix-like shell

.ELSE

SHELL       := $(MAKE_SH)
SHELLFLAGS  := -c
GROUPFLAGS  :=
SHELLMETAS  := *"?<>|()&][$$\#`'
GROUPSUFFIX := .sh
DIVFILE      = $(TMPFILE:s,/,${DIVSEP_shell_${USESHELL}})
DIVSEP_shell_yes := \\\
DIVSEP_shell_no  := \\

.END

GROUPSHELL  := $(SHELL)

.USESHELL :

.SILENT := $(__.SILENT)
